/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 *	MicroSoft QuickC
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<signal.h>
#include<process.h>

#define DLLSBREG 0
#define DLMSBREG 1
#define INTCTLREG 1
#define INTIDREG 2
#define LCTLREG 3
#define MCTLREG 4
#define STATREG 5
#define MSTATREG 6

#define DCDMASK 0x80
#define CTSMASK 0x10
#define TXMTMASK 0x20
#define RXRDYMASK 0x01

#define INTACK 0x20

#define DB7 0x02
#define DB8 0x03
#define STOP2 0x04
#define PARITYEN 0x08
#define PARITYEVEN 0x10
#define DLAB 0x80

#define INTBASE1 0x20
#define INTMASK1 0x21
#define INTBASE2 0xa0
#define INTMASK2 0xa1

#define TBUFSIZ 256

#define NAK 21
#define ACK 6
#define SOH 1
#define EOT 4

int index, basereg;
unsigned char buf[TBUFSIZ];
unsigned char diffintmask, irqnum;
void (interrupt far *oldvect)();

void interrupt far inthndl(_es, _ds, _di, _si, _bp, _sp,
			  _bx, _dx, _cx, _ax, _ip, _cs, _flags)
	unsigned _es, _ds, _di, _si, _bp, _sp;
	unsigned _bx, _dx, _cx, _ax, _ip, _cs, _flags;
	{
	if(inp(basereg+STATREG)&RXRDYMASK)
		{
		buf[index++]=inp(basereg)&0xff;
		index=index%TBUFSIZ;
		}
	outp(INTBASE1, INTACK);
	outp(INTBASE2, INTACK);
	}

unsigned intnum;
unsigned char oldintmask;
unsigned char oldlctl, olddllsb, olddlmsb, oldintctl, oldmctl;

cleanup()
	{
	if(intnum==10)
		outp(INTMASK2, oldintmask);
	else
		outp(INTMASK1, oldintmask);
	outp(basereg+LCTLREG, DLAB);
	outp(basereg+DLLSBREG, olddllsb);
	outp(basereg+DLMSBREG, olddlmsb);
	outp(basereg+LCTLREG, oldlctl);
	outp(basereg+INTCTLREG, oldintctl);
	outp(basereg+MCTLREG, oldmctl);
	_dos_setvect(intnum, oldvect);
	}

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)))
		if(kbhit())
			getch();
	outp(basereg, c);
	}

int follow;

quit()
	{
	cleanup();
	exit(99);
	}

sendstr(str)
	char *str;
	{
	int i;
	for(i=0;str[i]!='\0';++i)
		if(str[i]=='\n')
			{
			sendchar('\r');
			sendchar('\n');
			}
		else
			sendchar(str[i]);
	}

portgets(str)
	char *str;
	{
	int i;
	i=0;
	while(i<256)
		{
		while(follow==index)
			{
			if(!(inp(basereg+MSTATREG)&DCDMASK))
				return(-1);
			if(kbhit())
				getch();
			}
		str[i]=buf[follow++];
		if(str[i]=='\b')
			if(i>0)
				{
				i-=2;
				sendchar('\b');
				sendchar(' ');
				sendchar('\b');
				}
			else
				{
				i--;
				sendchar(0x07);
				}
		else
			sendchar(str[i]);
		follow%=TBUFSIZ;
		if((str[i]=='\r')||(str[i]=='\n'))
			{
			sendchar('\r');
			sendchar('\n');
			str[i]='\0';
			break;
			}
		i++;
		}
	str[256]='\0';
	return(0);
	}
		
pwportgets(str)
	char *str;
	{
	int i;
	i=0;
	while(i<256)
		{
		while(follow==index)
			{
			if(!(inp(basereg+MSTATREG)&DCDMASK))
				return(-1);
			if(kbhit())
				getch();
			}
		str[i]=buf[follow++];
		if(str[i]=='\b')
			if(i>0)
				{
				i-=2;
				sendchar('\b');
				sendchar(' ');
				sendchar('\b');
				}
			else
				{
				i--;
				sendchar(0x07);
				}
		else
			sendchar('.');
		follow%=TBUFSIZ;
		if((str[i]=='\r')||(str[i]=='\n'))
			{
			sendchar('\r');
			sendchar('\n');
			str[i]='\0';
			break;
			}
		i++;
		}
	str[256]='\0';
	return(0);
	}

unsigned char newintmask, lctl, dlmsb, dllsb;

setup()
	{
	outp(basereg+LCTLREG, DLAB);
	olddllsb=inp(basereg+DLLSBREG);
	olddlmsb=inp(basereg+DLMSBREG);
	outp(basereg+DLLSBREG, dllsb);
	outp(basereg+DLMSBREG, dlmsb);
	oldlctl=inp(basereg+LCTLREG);
	outp(basereg+LCTLREG, lctl);
	_dos_setvect(intnum, inthndl);
	oldintctl=inp(basereg+INTCTLREG);
	outp(basereg+INTCTLREG, 0x00);
	oldmctl=inp(basereg+MCTLREG);
	outp(basereg+MCTLREG, 0x0b);
	newintmask=diffintmask;
	newintmask&=oldintmask;
	if(intnum==10)
		outp(INTMASK2, newintmask);
	else
		outp(INTMASK1, newintmask);
	outp(INTBASE1, INTACK); /* Clean up leftovers */
	outp(INTBASE2, INTACK);
	outp(basereg+INTCTLREG, 0x01);
	outp(INTBASE1, INTACK); /* What a zoo! */
	outp(INTBASE2, INTACK);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	long timestamp;
	int i, j, outfd, ok, c, run, result;
	unsigned speed;
	int comnum;
	char str[256];
	index=follow=0;
	lctl=0;
	printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be already logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run HOST? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("I didn't think so!\n");
			exit(99);
			}
		else
			printf("OK, you're the boss!");
		}
	if(argc!=4)
		{
		printf("USAGE: host <comnum> <bps> <password>\n");
		exit(1);
		}
	printf("Control-C to Exit.\n");
	comnum=atoi(argv[1])-1;
	newintmask=0;
	switch(comnum)
		{
		case 0:
			irqnum=4;
			diffintmask=0xff&~0x10;
			basereg=0x3f8;
			break;
		case 1:
			irqnum=3;
			diffintmask=0xff&~0x08;
			basereg=0x2f8;
			break;
		case 2:
			irqnum=4;
			diffintmask=0xff&~0x10;
			basereg=0x3e8;
			break;
		case 3:
			irqnum=3;
			diffintmask=0xff&~0x08;
			basereg=0x2e8;
			break;
		case 4:
			irqnum=2;
			diffintmask=0xff&~0x02;
			basereg=0x3e8;
			break;
		case 5:
			irqnum=2;
			diffintmask=0xff&~0x02;
			basereg=0x2e8;
			break;
		case 6:
			irqnum=5;
			diffintmask=0xff&~0x20;
			basereg=0x3e8;
			break;
		case 7:
			irqnum=5;
			diffintmask=0xff&~0x20;
			basereg=0x2e8;
			break;
		default:
			printf("Bad port choice.\n");
			exit(4);
		}
	intnum=irqnum+8;
	speed=atoi(argv[2]);
	switch(speed)
		{
		case 300:
			dlmsb=0;
			dllsb=0xc0;
			break;
		case 1200:
			dlmsb=0;
			dllsb=0x60;
			break;
		case 2400:
			dlmsb=0;
			dllsb=0x30;
			break;
		case 9600:
			dlmsb=0;
			dllsb=0x0c;
			break;
		case 19200:
			dlmsb=0;
			dllsb=0x06;
			break;
		case 38400:
			dlmsb=0;
			dllsb=0x03;
			break;
		case 57600:
			dlmsb=0;
			dllsb=0x02;
			break;
		default:
			printf("Bad speed.\n");
			exit(5);
		}
	lctl|=DB8;
	oldvect=_dos_getvect(intnum);
	oldintmask=(intnum==10)?inp(INTMASK2):inp(INTMASK1);
	signal(SIGINT, quit);
	outp(basereg+MCTLREG, 0x03); /* Set DTR, RTS, Int. En. */
	while(1)
		{
		printf("Awaiting carrier.\n");
		while(!(inp(basereg+MSTATREG)&DCDMASK))
			if(kbhit())
				getch();
		printf("Carrier detected.\n");
		setup();
		timestamp=time(NULL);
		while((time(NULL)-timestamp)<3);
		follow=index;
		for(i=0;i<3;++i)
			{
			sprintf(str, "Password? --> ");
			sendstr(str);
			if(pwportgets(str)==-1)
				{
				run=0;
				break;
				}
			else if(!strcmp(str, argv[3]))
				{
				run=1;
				break;
				}
			else
				run=0;
			}
		while(run)
			{
			follow=index; /* flush input */
			sendstr("\n\n     DOWNLOAD:  (1) Xmodem   (2) Xmodem CRC   (3) Xmodem CRC 1K\n\n");
			sendstr("       UPLOAD:  (4) Xmodem   (5) Xmodem CRC 1K Optional\n\n");
			sendstr("          (s) Shell        (q) Quit        (^R) Reload HOST\n\n             ---> ");
			while(index==follow)
				{
				if(!(inp(basereg+MSTATREG)&DCDMASK))
					{
					run=0;
					break;
					}
				if(kbhit())
					getch();
				}
			if(!run)
				break;
			c=buf[follow++];
			follow%=TBUFSIZ;
			switch(c)
				{
				case 18:
					sendstr("Reload HOST\n");
					cleanup();
					execlp("host", "host", argv[1], argv[2], argv[3], NULL);
					break;
				case 'q':
				case 'Q':
					sendstr("Quit\n");
					run=0;
					break;
				case 's':
				case 'S':
					sendstr("Shell\n");
					printf("Entering command.com remote shell.\n");
					sprintf(str, "COM%d", comnum+1);
					putenv("PROMPT=REMOTE>$p$g");
					putenv("REMOTE=YES");
					spawnlp(P_WAIT, "c:\\command.com", "command.com", str, "/e:01024", NULL);
					putenv("REMOTE=NO");
					setup();
					break;
				case '1':
					sendstr("Xmodem Download.\nSource file pathname? (Blank to cancel)\n --> ");
					if((result=portgets(str))==-1)
						{
						run=0;
						break;
						}
					if(!strlen(str))
						break;
					result=spawnlp(P_WAIT, "xmodems", "xmodems", argv[1], argv[2], "1", str, NULL);
					setup();
					sendstr("Press any key to continue: --> ");
					while(follow==index)
						{
						if(!(inp(basereg+MSTATREG)&DCDMASK))
							{
							run=0;
							break;
							}
						if(kbhit())
							getch();
						}
					follow=index;
					sprintf(str, "Exit code = %d.\n", result);
					sendstr(str);
					break;
				case '2':
					sendstr("Xmodem CRC Download.\nSource file pathname? (Blank to cancel)\n --> ");
					if((result=portgets(str))==-1)
						{
						run=0;
						break;
						}
					if(!strlen(str))
						break;
					result=spawnlp(P_WAIT, "xmcrcs", "xmcrcs", argv[1], argv[2], "1", str, NULL);
					setup();
					sendstr("Press any key to continue: --> ");
					while(follow==index)
						{
						if(!(inp(basereg+MSTATREG)&DCDMASK))
							{
							run=0;
							break;
							}
						if(kbhit())
							getch();
						}
					follow=index;
					sprintf(str, "Exit code = %d.\n", result);
					sendstr(str);
					break;
				case '3':
					sendstr("Xmodem CRC 1k Download.\nSource file pathname? (Blank to cancel)\n --> ");
					if((result=portgets(str))==-1)
						{
						run=0;
						break;
						}
					if(!strlen(str))
						break;
					result=spawnlp(P_WAIT, "xmcrc1ks", "xmcrc1ks", argv[1], argv[2], "1", str, NULL);
					setup();
					sendstr("Press any key to continue: --> ");
					while(follow==index)
						{
						if(!(inp(basereg+MSTATREG)&DCDMASK))
							{
							run=0;
							break;
							}
						if(kbhit())
							getch();
						}
					follow=index;
					sprintf(str, "Exit code = %d.\n", result);
					sendstr(str);
					break;
				case '4':
					sendstr("Xmodem Upload.\nTarget file pathname? (Blank to cancel)\n --> ");
					if((result=portgets(str))==-1)
						{
						run=0;
						break;
						}
					if(!strlen(str))
						break;
					result=spawnlp(P_WAIT, "xmodemr", "xmodemr", argv[1], argv[2], "1", str, NULL);
					setup();
					sendstr("Press any key to continue: --> ");
					while(follow==index)
						{
						if(!(inp(basereg+MSTATREG)&DCDMASK))
							{
							run=0;
							break;
							}
						if(kbhit())
							getch();
						}
					follow=index;
					sprintf(str, "Exit code = %d.\n", result);
					sendstr(str);
					break;
				case '5':
					sendstr("Xmodem CRC Upload, 1k Optional.\nTarget file pathname? (Blank to cancel)\n --> ");
					if((result=portgets(str))==-1)
						{
						run=0;
						break;
						}
					if(!strlen(str))
						break;
					result=spawnlp(P_WAIT, "xmcrc1kr", "xmcrc1kr", argv[1], argv[2], "1", str, NULL);
					setup();
					sendstr("Press any key to continue: --> ");
					while(follow==index)
						{
						if(!(inp(basereg+MSTATREG)&DCDMASK))
							{
							run=0;
							break;
							}
						if(kbhit())
							getch();
						}
					follow=index;
					sprintf(str, "Exit code = %d.\n", result);
					sendstr(str);
					break;
				}
			}
		printf("Dropping DTR for about 5 seconds.\n");
		/* Drop DTR to hang up */
		outp(basereg+MCTLREG, 0x08);
		timestamp=time(NULL);
		while(time(NULL)-timestamp<5)
			if(kbhit())
				getch();
		outp(basereg+MCTLREG, 0x0b);
		cleanup();
		}
	}
