#include<stdio.h>

#define PROGSIZ 256

struct
	{
	char type;
	unsigned char label;
	}
	miniprog[PROGSIZ];

main(argc, argv)
	int argc;
	char **argv;
	{
	FILE *scriptfd;
	char fpname[256], str[81];
	int proglen, i, value[8], flag;
	short int labels[256];
	if(argc!=2)
		{
		printf("USAGE: scrchk <sourcefile>");
		exit(1);
		}
	if(getenv("TERMPATH")==NULL)
		sprintf(fpname, "%s.scr", argv[1]);
	else
		sprintf(fpname, "%s\\%s.scr", getenv("TERMPATH"), argv[1]);
	if((scriptfd=fopen(fpname, "r"))==NULL)
		{
		printf("Error opening script file %s.\n", fpname);
		exit(2);
		}
	fgets(str, 80, scriptfd); /* Flush init params */
	for(i=0;i<256;++i)
		labels[i]=-1;
	/* Parse */
	printf("Parsing...\n");
	for(proglen=0;proglen<PROGSIZ;++proglen)
		{
		if(fgets(str, 80, scriptfd)==NULL)
			{
			flag=1;
			proglen++;
			break;
			}
		for(i=0;i<80;++i)
			if(str[i]=='\n')
				{
				str[i]='\0';
				break;
				}
			else if(str[i]=='\0')
				break;
		if(!strlen(str))
			{
			printf("---\n");
			proglen--;
			}
		else
			{
			if((str[0]!=':')&&(str[0]!=';'))
				printf("%03d %s\n", proglen, str);
			else
				printf("--- %s\n", str);
			if((str[0]!=';')&&(str[1]!=' '))
				{
				printf("*** Missing first delimiting space.\n");
				exit(11);
				}
			switch(str[0])
				{
				case ':':
					if(sscanf(str, "%*c %d", &value[0])!=1)
						{
						printf("*** Bad scan of label (:)\n");
						exit(11);
						}
					if((value[0]<0)||(value[0]>255))
						{
						printf("*** Label out of range\n");
						exit(11);
						}
					if(labels[value[0]]!=-1)
						{
						printf("*** Label duplicated\n", value[0], proglen);
						exit(11);
						}
					labels[value[0]]=proglen;
					proglen--;
					break;
				case 'g':
				case 'G':
					miniprog[proglen].type='g';
					if(sscanf(str, "%*c %d", &value[0])!=1)
						{
						printf("*** Bad scan\n");
						exit(11);
						}
					miniprog[proglen].label=(unsigned char)value[0];
					break;
				case 'r':
				case 'R':
					miniprog[proglen].type='r';
					if(sscanf(str, "%*c %d %d", &value[0], &value[1])!=2)
						{
						printf("*** Bad scan\n");
						exit(11);
						}
					miniprog[proglen].label=(unsigned char)value[0];
					break;
				case 'p':
				case 'P':
					miniprog[proglen].type='p';
					if(sscanf(str, "%*c %d", &value[0])!=1)
						{
						printf("*** Bad scan\n");
						exit(11);
						}
					break;
				case '>':
					miniprog[proglen].type='>';
					if(sscanf(str, "%*c %d", &value[0])!=1)
						{
						printf("*** Bad scan\n");
						exit(11);
						}
					miniprog[proglen].label=(unsigned char)value[0];
					break;
				case '?':
					miniprog[proglen].type='?';
					if(sscanf(str, "%*c %d", &value[0])!=1)
						{
						printf("*** Bad scan\n");
						exit(11);
						}
					miniprog[proglen].label=value[0];
					break;
				case '<':
					miniprog[proglen].type='<';
					break;
				case '!':
					miniprog[proglen].type='!';
					break;
				case 's':
					miniprog[proglen].type='s';
					if(sscanf(str, "%*c %d", &value[0])!=1)
						{
						printf("*** Bad scan\n");
						exit(11);
						}
					miniprog[proglen].label=value[0];
					break;
				case 'q':
				case 'Q':
					miniprog[proglen].type='q';
					if(sscanf(str, "%*c %d", &value[0])!=1)
						{
						printf("*** Bad scan\n");
						exit(11);
						}
					if((value[0]<128)||(value[0]==0))
						{
						printf("*** Quit with reserved exit code (!=0&&<128)\n");
						exit(11);
						}
					break;
				case ';':
					proglen--;
					break;
				default:
					printf("*** Bad command character\n");
					exit(10);
				}
			}
		}
	if(!flag)
		{
		printf("Program too long.\n");
		exit(11);
		}
	/* Check labels */
	printf("\n\nChecking branch label validity...\n");
	for(i=0;i<proglen;i++)
		switch(miniprog[i].type)
			{
			case 'g':
			case '?':
				if(labels[miniprog[i].label]==-1)
					printf("Unlisted label %d at statement %d (%c).\n", miniprog[i].label, i, miniprog[i].type);
				break;
			case 'r':
				if(labels[miniprog[i].label]==-1)
					printf("Unlisted label %d at statement %d (%c).\n", miniprog[i].label, i, miniprog[i].type);
				break;
			case '>':
				if(labels[miniprog[i].label]==-1)
					printf("Unlisted label %d at statement %d (%c).\n", miniprog[i].label, i, miniprog[i].type);
				break;
			case 's':
				if(labels[miniprog[i].label]==-1)
					printf("Unlisted label %d at statement %d (%c).\n", miniprog[i].label, i, miniprog[i].type);
				break;
			}
	printf("\nDone.\n");
	}
