{$U-,C-,R-}
PROGRAM wxterm;
{
Scott Murphy
77 So. Adams St. #301
Denver, CO 80209
Compuserve 70156,263
}
CONST
     VERSION = '3.0';
     BELL_FREQ = 440;                  {frequncy for bell sound}
     BELL_DELAY = 100;                 {duration of bell sound}
     DEFAULT_BAUD = 1200;               {Serial port speed at start-up}

TYPE
    bigstring        = STRING[80];    {general purpose}
    cset              = SET OF 0..127;
VAR
   pcjrmode              : BOOLEAN;
   exit,
   xtnd  : BOOLEAN;
   a     : Byte;
   c,i   : INTEGER;
   ch : CHAR;

{$C-,R-,U-,K-}
{$I WXTMPORT.INC}
{$I WXTMMISC.INC}

PROCEDURE processcom;
VAR
   c    :   INTEGER;
BEGIN
     c := cgetc(0);
     CASE c OF
         -1 : BEGIN
              END; {no action}
          9 : {tab}
              BEGIN
                   FOR c := WhereX TO (WhereX DIV 8 + 1)*8 DO
                       WRITE(' ');
                   c := 9
              END;
          7 : {bell}
               BEGIN
                    Sound(BELL_FREQ);
                    Delay(BELL_DELAY);
                    NoSound
               END;
          12 : {form-feed}
               ClrScr;
         ELSE  WRITE(CHR(c AND $7F));
     END;
END;
{$I WXTMWIND.INC}
{$I WXTMXFER.INC}
{$I WXTMDIAL.INC}


BEGIN
     ScreenBase := $B000;                       {assume monochrome}
     MemW[ ScreenBase:0000 ]   := 69;
     IF Mem[ ScreenBase:0000 ] <> 69 THEN
        ScreenBase := $B800;
     ClrScr;
     InitWindow(StatWin,1,1,80,2);
     InitWindow(TermWin,1,3,80,25);
     CurrentWin := TermWin;
     UsePermWindow(TermWin);
     status(1,'WXTERM ver: ' + VERSION);
     status(2,'Initializing');
     setup;
     init_port;
     term_ready(TRUE);
     set_up_recv_buffer;
     remove_port;
     init_port;
     term_ready(TRUE);
     set_up_recv_buffer;
     exit := FALSE;
     GotoXY(1,1);
     IF carrier THEN
        status(2,'On-Line/Ready')
     ELSE
        status(2,'Off-Line/Ready');
     status(3,'[Home] for help');
     WRITELN('Press [Home] for help');
     WHILE NOT exit DO
     BEGIN
          IF scan(xtnd,a) THEN
          BEGIN
               IF xtnd THEN
               BEGIN
                  CASE a OF
                       19   : {alt-R}
                              recv_wcp;
                       45   : {alt-X}
                              BEGIN
                                   OpenTemp(20,18,60,22,1);
                                   WRITELN('WXTERM');
                                   WRITE('Do you really want to exit (Y/N)? ');
                                   READLN(ch);
                                   IF UpCase(ch) = 'Y' THEN
                                      exit := TRUE;
                                   CloseTemp
                              END;
                       31   : {alt-S}
                              send_wcp;
                       35   : {alt-H}
                              BEGIN
                                   WRITELN('WXTERM');
                                   status(2,'Disconnecting');
                                   term_ready(FALSE);
                                   Delay(500);
                                   term_ready(TRUE);
                                   status(2,'Off-Line/Ready')
                              END;
                       46   : {alt-C}
                              ClrScr;
                       48   : {alt-B}
                              break;
                       25   : {alt-P}
                              NewParms;
                       72   : {Cursor up}
                              PushPage;
                       80   : {Cursor Down}
                              PopPage;
                       71   : {Home}
                              BEGIN
                                OpenTemp(40,3,80,10,2);
                                WRITELN('Alt-X exit         Alt-H hang up');
                                WRITELN('Alt-R Xmodem recv  Alt-S Xmodem send');
                                WRITELN('Alt-B send break   Alt-C clear screen');
                                WRITELN('        Alt-P comm params  ');
                                WRITELN('      Press any key to continue');
                                REPEAT
                                UNTIL (KeyPressed);
                                ClrScr;
                                CloseTemp;
                             END;
                  END; {case}
               END     {if extended key}
               ELSE    {not extended}
                  send(a);
          END; {if KeyPressed}
          processcom;
     END; {while not exit}
     remove_port;
END.
