;
;
;
; FOSSY.ASM
;
; Interruptroutine (c) Kolja Waschk 1992
; Programmrumpf (c) Martin Althaus, aus dem PC Profibuch/ext.ed. (Sybex)
;
; Fossy wartet darauf, dass eine bestimmte Zeichenkette
; mit der Transmit/no wait-Funktion des Fossiltreibers
; zum Modem geschickt wird.
; Wenn dem so ist, wird ein Zeichen (^=F3) in den Tastaturpuffer
; geschrieben, um einen Tastendruck zu simulieren.
;
; Assemblieren mit:
;
; MASM FOSSY
; LINK FOSSY
; EXE2BIN FOSSY FOSSY.COM
; DEL FOSSY.EXE
;
; installieren/deinstallieren mit "FOSSY"
; Installation in der Autoexec.Bat hat bei mir noch keine Probleme
; zutage gefoerdert. Aber unbedingt _vorher_ den Fossil installieren !
;
fossil_int             equ     14h
;
;Beginn
;
code            segment
                assume  cs:code, ds:code
                org 44h                    ;Environmentstring-
umgebungsadr    dw      ?                  ;Pointer
                org 100h                   ;COM-Programm

fossy:       jmp installation           ;zuerst installieren
;
;Daten
;
programm_name   db      'Fossy '
copyright       db      '(C) Kolja Waschk/Martin Althaus 1992',0
pseudo_command  db      'ZUTIL',13,0,0,0,0,0,0,0,0
command_pos     dw      ?
old_fossil_int  dw      ?,?
prg_laenge      equ     offset copyright - offset programm_name
cr              equ 13
lf              equ 10
;
;neue Interrupts
;
new_fossil_int   proc    far

                  cmp     ah,0bh           ;Unterfunktion "TX/no wait" ?
                  je      test_for_pc      ;ja -> auf Pseudokommando testen

alt_int_patch:    jmp     dword ptr cs:old_fossil_int
                                           ;alten Interrupt 
                                           ;aufrufen
;
;Vergleich der zu sendenden Daten mit dem Pseudo-Kommando-String
;
test_for_pc:    push bx
                mov bx, command_pos                ;Zeiger laden
                cmp al, cs:[bx]                    ;vergleichen
                je next_char                       ;passt -> Zeiger erhoehen
                mov bx, OFFSET pseudo_command      ;Zeiger zuruecksetzen
                mov command_pos, bx
                pop bx
                jmp dword ptr cs:old_fossil_int    ;weiter mit orig.Fossil

next_char:      inc bx
                cmp byte ptr cs:[bx],0             ;Ende des Strings ?
                je got_pc                          ;ja -> kompl. Kommando
                mov command_pos, bx                ;nein, weiter
                pop bx
                jmp dword ptr cs:old_fossil_int    ;weiter mit orig.Fossil

got_pc:         mov bx, OFFSET pseudo_command      ;Zeiger zuruecksetzen
                mov command_pos, bx
                push ds
                mov bx,0                           ;Keybd.Bufferzeiger lesen
                mov ds,bx
                mov bh, 04h
                mov bl, byte ptr ds:[041Ch]
                mov ds:[bx], 3D00h                 ;Zeichen in Buffer schreiben
                inc bl                             ;Zeiger erhoehen
                inc bl                             ;(keine Abfrage, ob Buffer
                cmp bl, 3Eh                        ;voll !)
                jne normal
                mov bl, 1Eh
normal:         mov byte ptr ds:[041Ch], bl        ;Zeiger setzen
                pop ds
                pop bx
                jmp dword ptr cs:old_fossil_int    ;trotzdem noch weiter
                                                   ;mit dem alten Fossil

new_fossil_int   endp
;
;Installation
;
installation:           assume  ds:code
                push    cs                 ;setze die Segmente
                pop     ds                 ;DS=CS
;
;schon installiert ?
;
                mov     al,fossil_int      ;gewnschter neuer
                mov     ah,35h             ;Interrupt wird ber
                int     21h                ;INT 21h gesucht
;
;vergleiche Interrupt: ist er von FOSSY benutzt ?
;
                lea     di,programm_name   ;ES:DI zeigt auf Prgname
                mov     si,di
                mov     cx,prg_laenge      ;Lnge des Namens
                repe    cmpsb              ;vergleiche
                jcxz    schon_installiert  ;ja, schon installiert
;
;installiere FOSSY
;
                lea     dx,start_text      ;Installationsmeldung
                call    text_ausgeben      ;ausgeben
;
;sichere alte Interrupts
;
                mov     al,fossil_int      ;sichere orig.Fossil-Vektor
                mov     ah,35h             ;nach old_fossil_int
                int     21h
                mov     old_fossil_int,bx
                mov     old_fossil_int+2,es
;
;gebe Umgebungsstrings frei
;
                mov     ax,umgebungsadr    ;Adresse der Umgebung im PSP
                mov     es,ax              ;Gib Umgebung durch
                mov     ah,73              ;Funktion 73 von
                int     21h                ;INT 21h frei
;
;setze die neuen Interrupts
;
                lea     dx,new_fossil_int  ;Offset
                mov     al,fossil_int      ;Nummer
                mov     ah,25h             ;setze Vektor
                int     21h
;
; reset String-Pointer
;
;               mov     dx, OFFSET pseudo_command
                mov     command_pos, dx
;
;nun beenden, aber bis zum Label INSTALLATION resident bleiben
;
                lea     dx,installation    ;Adresse von INSTALL
                mov     cl,4               ;durch das 4-malige
                shr     dx,cl              ;Schieben durch 16 teilen
                inc     dx
                xor     al,al              ;kein Fehler
                mov     ah,49              ;beende resident
                int     21h
;
;FOSSY ist schon installiert, de-installiere und gebe Meldung
;aus
;
schon_installiert:
                lea     dx,schon_text      ;Meldung ausgeben
                call    text_ausgeben
                mov     ah,35h             ;orig.Int.-Vektor lesen
                mov     al,fossil_int
                int     21h
                push    ds
                mov     dx,es:old_fossil_int+2
                mov     ds,dx
                mov     dx,es:old_fossil_int
                mov     ah,25h             ;reset orig. Int.-Vektor
                int     21h
                pop     ds                 ;Speicher wieder freigeben
                mov     ah,49h
                int     21h
                mov     ax,4c00h           ;beende das Programm 
                int     21h
;
;Unterroutine: gibt ASCII-Text aus
;
text_ausgeben   proc    near               ;ASCIIZ-String
                mov     ah,9               ;ueber Fkt. 9
                int     21h                ;vom INT 21h ausgeben
                ret                        ;und zurck
text_ausgeben   endp
;
;
start_text  db  lf,cr,lf,cr
            db  'FOSSY (c) 1992 Kolja Waschk/Martin Althaus',lf,cr
            db  'loaded',lf,lf,cr
            db  '$'
schon_text  db      lf,lf,cr
            db      'FOSSY unloaded',lf,lf,cr,'$'
code        ends
            end     fossy
