//----File Summary--------------------------------------
// File Name: btrieve.hpp
//
// class defined -> Btrieve
// public member -> 
// public data   -> 
//
//----End-----------------------------------------------
#ifndef CL__BTRIEVE
#define CL__BTRIEVE
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif
#ifndef __STRING_H
#include <string.h>
#endif

#ifndef CL__RDBMS
#include "rdbms.hpp"
#endif

#ifndef CL__FIELD
#include "field.hpp"
#endif

#define     GET_POST		  22
#define     GET_DIRECT		  23
#define     GET_EQUAL             5+200
#define     GET_NEXT              6+200
#define     GET_PREV              7+200
#define     GET_GREATER           8+200
#define     GET_GREATER_EQUAL     9+200
#define     GET_LESS              10+200
#define     GET_LESS_EQUAL        11+200
#define     GET_FIRST		 12+200
#define     GET_LAST	       13+200
#define     STEP_FIRST		  33+200
#define     STEP_LAST		  34+200
#define     STEP_NEXT		  24+200
#define     STEP_PREV		  35+200
#define     KEY0                  0
#define     KEY1                  1
#define     KEY2                  2
#define     NOKEY		0
#define     UNLOCK      27
#define     REWRITE     3
#define     ADDNEW      2
#define     DELETE      4
#define     LOCK        1

#define MAX_INDEX_KEY 20
#define MAX_KEY_LENGTH 256
#define MAX_FIELD_LENGTH 256

typedef struct                   // defined in bcreate.h
{
    int recordLength;
    int pageSize;
    int indexNo;
    long recordCount;
    int fileFlag;
    int reserved;
    int allocation;
}FileSpecs;

typedef struct
{
    int keyPostition;
    int keyLength;
    int keyFlag;
    long keyCount;
    char extendKeyType;
    char nullValue;
    char reserved[4];
} KeySpecs;

//-----------class Btrieve----------------------------------------

class Btrieve :public Rdbms,public FIELD
{
public:
    Btrieve(char* path, char *filename,Field xfld[],int fldNo,int keyNo=0);
    ~Btrieve();

    virtual long RecCount()                         ;
    virtual int KeyLength(int keyNo)                ;
    virtual int KeyLength(void)                     ;
    virtual int IndexNo(void)                       ;
    virtual int UseIndex(int key=0)                 ;
    virtual int ActiveIndex()                       ;
	virtual char* KeyValue()                        ;
    virtual int DataLen(void)                       ;
    virtual int Open(void)                          ;
	virtual int Close(void)                         ;
    virtual int Bof(void)                           ;
    virtual int Eof(void)                           ;
    virtual int Empty(void)                         ;
    virtual int Unlock(void)                        ;
    virtual int Lock(void)                          ;

    virtual int GetFirst(int lock=0)                      ;
    virtual int GetEqual(char* keyvalue, int lock=0)            ;
    virtual int GetLast(int lock=0)                       ;
    virtual int GetNext(int lock=0)                       ;
    virtual int GetPrev(int lock=0)                       ;
    virtual int GetGEqual(char* keyvalue, int lock=0)           ;
    virtual int GetGreater(char* keyvalue, int lock=0)          ;
    virtual long GetPost(int lock=0)                       ;
    
    virtual int GoTo(long,int lock=0)                     ;
    
    virtual int StepFirst(int lock=0)                     ;
    virtual int StepLast(int lock=0)                      ;
    virtual int StepNext(int lock=0)                      ;
    virtual int StepPrev(int lock=0)                      ;
                             
    virtual int Rewrite(void)                        ; 
    virtual int Write(void)                        ; 
    virtual int Delete(void)                        ; 
	virtual char* FileName(void)                    ;
	virtual char* Path(void)                        ;
	virtual int Err(void)                     ;

    virtual int fReplace(int ,char *  )                    ;
    virtual int fReplace(int ,int  )                    ;
    virtual int fReplace(int ,long )                    ;
    virtual int fReplace(int ,float)                    ;
    virtual int fReplace(int ,double)                    ;

    virtual int fReplace(char* ,char *  )                    ;
    virtual int fReplace(char*,int  )                    ;
    virtual int fReplace(char*,long )                    ;
    virtual int fReplace(char*,float)                    ;
    virtual int fReplace(char*,double)                    ;

    //-----------------------------------------------------------
    // note that these field function are using the same buffer
    // thus you cannot use something like this
    // cout << f30.fStr(0) << f30.fStr(1);
    //-----------------------------------------------------------
    virtual char* fStr(char * str, const char *ptemplate="%s")                    ;
    virtual char   fChar(char *  )                    ;
    virtual int   fInt(char *  )                    ;
    virtual long  fLong(char * )                    ;
    virtual float fFloat(char *)                    ;
    virtual double  fDouble(char *)                  ;

    virtual char* fStr(int i=0, const char *ptemplate="%s")                    ;
    virtual char   fChar(int)                    ;
    virtual int   fInt(int)                    ;
    virtual long  fLong(int)                    ;
    virtual float fFloat(int)                    ;
    virtual double  fDouble(int)                  ;
public:
    int errorcode;
protected:
    char *fhd;
    char *data;
    int dataonly;               // indicate if the file is a data only file
    int datalen;
    int kLen[MAX_INDEX_KEY];    // store the key length
    int kIndex; // No. of Index key
    int kUsed;
    char *kValue;
    long lpost;     // physical position
    int RecChanged; // if record is changed
};

