
// Copyright 1992, David Perelman-Hall & Jamshid Afshar


#ifndef RULES_H
#define RULES_H

#include <assert.h>
#include "category.h"
#include "edge.h"


class Rule {
friend ostream& operator << ( ostream& os, const Rule& rule );
friend class RuleList;
private:
   Category _lhs;
   Category_Sequence _rhs;
public:
   // empty constructor
   Rule() {}
   // constructor
   Rule( const Category& lhs, const Category_Sequence& rhs )
      : _lhs(lhs), _rhs(rhs) {}
   // copy constructor
   Rule( const Rule& rule )
      : _lhs(rule._lhs), _rhs(rule._rhs) {}

   // assignment operator
   void operator = ( const Rule& rule )
      { _lhs = rule._lhs; _rhs = rule._rhs; }

   bool operator == ( const Rule& rule ) const
      { return _lhs == rule._lhs && _rhs == rule._rhs; }

   bool appliesTo( const Edge& edge ) const
      { return edge.label() == _rhs.first();}

   //apply a rule
   Edge apply( const Edge& edge ) const
      {
         assert( appliesTo(edge) );
         return Edge(edge.start(), edge.start(), _lhs, _rhs );
      }
};


const MAX_RULES = 100;

class RuleList {
private:
   Rule _arr[MAX_RULES];
   int _num;
public:
   // constructor
   RuleList();
   void read(const char *file_name);
   void add(const char *rule_str);
   const Rule& operator[](int index) const
      { assert( index < _num ); return _arr[index]; }
   int num() const
      { return _num; }
};


#endif
