/*
Ŀ
       ---------Dead Game  Programmed by Meetul K. Kinarivala--------        
Ĵ
 Rules: Well, consider a 6x6 board shown below where C represents computer's 
        pegs and H represents  human's pegs.  Both take  alternate turns  to 
Ŀ move. Each peg can be moved 
 CCCCC  CCCCC  CCCCC  CCCCC  CCCCC  CCCCC  either    horizontally   or 
 CCCCC  CCCCC  CCCCC  CCCCC  CCCCC  CCCCC  vertically  any  number  of 
Ĵ steps forward or  backward. 
                                           A  peg dies if it is traped 
                                           between two opponent's pegs 
Ĵ either   horizontally    or 
                                           vertically. Diagonal  moves 
                                           and jumps are not  allowed. 
Ĵ A peg does not die if it is 
                                           intentionally moved between 
                                           two  of  opponent's  peg. A 
Ĵ player  wins if either 5 of 
                                           the  opponent's pegs die or 
                                           if all  of the   opponent's 
Ĵ pegs are blocked.           
 HHHHH  HHHHH  HHHHH  HHHHH  HHHHH  HHHHH     Suggestions are welcomed 
 HHHHH  HHHHH  HHHHH  HHHHH  HHHHH  HHHHH  for changing the  rules and 
 making it more exciting.    

Ŀ
       ---------Dead Game  Programmed by Meetul K. Kinarivala--------        
Ĵ
    Message -                                                               
   ĴĿ
 6                                            S  reStart  R - Redo 
                                              I  Invert            
   Ĵ E  Exchange          
 5                                            H  Hint              
                                              U  Undo     Q - Quit 
   ĴĴ
 4                                            +/-  Smartness        
                                                Pick/drop peg    
   Ĵ ESC  Deselect peg     
 3                                            Use arrow-keys to move 
                                             Ĵ
   Ĵ Human's    Moves[   ]
 2                                            Computer's Moves[   ]
                                             Ĵ
   Ĵ Smartness  Level[ ]  
 1                                            Human's    Score[ /5]
                                              Computer's Score[ /5]
   ٳ
       A       B       C       D       E       F                              


**********************************************************************************
*  PROJECT NAME: Deadgame.                                                       *
*  AUTHOR      : Meetul Kinarivala.                                              *
*  START DATE  : 16th December 1995.                                             *
*  END DATE    : 21st December 1995.                                             *
*  DESCRIPTION : Deadgame is a board game where computer plays against the human.*
*  AIM         : To generate the deadgame engine.                                *
*  FILE NAME   : DEADGAME.CPP                                                    *
*  FILE DESC.  : The deadgame engine                                             *
**********************************************************************************

********************************************************************
* Important - Play the game properly. Then read the writeup        *
*             Then read DEADGAME.H and then DEADGAME.CPP           *
********************************************************************/



#include"DEADGAME.H"

int deadgame_engine(BOARD& board, int C_OR_H,int& maxadvpeg,int& maxadvstep,int peg_to_skip,int step_to_skip);
int interaction(void);
void load_screen(char *filename,long offset);
void turns(int hturns,int cturns);
void gkp(char& scancode,char& ascii);
void message(char *msg);
void beep(void),purr(void);

void main(void)
{
	do
	{
		load_screen("DEADGAME.CPP",4);//draw the board
		getch();
		load_screen("DEADGAME.CPP",2054);//show the rules
	}
	while(interaction());//play the game

	clrscr();
	_setcursortype(_NORMALCURSOR);
}


//This function is responsible for the interaction of the game with the
//human.


int interaction(void)
{
	char scancode=0; //contains keyboard scancode of the key pressed
	char ascii=0;    //contains ascii value of the key pressed
	char pickedpeg=0;//contains the number of the peg picked.(Always negative
					 //as human is allowed to pick only negative(his) pegs.

	int cpxr=0,cpyr=0;//When human presses 'enter' to pick a peg, the co-ordinates
					  //of the peg are stored in these variables.

	int loseflag=0;  //if loseflag==COMPUTER then computer loses
					 //else if loseflag==HUMAN then human loses.

	int whoseturn=COMPUTER; //Flag denoting whose turn is it to make a move ?
	int undo_flag=77;       //If undo_flag == TRUE then a recent action did undo
							//else a recent action either did not do an undo or did a redo

	int hturns=0,cturns=0; //variables denoting number of human turns and number of
						   //computer turns over.

	BOARD b1;		   //b1 is the actual game board.
	BOARD b2;          //b2 is used for purposes such as displaying 'dragged'
					   //human pieces in 'place a peg' mode.
	BOARD b_undo;      //before making a move on b1, b_undo = b1 is done.
	BOARD b_redo;	   //before doing undo, b_redo = b1 is done.

	//We should also eliminate this never ending cycle and train the computer to give-up:
	//If I make a move X, you make a move Y.
	//Then if I make a move A, you make a move B.
	//But then I am compelled to make a move X, so you again make a move Y.
	//Again I am compelled to make a move A, so you make a move B.
	//But then I am compelled to make a move X, so you again make a move Y.
	//Again I am compelled to make a move A, so you make a move B.


	//Hence, the below structure tracks consecutive board positions when
	//the computer moves and the mechanism eliminates the above possibility.
	struct
	{
		BOARD cmoves;
		int peg,steps;
	} cm[2];

	cm[0].peg=cm[0].steps=cm[1].peg=cm[1].steps=0;//reset above structure.
	int mk=0;//cm[mk].cmoves is going to store the next computer move.

	//Display the board on the screen.
	b1.disp_board();

	//Print the number of human and computer turns on the screen.
	turns(hturns,cturns);

	//ask the human as to who plays first
	message("Who plays first ?(C/H)");
	//Loop untils the human presses 'C' or 'H'
	do gkp(scancode,ascii); while(!C_PD && !H_PD);

	//update whoseturn variable
	if (H_PD)
	{
		whoseturn=HUMAN;
		move_cursor(2,5,TRUE);//display the cursor.
	}
	else whoseturn=COMPUTER;

	randomize(); //initialize random no generator


	//start the game
	for(;;)//infinite loop.
	{
	for(;!loseflag;)//This loop is exited only when somebody loses.
	{
		scancode=0;ascii=0;//Reset data about the last key pressed.
		gkp(scancode,ascii);//Get a key_stroke if available.
							//scancode and ascii are passed by reference.

		//if it is computer's turn then it should make a move
		if(whoseturn==COMPUTER)
		{
			int peg,steps; //Will contain information as to which peg should
						   //be move what steps. The meaning of 'steps' is
						   //clearly described in the write-up.

			++level; //level maintains a track as to in which recursive level are we.
			move_cursor(0,0,FALSE);       //Hide the cursor
			message("Thinking........."); //Display the message.

			//Now we call the heart of the game. Which peg should be moved
			//what steps is returned in variables peg and steps.

			deadgame_engine(b1,COMPUTER,peg,steps,0,0);

			//Now it is decided that 'peg' should be moved 'steps' steps.


			//Update b2 with computer's move but do not display the move.
			b2 = b1.move(peg,steps);

			//This mechanism prevents the infinite cycle described above.
			if (b2.compare_boards(cm[mk].cmoves)==0)
			{
				++level;
				deadgame_engine(b1,COMPUTER,peg,steps,cm[mk].peg,cm[mk].steps);
			}
			beep();//Beep

			b1 = b1.blinkmove(peg,steps);//Now make the move.

			//update cm structure.
			cm[mk].cmoves = b1;cm[mk].peg=peg;cm[mk].steps=steps;

			//update mk.
			mk = (mk==0) ? 1 : 0;

			//increase the number of computer's turns and display.
			turns(hturns,++cturns);

			//now it is the human's turn
			whoseturn=HUMAN;

			//check for a win.
			if(b1.ha <= 1 || b1.hq==0) loseflag=HUMAN;

			//reset pickedpeg variable.
			pickedpeg=0;

			//display the cursor.
			move_cursor(BOARD_SIZE_X/2-1,BOARD_SIZE_Y-1,TRUE);

			//reiterate.
			continue;
		}
		else //if it is human's turn then he is allowed to make a move.
		{
			//if 's' is pressed restart the game
			if(S_PD) return(1);
			//else if 'I' if pressed invert the board
			else if(I_PD) {b1.invert_board();b_undo.invert_board();b_redo.invert_board();b1.disp_board();pickedpeg=0;}
			//else if 'E' is pressed exchange the pegs
			else if(E_PD) {b1.exchange_pegs();b_undo.exchange_pegs();b_redo.exchange_pegs();b1.disp_board();pickedpeg=0;}
			//else if 'Q' is pressed quit.
			else if(Q_PD) return FALSE;
			//else if '+' or '-' is pressed increase or decrease smartness
			else if(PLUS_PD && MAXLEVEL<5)  {++MAXLEVEL;b1.disp_board();pickedpeg=0;}
			else if(MINUS_PD && MAXLEVEL>1) {--MAXLEVEL;b1.disp_board();pickedpeg=0;}
			//else if 'H' is pressed then the computer should hint.
			else if(H_PD)
			{
				int peg,steps;++level;
				b1.disp_board();//refresh board diplay
				message("Thinking for you........");//display message.
				deadgame_engine(b1,HUMAN,peg,steps,0,0);//call the heart of the game.

				b_undo=b1;undo_flag=FALSE;//enable undo.
				beep();
				b1 = b1.blinkmove(peg,steps);
				turns(++hturns,cturns);//increase no. of human turns and display
				pickedpeg=0;whoseturn=COMPUTER;//its the computer's turn next.
				if(b1.ca <= 1 || b1.cq==0) loseflag=COMPUTER; //check for a win
				continue;//reiterate.
			}
			//else if 'U' pressed and undo is enabled do undo and enable redo.
			else if(U_PD && undo_flag==FALSE){b_redo=b1; b1=b_undo; b1.disp_board(); undo_flag=TRUE;--hturns;--cturns; pickedpeg=0;}
			//else if 'R' pressed and undo disabled then do redo.
			else if(R_PD && undo_flag==TRUE) {b1=b_redo; b1.disp_board(); undo_flag=FALSE;++hturns;++cturns; pickedpeg=0;}
			//else according to the cursor key pressed, move the cursor.
			else if (R_ARW_PD) move_cursor(curposx+1,curposy,TRUE);
			else if (L_ARW_PD) move_cursor(curposx-1,curposy,TRUE);
			else if (D_ARW_PD) move_cursor(curposx,curposy+1,TRUE);
			else if (U_ARW_PD) move_cursor(curposx,curposy-1,TRUE);

			//if a peg has not been picked do this.
			if(pickedpeg>=0)
			{
				if (pickedpeg==0) {message("Pick your peg.");pickedpeg=1;} //display the message
				//if enter is pressed check whats beneath the cursor.
				if (ENTER) pickedpeg=b1.look();//if enter is pressed check whats beneath the cursor.
				//on success store the cursor positions,display message.
				if (pickedpeg<0) {cpxr=curposx;cpyr=curposy;b2=b1;message("Place the peg.");}
				else if (ENTER) purr();//else on failure to pick, beep.
			}
			else //if a peg has been picked,
			{
				//if the peg is moved to its own position or if esc pressed
				//then go back to 'pick the peg' mode.
				if ( (ENTER && curposx==cpxr && curposy==cpyr) || ESC )
				{b1.disp_board();move_cursor(cpxr,cpyr,TRUE);pickedpeg=0;continue;}

				//else place the peg in its new position
				else if (ENTER)
				{
					b_undo=b1;undo_flag=FALSE;purr(); //enable undo
					b1=b1.move(pickedpeg,curposx,curposy); //move the peg
					turns(++hturns,cturns);//update no. of turns
					b1.disp_board(); //display the board.
					pickedpeg=0;whoseturn=COMPUTER; //now its the computer's turn
					if(b1.ca <= 1 || b1.cq==0) loseflag=COMPUTER; //check for a win.
					continue; //reiterate.
				}

				//ensure that the new cursor position is always a valid position.
				if (b1.look()!=BLANK || (curposx!=cpxr && curposy!=cpyr) )
					move_cursor(cpxr,cpyr,TRUE);

				//make a temporary move beneath the cursor.
				b2=b1.move_but_dont_kill(pickedpeg,curposx,curposy);
				b2.disp_board(); //display the temporary move.
			}
		}
	}

	if(loseflag==HUMAN) message("You lose. Better luck next time!");
	else if(loseflag==COMPUTER) message("Congratulations! You win");
	beep();
	move_cursor(2,5,FALSE);//hide the cursor.
	getch();loseflag=0;//reiterate.
	}
}






/*************************************************************************
Function: int deadgame_engine(BOARD board, int C_OR_H,
		  int& maxadvpeg,int& maxadvstep,int peg_to_skip,int step_to_skip)

Description: This is the game engine which evaluates and returns
			 the best possible move for the human or computer.
			 Arguments are as follows:

			 BOARD board - board to evaluate
			 int C_OR_H  - evaluate computer's move or human's move
			 int& maxadvpeg - return by reference the best possible peg
			 int& maxadvstep - return by reference the best possible step
			 int peg_to_skip - this peg's 'step_to_skip' step is not evaluated.

			 More description in the writeup.
**************************************************************************/
int deadgame_engine(BOARD& board, int C_OR_H,int& maxadvpeg,int& maxadvstep,int peg_to_skip,int step_to_skip)
{
	int adv,maxadv=-10000;
	int peg,d1,maxplaces,status;
	int maxpegs=(PEGS*C_OR_H)+C_OR_H;

	for(peg=C_OR_H; peg!=maxpegs; peg+=C_OR_H)
	{
		board.peg_info(peg,status,maxplaces);
		if (status==DEAD) continue;

		for(int j=1; j<=maxplaces; ++j)
		{
			if(peg==peg_to_skip && j==step_to_skip) continue;
			BOARD test = board.move(peg,j);

			if(level>=MAXLEVEL)
			{
				adv=(test.cal)*C_OR_H;
				if (adv>maxadv) {maxadv=adv;maxadvpeg=peg;maxadvstep=j;}
				continue;
			}

			++level;
			adv = (test.cal*C_OR_H) - deadgame_engine(test,-C_OR_H,d1,d1,0,0);
			if (adv>maxadv) {maxadv=adv;maxadvpeg=peg;maxadvstep=j;continue;}
			else if (adv==maxadv && !random(3)) {maxadvpeg=peg;maxadvstep=j;}
		}
	}
	--level;
	return (maxadv);
}


void gkp(char& scancode,char& ascii) //get key-press
{
	if(kbhit())
		scancode = (((ascii=getch()) == 0) ? getch() : inportb(0x60));
}

void message(char *msg) //print the message on the screen
{
	textattr(MESSAGE_ATTR);
	gotoxy(17,4);
	if (msg!=NULL) cprintf("%-35s",msg);
	else cprintf("                              ");
}


void beep(void) //make a deep sound
{
	sound(525);delay(65);nosound();
}

void purr(void) //make a soft sound
{
	sound(125);delay(30);nosound();
}

void turns(int hturns,int cturns) //display computer's and human's turns
{
	gotoxy(75,17);cprintf("%3d",hturns);
	gotoxy(75,18);cprintf("%3d",cturns);
}

void load_screen(char *filename,long offset) //load the starting screen
{
	FILE *fpt;

	if ((fpt=fopen(filename,"rb"))==NULL) {cout << "Fatal Error: Unable to open deadgame.cpp";exit(1);}
	fseek(fpt,offset,SEEK_SET);

	char far *scr = (char far *)0xb8000000;
	char *buffer = new char[81];

	_AX = 0x1003;
	_BX = 0;
	geninterrupt(0x10);
	_setcursortype(_NOCURSOR);


	for(int i=0;i<25;++i)
	{
		fread(buffer,80,1,fpt);buffer[80]=0;
		for(int j=0;j<80;++j)
		{
			*(scr + j*2) = *(buffer+j);
			*(scr + j*2 + 1) = SCREEN_ATTR;
		}
		scr+=160;
		fseek(fpt,2,SEEK_CUR);
	}

	delete buffer;
	fclose(fpt);
}
