#include <iostream.h>
#include <stdlib.h>
#include <conio.h>

#include "drmatrix.hpp"

void solve(int,int);

int main()
{
	unsigned neq,nvar;
	clrscr();
	cout << "Solver\n"
		 << "Demo Program for Doctor Matrix programming package\n"
		 << "by Zvika Ben-Haim\n"
		 << "Copyright (c) 1996\n\n"
		 << "Enter the number of equations: ";
	cin  >> neq;
	cout << "Enter the number of variables: ";
	cin  >> nvar;
	solve(neq,nvar);
	return 0;
}

void solve(int neq,int nvar)
{

	int i,j,n;
	Matrix<float> M(neq,nvar+1);
	clrscr();
	cout << "Enter a matrix of order " << neq << 'x' << nvar+1 << '.' << endl
		 << "Each row contains one equation." << endl
		 << "For instance, the equation a+2b+3c=1 would be enter as:" << endl
		 << "1 2 3 1" << endl
		 << "Remember to leave coefficients of 0 for equations with missing variables." << endl;
	cin  >> M;
	Matrix<float> R = M.canon();
	for(n=neq; n>=1; n--)
	{
		i=R.lead(n);
		if(i==nvar+1)
		{
			cout << "No solution.\n";
			return;
		}
		if(i!=nvar+2) break;
	}
	if(n==0)
	{
		cout << "All possible combinations are solutions.\n";
		return;
	}
	if(n==nvar)
	{
		cout << "The single solution is:\n";
		for(i=1; i<=n; i++)
			cout << (char)('a'+i-1) << " = " << R(i,nvar+1) << endl;
		return;
	}
	cout << "The symbolic solution is:\n";
	for(i=1; i<=n; i++)
	{
		j = R.lead(i);
		cout << (char)('a'+j-1) << " = " << R(i,nvar+1);
		for(j++; j<=nvar; j++)
			if(R(i,j)!=0.)
			{
				if(R(i,j)>0.)
					cout << " - ";
				else
					cout << " + ";
				if(abs(R(i,j))!=1.)
					cout << abs(R(i,j));
				cout << (char)('a'+j-1);
			}
		cout << endl;
	}
	cout << "All remaining variables can be chosen arbitrarily.\n";
}
