// File from page 589 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: MBLOCK.CPP -- Built-in types in templates
#include <assert.h>
#include <iostream.h>

template<class T, int size = 100>
class mblock {
  T array[size];
public:
  T& operator[](int index) {
    assert(index >= 0 && index < size);
    return array[index];
  }
};

class number {
  float f;
public:
  number(float F = 0.0f) : f(F) {}
  number& operator=(const number& n) {
    f = n.f;
    return *this;
  }
  operator float() const { return f; }
  friend ostream&
    operator<<(ostream& os, const number& x) {
      return os << x.f;
  }
};

template<class T, int sz = 20>
class holder {
  mblock<T, sz>* np;
public:
  holder() : np(0) {}
  number& operator[](int i) {
    assert(i >= 0 && i < sz);
    if(!np) np = new mblock<T, sz>;
    return np->operator[](i);
  }
};

main() {
  holder<number, 20> H;
  for(int i = 0; i < 20; i++)
    H[i] = i;
  for(int j = 0; j < 20; j++)
    cout << H[j] << endl;
}
