// File from page 610 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: SET.H -- Each entry in a set is unique
#ifndef SET_H_
#define SET_H_
#include "..\14\vector.h"
#include <assert.h>

template<class Type>
class set {
  vector<Type> elem;
  int max;
  int lastindex; // Efficiency tool
  int within(const Type& e) {
    // Requires Type::operator== :
    for(lastindex = 0; lastindex < max;
        lastindex++)
      if(elem[lastindex]->operator==(e))
        return lastindex;
    return -1;
  }
  // Prevent assignment & copy-construction:
  void operator=(set&);
  set(set&);
public:
  set() : max(0), lastindex(0) {}
  void add(const Type&);
  int contains(const Type&);
  // Where is it in the set?:
  int index(const Type& e);
  Type& operator[] (int index) {
    // No check for shipping application:
    assert(index >= 0 && index < max);
    return *elem[index];
  }
  int length() const { return max; }
};

template<class Type> void
set<Type>::add(const Type& e) {
  if(!contains(e)) {
    elem[max] = new Type(e);//Copy-constructor
    max++;
  }
}

template<class Type> int
set<Type>::contains(const Type& e) {
  return within(e) != -1;
}

template<class Type> int
set<Type>::index(const Type& e) {
  // Prevent a new search if possible:
  if(elem[lastindex]->operator!=(e)) {
    int ind = within(e);
    assert(ind != -1); // Must know it's inside
  }
  return lastindex;
}
#endif // SET_H_
