#if !defined (TTOWER)                // Prevents multiple declarations errors
#define TTOWER


/*
   Module        : TTOWER.HPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : ttower class declaration.
*/


// Headers ------------------------------------------------------------------

#include "tdisk.hpp"
#include "twindow.hpp"


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions
#include "prjtype.h"                       // This project's type definitions


// Prototypes ---------------------------------------------------------------

class ttower                                                  // Tower object
{
   int   id ;                                            // Tower's ID (1..3)
   int   row ;                // Window position of tower's lower left corner
   int   col ;
   int   color ;                                             // Tower's color
   int   nb_disks ;                  // Number of disks stacked on this tower
   tdisk huge *content[10] ;            // Ptrs to disks stacked on the tower
                                                // Index 0 is the bottom disk
   twindow huge *winptr ;                               // Ptr to work window


public:

ttower                                                         // Constructor
(
   int           tid,                                           // Tower's ID
   int           trow,               // Tower's bottom left corner's position
   int           tcol,
   int           tcolor,                                     // Tower's color
   twindow huge *twinptr                                // Ptr to work window
) ;

~ttower () ;                                                    // Destructor

void ttower::show () ;                                // Displays empty tower

int ttower::getrow () ;             // Returns tower's bottom left corner row

int ttower::getcol () ;             // Returns tower's bottom left corner col

int ttower::getcolor () ;                            // Returns tower's color

int ttower::getnbdisks () ;           // Returns nb of disks stacked on tower

void ttower::pushdisk                                 // Adds a disk to tower
(
   tdisk huge *disk                                     // Ptr to disk pushed
) ;

void ttower::popdiskto                       // Moves a disk to another tower
(
   ttower huge *target,                           // Ptr to destination tower
   int         speed                                     // Animation's speed
) ;


} ;                                                       // End class ttower


// End Header File ----------------------------------------------------------

#endif
