#include "addevent.h"
#include <dos.h>
#include <ctype.h>

#define MACROS_STACK 20      // Stack for calling the macros from another macros

char* scriptFileName = NULL; // Name of the current script
int scriptMode = GO;         // Go mode - no script processing
FILE* scriptPtr = NULL;      // Pointer in the script file
char* macrosFileName = NULL;
FILE* macrosPtr = NULL;
macros_context mac_table[MAX_MACROSES];           // table for macros searching

int num_com = 0;               // 5 commands per line - return ...

mac_status macros_stack[MACROS_STACK];    // stack for calling macros from another macros
int macros_used = 0;                   // No of mac_status(es) in stack

struct var           // Variable name have corresponding code
    {
    char* command;
    int code;
    };

var commands[] =
    {
	{ "ESC", EVENT_ESC },	               { "TAB", EVENT_TAB },
	{ "BKSP", EVENT_BKSP },                { "RETURN", EVENT_RETURN },
	{ "LEFT", EVENT_LEFT },                { "RIGHT", EVENT_RIGHT },
	{ "HOME", EVENT_HOME },                { "UP", EVENT_UP },
	{"PG_UP", EVENT_PG_UP },               { "END", EVENT_END },
	{ "DN", EVENT_DN },                    { "PG_DN", EVENT_PG_DN },
	{ "CTRL_HOME", EVENT_CTRL_HOME },      { "PG_UP", EVENT_CTRL_PG_UP },
	{ "CTRL_END", EVENT_CTRL_END },        { "PG_DN", EVENT_CTRL_PG_DN },
	{ "F1", EVENT_F1 },                    { "F2", EVENT_F2 },
	{ "F3", EVENT_F3 },                    { "F4", EVENT_F4 },
	{ "F5", EVENT_F5 },                    { "F6", EVENT_F6 },
	{ "F7", EVENT_F7 },                    { "F8", EVENT_F8 },
	{ "F9", EVENT_F9 },                    { "F10", EVENT_F10 },
	{ "SHIFT_F1", EVENT_SHIFT_F1 },        { "SHIFT_F2", EVENT_SHIFT_F2 },
	{ "SHIFT_F3", EVENT_SHIFT_F3 },        { "SHIFT_F4", EVENT_SHIFT_F4 },
	{ "SHIFT_F5", EVENT_SHIFT_F5 },        { "SHIFT_F6", EVENT_SHIFT_F6 },
	{ "SHIFT_F7", EVENT_SHIFT_F7 },        { "SHIFT_F8", EVENT_SHIFT_F8 },
	{ "SHIFT_F9", EVENT_SHIFT_F9 },        { "SHIFT_F10", EVENT_SHIFT_F10 },
	{ "CTRL_F1", EVENT_CTRL_F1 },          { "CTRL_F2", EVENT_CTRL_F2 },
	{ "CTRL_F3", EVENT_CTRL_F3 },          { "CTRL_F4", EVENT_CTRL_F4 },
	{ "CTRL_F5", EVENT_CTRL_F5 },          { "CTRL_F6", EVENT_CTRL_F6 },
	{ "CTRL_F7", EVENT_CTRL_F7 },          { "CTRL_F8", EVENT_CTRL_F8 },
	{ "CTRL_F9", EVENT_CTRL_F9 },          { "CTRL_F10", EVENT_CTRL_F10 },
	{ "ALT_F1", EVENT_ALT_F1 },            { "ALT_F2", EVENT_ALT_F2 },
	{ "ALT_F3", EVENT_ALT_F3 },            { "ALT_F4", EVENT_ALT_F4 },
	{ "ALT_F5", EVENT_ALT_F5 },            { "ALT_F6", EVENT_ALT_F6 },
	{ "ALT_F7", EVENT_ALT_F7 },            { "ALT_F8", EVENT_ALT_F8 },
	{ "ALT_F9", EVENT_ALT_F9 },            { "ALT_F10", EVENT_ALT_F10 },
	{ "ALT_A", EVENT_ALT_A },              { "ALT_B", EVENT_ALT_B },
	{ "ALT_C", EVENT_ALT_C },              { "ALT_D", EVENT_ALT_D },
	{ "ALT_E", EVENT_ALT_E },              { "ALT_F", EVENT_ALT_F },
	{ "ALT_G", EVENT_ALT_G },              { "ALT_H", EVENT_ALT_H },
	{ "ALT_I", EVENT_ALT_I },              { "ALT_J", EVENT_ALT_J },
	{ "ALT_K", EVENT_ALT_K },              { "ALT_L", EVENT_ALT_L },
	{ "ALT_M", EVENT_ALT_M },              { "ALT_N", EVENT_ALT_N },
	{ "ALT_O", EVENT_ALT_O },              { "ALT_P", EVENT_ALT_P },
	{ "ALT_Q", EVENT_ALT_Q },              { "ALT_R", EVENT_ALT_R },
	{ "ALT_S", EVENT_ALT_S },              { "ALT_T", EVENT_ALT_T },
	{ "ALT_U", EVENT_ALT_U },              { "ALT_V", EVENT_ALT_V },
	{ "ALT_W", EVENT_ALT_W },              { "ALT_X", EVENT_ALT_X },
	{ "ALT_Y", EVENT_ALT_Y },              { "ALT_Z", EVENT_ALT_Z },

	{ "ALT_1", EVENT_ALT_1 },              { "ALT_2", EVENT_ALT_2 },
	{ "ALT_3", EVENT_ALT_3 },              { "ALT_4", EVENT_ALT_4 },
	{ "ALT_5", EVENT_ALT_5 },              { "ALT_6", EVENT_ALT_6 },
	{ "ALT_7", EVENT_ALT_7 },              { "ALT_8", EVENT_ALT_8 },
	{ "ALT_9", EVENT_ALT_9 },              { "ALT_10", EVENT_ALT_0 },
	{ "ALT_MINUS", EVENT_ALT_MINUS },      { "ALT_EQ", EVENT_ALT_EQUAL },
	{ "ALT_TAB", EVENT_ALT_TAB },
	{ "CTRL_Y", EVENT_CTRL_Y },
	{ "INS", EVENT_INS },                  { "DEL", EVENT_DEL },
	{ "SHIFT_TAB", EVENT_SHIFT_TAB },
	{ "", 0 }
    };

/////////////////////////
int read_command(char* command, FILE* f)      // call after '<' char was obtained
    {
    memset(command, '\0', 20);        // set str to ['\0', '\0', '\0', '\0'...]
    int i = 0;
    char ch;
    while((ch = fgetc(f)) != '>'     // while the '>' - obtain
	 && !isspace(ch) && i < 20)          // command
	{
	command[i++] = ch;
	}
    i = 0;
    while(commands[i].code)                        // search for this command
	{                                          // in commands[] array
	if(strcmp(commands[i].command, command))   // if not find - check next
	    {
	    i++;
	    continue;
	    }
	return commands[i].code;
	}
    return 0;
    }
/////////////////////////
void init_macros()
    {
    macrosFileName = "macros.mac";
    macrosPtr = fopen(macrosFileName, "r");

    rewind(macrosPtr);

    char str[22];
    int table_pos = 0;
    while(table_pos < MAX_MACROSES)
	{
	fpos_t reserv_pos;
	fgetpos(macrosPtr, &reserv_pos);

	if(fgets(str, 20, macrosPtr) == NULL)
	    break;
	if(str[0] != '$')           // $ <ALT_F1>
	    continue;		    // ... macros body

	fseek(macrosPtr, reserv_pos + 3, SEEK_SET);   // skip " <" after $
	int key;
	if(key = read_command(str, macrosPtr))        // for example "ALT_F1"
	    {
	    fgetpos(macrosPtr, &reserv_pos);
	    mac_table[table_pos].key = key;
	    mac_table[table_pos].pos = reserv_pos;
	    table_pos++;
	    continue;
	    }
	}
    }
////////////////////////
void process_event(int mode)
    {
    if(mode == 1)  // simple mode
	{
	e = getevent(KEYEVENT | MOUSEEVENT, MCleftDn | MCrightDn);
	return;
	}
    else if(mode == 2)  // simple mode
	{
	e = getevent(KEYEVENT | MOUSEEVENT, MCleftDn | MCrightDn | MCmove);
	return;
	}

    while(1)
	{
	e = readevent(KEYEVENT | MOUSEEVENT);

	if((e.what == MOUSEEVENT || e.what == NOEVENT)
	    && e.msstatus.buttonstate != 0)
	    {
	    e.what = MOUSEEVENT;
	    break;
	    }
	if(e.what == KEYEVENT)
	    {
	    break;
	    }
	}
    }
//////////////////////
void get_command(char* c)
    {
    if(e.is_char())
	{
	c[1] = '\0';
	c[0] = e.key;
	return;
	}
    int i = 0;
    while(e.key != commands[i].code)
	i++;

    c[0] = ' ';
    c[1] = '<';

    strcpy(c + 2, commands[i].command);
    int l = strlen(commands[i].command);
    c[l + 2] = '>';
    c[l + 3] = ' ';
    c[l + 4] = '\0';
    }
/////////////////////////
void command_get()
    {
    int ch;
    while((ch = fgetc(scriptPtr)) == ' ' || ch == '\n')
	;
    if(ch == EOF)
	{
	e.what = NOEVENT;
	e.key = 0;
	return;
	}

    if(ch != '<')        // char
	{
	e.key = ch;
	return;
	}

    char command[20];
    e.key = read_command(command, scriptPtr);
    }
//////////////////////
mac_status macros_pop()
    {
    macros_used--;
    return macros_stack[macros_used];
    }
//////////////////////
void macros_push(mac_status mac)
    {
    if(macros_used < MACROS_STACK)
	{
	macros_stack[macros_used++] = mac;
	}
    }
//////////////////////
void find_command()
    {
    fpos_t reserv_pos;
    fgetpos(scriptPtr, &reserv_pos);

    int table_pos = 0;
    while(table_pos < MAX_MACROSES && mac_table[table_pos].key)
	{
	if(e.key == mac_table[table_pos].key)
	    {
	    mac_status mac;              // remember old file executed
	    mac.file = scriptFileName
		? strdup(scriptFileName) : NULL;
	    mac.ptr = scriptPtr;
	    mac.mode = scriptMode;
	    mac.pos = reserv_pos;

	    macros_push(mac);                  // and keep it in the stack

	    delete scriptFileName;
	    scriptFileName = macrosFileName
		? strdup(macrosFileName) : 0;
	    scriptPtr = macrosPtr;
	    scriptMode = PLAY;
	    fseek(scriptPtr, mac_table[table_pos].pos, SEEK_SET);
	    break;
	    }
	table_pos++;
	}
    }
//////////////////////
void check_macros()
    {
    if(e.is_char())
	return;
    find_command();           // try to find the macros and play it
    }
//////////////////////
void get_event(int mode)
    {
    switch(scriptMode)
	{
	case GO:
	    process_event(mode);
	    check_macros();
	    break;
	case RECORD:
	    process_event(mode);

	    char command[22];
	    get_command(command);
	    fputs(command, scriptPtr);
	    num_com++;
	    if(num_com > 5)
		{
		char nl[2];
		nl[0] = '\n';
		nl[1] = '\0';
		fputs(nl, scriptPtr);
		num_com = 0;
		}

	    check_macros();
	    break;
	case PLAY:
	    e.what = KEYEVENT;
	    command_get();
	    check_macros();
	    if(e.key == 0 || e.key == '$') // or beginning of the next macros
		{
		delete scriptFileName;
		scriptFileName = NULL;
		mac_status mac = macros_pop();         // obtain previous status
		if(macros_used == 0)
		    {
		    scriptMode = GO;
		    delete mac.file;
		    break;
		    }

		scriptMode = mac.mode;          // and restore it

		scriptFileName = mac.file ? strdup(mac.file) : 0;
		delete mac.file;
		scriptPtr = mac.ptr;
		fseek(scriptPtr, mac.pos, 0);
		}
	    break;
	}
    }
