#ifndef __ASK_H_
#define __ASK_H_
/* Querry editor. Provides facilities for querries, examples and checks
    input to table.
*/

#include "abstable.h"
#include "khquerry.h"

#define QUERRY_MAX_LEN 250
#define EXAMPLE_MAX_LEN 8

class Ask : public KH_AbstractTable
    {
    protected:
	char* tableName;              // Name of table to querry
	KH_STRTABLE* querry;          // Querry to the table
	KH_STRTABLE* examples;        // Examples to the Querry
	char* checkers;               // Checked fields

	KH_STRTABLE* fieldNames;         // Names of fields

    public:
	Ask(rect coordinates, char* tabName, KH_STRTABLE* fields,
	       char* fName = "",
	       int s = 0, BORDERS b_type = SHOW_BORDER,
	       int res = 0, int pat = 0, int hdr_pat = 0);

	~Ask() { delete tableName; delete querry; delete examples;
		 delete checkers; delete fieldNames;
		 delete colNumbers; delete iColWidth; }

	virtual void getFieldName(char* name, int n);
//	virtual void repose(rect new_pos);
	virtual long RecordNumber()    { return 1L; }
	virtual int getColumnNumber()  { return nColumns; }

	virtual void showField(int xcell, int x, int y, int flag,
			       int field_type);

	virtual int getFieldType(int x, int y) { return 0; }

	virtual void show();
//	virtual void exe(int act = 0);
	virtual int writeAccess() { return 1; }
	virtual void saveTable() {}

//	virtual int check_type(int type, char* string) {}

	virtual void editField();
	virtual int searchField(int ask);
	virtual int getFieldMaxWidth();

/* After processing of touch() function global_num is set to the
     number of fields in table (fieldNames->used), global[1 - global_num]
     is set to querry strings, global[global_num + 1] is set to checkers,
     global[global_num + 2] is set to tableName, and
     global[global_num + 3 to 2 * global_num + 3] is set to examples
     strings. global[0] is set to "Ask" string.
*/
	virtual void touch(int i = 0);
    };

#endif __ASK_H_