#include <stdio.h>
#include <stdlib.h>
#include "axe.h"
#include <mem.h>
#include <math.h>


Axe::Axe(int l, double start, double end, int tick_no, int* t,
	 int s_tick_no, int* s, char** lab)
    {
    len_scr = l;
    ticks = sub_ticks = NULL;
    if(start != end)
	{
	labels = (char**)malloc(sizeof(char*) * MAXLABELS);
	calc_labels(start, end, tick_no, s_tick_no);

	if(s_tick_no != 0)
	    {
	    if(sub_ticks == NULL)
		sub_ticks = new int[s_tick_no + 2];
	    for(int i = 0; i < s_tick_no; i++)
		sub_ticks[i] = s[i];
	    }
	else
	    {
	    sub_ticks_no = ticks_no;
	    if(sub_ticks == NULL)
		sub_ticks = new int[ticks_no + 2];
	    for(int i = 0; i < sub_ticks_no; i++)
		sub_ticks[i] = ticks[i];
	    }
	return;
	}
    sub_ticks_no = s_tick_no;
    ticks_no = tick_no;
    if(tick_no != 0)
	{
	ticks = new int[tick_no + 2];

	labels = (char**)malloc(sizeof(char*) * tick_no + 2);
	for(int i = 0; i < tick_no; i++)
	    {
	    ticks[i] = t[i];
	    labels[i] = strdup(lab[i]);
	    }
	}
    if(s_tick_no != 0)
	{
	if(sub_ticks == NULL)
	    sub_ticks = new int[s_tick_no + 2];
	for(int i = 0; i < s_tick_no; i++)
	    sub_ticks[i] = s[i];
	}
    }
///////////////////////////////////
Axe::~Axe()
    {
    delete ticks;
    delete sub_ticks;
    for(int i = 0; i < ticks_no; i++)
	delete labels[i];
    delete labels;
    }
///////////////////////////////////
void Axe::draw_axe(loc lt, int ax_col, int lab_col)
    {
    show_axe(lt, ax_col);
    drawTool->setcolor(lab_col);
    show_labels(lt);
    }
//////////////////////////////////
/*
int Axe::calc_labels(double start, double end, int t, int s)
    {
    ticks_no = t;
    ticks = new int[ticks_no];
    char str[80];
    for(int i = 0; i < ticks_no; i++)
	{
	sprintf(str, "%g", start + (end - start) / (ticks_no - 1) * i);
	labels[i] = strdup(str);
	ticks[i] = 10000 / (ticks_no - 1) * i;
	}

    sub_ticks_no = s;
    sub_ticks = new int[sub_ticks_no];
    for(i = 0; i < sub_ticks_no; i++)
	sub_ticks[i] = 10000 / (sub_ticks_no - 1) * i;
    return ticks_no;
    }
*/
///////////////////////////////
int Axe::calc_labels(double start, double end, int /*t*/, int s)
    {
    double len = pow10((int)log10(end - start));
    if((end - start) / len <= 3)
	len /= 5;

    ticks_no = (end - start) / len + 1;
    ticks = new int[ticks_no + 2];
    char str[80];

    if(end > 0 && start >= 0)
	{
	int i;
	double pos;
	for(i = 0, pos = (int)(start / len + 1) * len;
	    pos <= end && i < ticks_no; i++, pos += len)
	    {
	    sprintf(str, "%g", pos);
	    labels[i] = strdup(str);
	    ticks[i] = 10000 / ((end - start) / (pos - start));
	    }
	ticks_no = i;
	}
    else if(end <= 0 && start < 0)
	{
	int i;
	double pos;
	for(i = 0, pos = (int)(end / len - 1) * len;
	    pos >= start && i < ticks_no; i++, pos -= len)
	    {
	    sprintf(str, "%g", pos);
	    labels[i] = strdup(str);
	    ticks[i] = start == pos
		? 0 : 10000.0 / ((end - start) / (pos - start));
	    }
	ticks_no = i;
	}
    else
	{
	int i;
	double pos;
	for(i = 0, pos = 0; pos <= end && i < ticks_no; i++, pos += len)
	    {
	    sprintf(str, "%g", pos);
	    labels[i] = strdup(str);
	    ticks[i] = 10000 / ((end - start) / (pos - start));
	    }
	for(pos = -len; pos >= start && i < ticks_no; i++, pos -= len)
	    {
	    sprintf(str, "%g", pos);
	    labels[i] = strdup(str);
	    ticks[i] = start == pos
		? 0 : 10000.0 / ((end - start) / (pos - start));
	    }
	ticks_no = i;
	}
    sub_ticks_no = s;
    if(sub_ticks_no != 0)
	sub_ticks = new int[sub_ticks_no];
    for(int i = 0; i < sub_ticks_no; i++)
	sub_ticks[i] = 10000 / (sub_ticks_no - 1) * i;
    return ticks_no;
    }
