// CARCASE.CPP

#include "carcase.h"

void show_bat(rect where, int pixels,
              int color1 = pColorSet->colors.BORDER_COLOR1,
	      int color2 = pColorSet->colors.BORDER_COLOR2); // draws button

void Carcase::show(BORDERS b_type, rect c, int shadow)
    {
    int color1 = pColorSet->colors.BORDER_COLOR3;
    int color2 = pColorSet->colors.BORDER_COLOR1;
    int color3 = pColorSet->colors.BORDER_COLOR2;

    switch(b_type)
	{
	case NO_BORDER:
	    break;           // no carcase
        case SHOW_BORDER:
            setlinestyle(SOLID_LINE, 1, 1);
	    setcolor(color1);
            ::rectangle(rect(c.origin + shadow, c.corner - shadow));

            setlinestyle(SOLID_LINE, 1, 3);
            setcolor(color2);
            ::rectangle(rect(c.origin + shadow + 2, c.corner - shadow - 2));
            ::rectangle(rect(c.origin + shadow + 5, c.corner - shadow - 5));

            setlinestyle(SOLID_LINE, 1, 1);
            setcolor(color1);
            ::line(c.origin.X + shadow + 6, c.origin.Y + shadow + 6,
	           c.corner.X - shadow - 6, c.origin.Y + shadow + 6);
            ::line(c.origin.X + shadow + 6, c.origin.Y + shadow + 6,
	           c.origin.X + shadow + 6, c.corner.Y - shadow - 6);
            setcolor(color3);
            ::line(c.origin.X + shadow + 6, c.corner.Y - shadow - 6,
	           c.corner.X - shadow - 6, c.corner.Y - shadow - 6);
            ::line(c.corner.X - shadow - 6, c.origin.Y + shadow + 6,
	           c.corner.X - shadow - 6, c.corner.Y - shadow - 6);
            break;
	case STANDART_BORDER:
	    setlinestyle(SOLID_LINE, 1, 1);
	    setcolor(color3);
	    ::rectangle(rect(c.origin + shadow, c.corner - shadow));

	    setcolor(color1);
	    setlinestyle(SOLID_LINE, 1, 3);
	    ::rectangle(rect(c.origin + shadow + 4, c.corner - 4 - shadow));

	    setcolor(color2);
	    ::rectangle(rect(c.origin + shadow + 2, c.corner - 2 - shadow));
	    break;
	case BUTTON_BORDER:
	    show_bat(rect(c.origin + shadow, c.corner - shadow),
			  2, color3, color1);
	    break;
	case HILITE_BORDER:
	    setlinestyle(SOLID_LINE, 1, 1);
	    setcolor(color1);
	    rectangle(rect(c.origin + shadow + 1, c.corner - shadow - 1));
	    break;
	case PRESS_BORDER:
	    show_bat(rect(c.origin + shadow, c.corner - shadow),
			  2, color1, color3);
	    break;
	}
    }
/////////////////////////////
void show_bat(rect where, int pixels, int color1, int color2)
    {
    int pix = (pixels > 1) ? pixels / 2 : pixels;
    setfillstyle(SOLID_FILL, color1);

    bar(where.corner.X - pixels + 1, where.origin.Y,
	where.corner.X, where.corner.Y);
    bar(where.origin.X, where.corner.Y - pixels + 1,
	where.corner.X, where.corner.Y);

    setfillstyle(SOLID_FILL, color2);

    bar(where.origin.X, where.origin.Y,
	where.origin.X + pixels - 1, where.corner.Y - pixels + 1);
    bar(where.origin.X, where.origin.Y,
	where.corner.X - pixels + 1, where.origin.Y + pixels - 1);

    if(pix != pixels)
	{
	bar(where.origin.X, where.origin.Y,
	    where.origin.X + pix - 1, where.corner.Y - pix + 1);
	bar(where.origin.X, where.origin.Y,
	    where.corner.X - pix + 1, where.origin.Y + pix - 1);
	}
    }
/////////////////////////////////////
/*
void demo()
    {
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    show_bat(rect(10, 10, 50, 30), 6, LIGHTGRAY, WHITE);

    Carcase carcase;

    carcase.show(HILITE_BORDER, rect(10, 60, 50, 100), 0);
    carcase.show(BUTTON_BORDER, rect(70, 10, 110, 100), 0);
    carcase.show(SHOW_BORDER, rect(120, 10, 160, 100), 0);
    carcase.show(STANDART_BORDER, rect(170, 10, 210, 100), 0);
    carcase.show(PRESS_BORDER, rect(220, 10, 250, 100), 0);
    }

void main()
    {
    if(!init_KNOW_HOW())
        return;
    demo();
    pColorSet->loadColorSet(1);
    demo();
    pColorSet->loadColorSet(2);
    demo();
    close_KNOW_HOW();
    closegraph();
    }
*/