#include "ceditl.h"
#include "patterns.h"
#include "khbgi.h"

void CaptureEditLine::show()
    {
    rect r = bound();
    int bc = r.corner.X;
    int txtlen = textwidth(header);
    switch(where)
	{
	case C_RIGHT:
	    r.corner.X += txtlen;
	    settextjustify(LEFT_TEXT, CENTER_TEXT);
	    break;
	case C_TOP:
	    r.origin.Y -= pScreenSet->cell_height;
	    settextjustify(CENTER_TEXT, TOP_TEXT);
	    break;
	case C_BOTTOM:
	    r.corner.Y += pScreenSet->cell_height;
	    settextjustify(CENTER_TEXT, BOTTOM_TEXT);
	    break;
	}

    if(header[0] != '\0')
	{
	bar(r, pColorSet->colors.HDR_BAK_COLOR,
	    pColorSet->colors.FILL_COLOR,
	    (uchar*)::pattern[hdr_pat]);
	loc txtpos = (where == C_TOP) ?
	    loc(r.origin.X + r.width() / 2, r.origin.Y + 2)
	    : loc(bc, r.origin.Y + r.height() / 2);
	setcolor(pColorSet->colors.ATTR_COLOR);
	outtextat(txtpos, header);
	}
    EditLine::show();
    }