#include <stdlib.h>
#include "colors.h"
#include <process.h>
#include <iostream.h>


#define CO_16 = 15;   // 16 color mode

ColorSet* pColorSet;
ScreenSet* pScreenSet;


ColorSet::ColorSet()
    {
    color_set_number = 1;
    loadColorSet(0);
    }
//////////////////////////
void ColorSet::loadColorSet(int number)
    {
    if(color_set_number == number)    // Already loaded
        return;
    color_set_number = number;
    char* colorSetFileName = "colors.set";
    FILE* colorFP;
    if((colorFP = fopen(colorSetFileName, "r")) == NULL)       // Can not open
        exit(1);
    int count = 0;
    char s[30];
    while(count < number)
        {
	if(fgets(s, 29, colorFP) == NULL)
	    exit(1);
        if(s[0] == '@')
            count++;
        }

    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.HILITE_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.BAK_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.FILL_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.ATTR_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.SHADOW_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.HDR_BAK_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.HDR_ATTR_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.MARK_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.MARK_BAK_COLOR = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.BORDER_COLOR1 = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.BORDER_COLOR2 = atoi(s);
    fgets(s, 29, colorFP);
    s[2] = '\0';
    colors.BORDER_COLOR3 = atoi(s);

    fclose(colorFP);
    }
////////////////////////////
// This function initialise system not for all possible modes.
// To use another regime or mode - add corresponding block
ScreenSet::ScreenSet(int gdriver, int gmode)
    {
    icon_types[0] = loc(0, 0);
    icon_types[1] = loc(7, 3);            // TEXT size of icons
    icon_types[2] = loc(3, 1);
    icon_types[3] = loc(15, 5);

    int maxX = getmaxx() + 1;
    int maxY = getmaxy() + 1;

    cell_height = maxY / 25;
    if(maxX == 640)             // To use system with low resolution add
	log2cell_width = 3;     // corresponding operator.
    else
        log2cell_width = 4;

    cell_width  = 1 << log2cell_width;

    ICON_PIXELS_1 = loc(cell_width * 7, cell_height * 3);
    ICON_PIXELS_2 = loc(cell_width * 3, cell_height);
    ICON_PIXELS_3 = loc(cell_width * 15, cell_height * 5);

    standart_width =   cell_width;  // Char dimentions, not connected with
    standart_height =  cell_width;  // cells. Used as default for screen
    sub_interval    = cell_width + 4;  // output.

    g_driver = gdriver; g_mode = gmode;
    }
//////////////////////////
int* ScreenSet::get_cells(rect cur_rect)
    {
    int* cells = new int[25 * 80 + 1];
    int cells_num = 0;
    for(int y = cur_rect.origin.Y; y < cur_rect.corner.Y + 1;
	y += pScreenSet->cell_height)
	for(int x = cur_rect.origin.X; x < cur_rect.corner.X + 1;
	    x += pScreenSet->cell_width)
	    {
	    cells[cells_num] = y / pScreenSet->cell_height * 80
		+ (x >> pScreenSet->log2cell_width);
	    cells_num++;
	    }

    cells[cells_num] = -1;

    return cells;
    }
//////////////////////////
int init_KNOW_HOW(int gdriver, int macros)
    {
    int gmode;
    if(gdriver == -1)                  // Ask for the monitor type
        {
	cout << "\n\n    KNOW-HOW Object Oriented Graphics Tools Line\n\n";
        cout << "    (C) Stepan Vartanov, 1992 - 1994.\n";
	cout << " \n";
        cout << "\n";
        cout << " VGAMED, EGAHI....1 \n";
        cout << " VGAHI............2 \n";
        cout << "\n";
        cout << " Input monitor mode: ";
        int a;
        cin >> a;
        switch(a)
	    {
	    case 2: gdriver = VGA; gmode=VGAHI; break;
	    default: gdriver = EGA; gmode=EGAHI; break;
            }
        }
    else
        switch(gdriver)
	    {
	    case EGA: gmode = EGAHI; break;
            case VGA: gmode = VGAHI; break;
            default: break;
            }
    int errorcode;
    initgraph(&gdriver, &gmode, "");
    errorcode = graphresult();
    if (errorcode != grOk)  /* An error occurred */
        return 0;
    global_init();   // initialize global with 0
    if(macros)
        init_macros();
    pScreenSet = new ScreenSet(gdriver, gmode);
    pColorSet = new ColorSet();

    mouseReset();  // mouse init
    return 1;
    }
//////////////////////
void close_KNOW_HOW()
    {
    delete pScreenSet;
    delete pColorSet;
    global_remove();

    while(macros_used > 0)             // if script will terminate the program
	{                               // and stack is not empty
	mac_status mac = macros_pop();
	delete mac.file;
	}
    delete scriptFileName;

    fcloseall();
    }
//////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    pColorSet->loadColorSet(2);
    close_KNOW_HOW();
    closegraph();
    }
*/