#include "edit.h"
#include <string.h>
#include "addevent.h"

#include <iostream.h>

#include "ljfonts.h"
#include "textlast.h"

int text_last(char* str)            // returns len after last '\n'
    {
    char* st = str;
    char* s;
    while(1)
	{
	s = strchr(st, '\n');
	if(!s)
	    break;
	st = s + 1;
	}
    return strlen(st);
    }
////////////////////////////

inline void moveto(loc xy, int dir)
    {
    if(dir) moveto(xy.Y, getmaxx() - xy.X);
    else moveto(xy);
    }
////////////////////
inline int getmaxx(int dir)
    {
    if(dir) return getmaxy();
    return getmaxx();
    }
///////////////////
inline int getmaxy(int dir)
    {
    if(dir) return getmaxx();
    return getmaxy();
    }
////////////////////
int text_width(char* str, ljfont* fnt, int DATA_SIZE)       // correct return len of str, when str is
    {                           // line of deformated BGI characters
    int len = 0;
    char s[2];
    s[1] = '\0';
    int n = strlen(str);
    while(n > 0)
	{
	s[0] = str[n - 1];
	len += fnt->scaledtextsize(s, DATA_SIZE, DATA_SIZE).width();
	n--;
	}
    return len;
    }
//////////////////////////
void text_out(loc where, char* str, ljfont* fnt, int mode, int DATA_DIR,
    int DATA_SIZE)
    {
    int len = 0;
    char st[500];
    strncpy(st, str, 499);
    char* s;
    moveto(where, DATA_DIR);
    while(1)
	{
	s = strchr(str + len, '\n');
	if(!s)
	    {
	    drawscaledstr(*fnt, str + len, DATA_SIZE, DATA_SIZE, mode,
		DATA_DIR);

	    break;
	    }
	strncpy(st, str + len, s - str - len);
	st[s - str - len] = '\0';

	len = s - str + 1;
	moveto(where, DATA_DIR);
	drawscaledstr(*fnt, st, DATA_SIZE, DATA_SIZE, mode,
		DATA_DIR);

	if(!DATA_DIR)
	    where.Y += 3 * fnt->scaledtextsize("H!", DATA_SIZE,
		DATA_SIZE).height() / 2;
	else
	    where.Y -= 3 * fnt->scaledtextsize("H!", DATA_SIZE,
		DATA_SIZE).height() / 2;
	moveto(where, DATA_DIR);
	}
    }
//////////////////////////////
void text_edit1(loc mspos, rect r, ljfont* fnt, int DATA_SIZE, int DATA_DIR,
    int DATA_ATTR)
    {
    char* str = new char[5000];         // work buffer
    str[0] = '\0';         // end of line

    setviewport(r.origin.X, r.origin.Y, r.corner.X, r.corner.Y, 1);

    loc res_pos = mspos = mspos - r.origin;    // str beginning - for ESC only
    if(DATA_DIR)
	res_pos = mspos = loc(mspos.Y, getmaxx() - mspos.X);

    int len = 0;                      // last string len
    mouseHideCursor();
    setwritemode(XOR_PUT);
    setcolor(WHITE);
    moveto(mspos, DATA_DIR);
    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
		 XOR_PUT, DATA_DIR );         // show "_"
    while(1)
	{
// get char
	get_event(1);
// cancel string
	if((e.what == MOUSEEVENT && e.msstatus.buttonstate == MOUSERIGHT) ||
	    (e.what == KEYEVENT && e.key == EVENT_ESC))
	    {
	    moveto(mspos, DATA_DIR);
	    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
		 XOR_PUT, DATA_DIR );	 // remove "_"
	    text_out(res_pos, str, fnt, XOR_PUT, DATA_DIR, DATA_SIZE);        // hide str
	    len = 0;
	    str[0] = '\0';
	    moveto(res_pos, DATA_DIR);
	    mspos = res_pos;
	    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
		 XOR_PUT, DATA_DIR );	 // show "_"
	    }
// accept string
	else if((e.what == MOUSEEVENT && e.msstatus.buttonstate == MOUSELEFT)
		|| (e.what == KEYEVENT && e.key == EVENT_F2))
	    {
	    moveto(mspos, DATA_DIR);
	    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
		 XOR_PUT, DATA_DIR );	 // remove "_"
	    setwritemode(COPY_PUT);
	    setcolor(DATA_ATTR);
	    text_out(res_pos, str, fnt, COPY_PUT, DATA_DIR, DATA_SIZE);        // rewrite str with current color
	    break;
	    }
	else                               // not ESC and not OK
	    switch(e.key)
		{
		case EVENT_RETURN:
		    moveto(mspos, DATA_DIR);
		    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			 XOR_PUT, DATA_DIR );	 // remove "_"

		    if(!DATA_DIR)
			mspos.Y += 3 * fnt->scaledtextsize("H!", DATA_SIZE,
			    DATA_SIZE).height() / 2;
		    else
			mspos.Y -= 3 * fnt->scaledtextsize("H!", DATA_SIZE,
			    DATA_SIZE).height() / 2;

		    mspos.X = res_pos.X;

		    str[strlen(str) + 1] = '\0';
		    str[strlen(str)] = '\n';
		    len = 0;
		    moveto(mspos, DATA_DIR);
		    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			 XOR_PUT, DATA_DIR );	 	 // show "_"
		    break;
		case EVENT_BKSP:
		    if(str[0] == '\0')    // line beginning
			break;
		    if(!len)        // we are trying to remove '\n'
			{
			str[strlen(str) - 1] = '\0';
			len = text_last(str);
			moveto(mspos, DATA_DIR);
			drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			 XOR_PUT, DATA_DIR );	 	 // remove "_"

			if(!DATA_DIR)
			    mspos = loc(res_pos.X +
				    text_width(str
					+ strlen(str) - len, fnt, DATA_SIZE),
				    mspos.Y
					- 3 * fnt->scaledtextsize("H!",
					DATA_SIZE, DATA_SIZE).height() / 2);
			else
			    mspos = loc(res_pos.X -
				    text_width(str
					+ strlen(str) - len, fnt, DATA_SIZE),
				    mspos.Y
					+ 3 * fnt->scaledtextsize("H!",
					DATA_SIZE, DATA_SIZE).height() / 2);

			moveto(mspos, DATA_DIR);
			drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			 XOR_PUT, DATA_DIR );  // show "_"
			}
		    else    // it is char
			{
			moveto(mspos, DATA_DIR);
			drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			     XOR_PUT, DATA_DIR );

			if(!DATA_DIR)
			    mspos.X -= fnt->scaledtextsize(str + strlen(str)
				- 1, DATA_SIZE,
				DATA_SIZE).width();
			else
			    mspos.X += fnt->scaledtextsize(str + strlen(str)
				- 1, DATA_SIZE,
				DATA_SIZE).width();

			moveto(mspos, DATA_DIR);
			drawscaledstr(*fnt, str + strlen(str) - 1,
			    DATA_SIZE, DATA_SIZE,
			    XOR_PUT, DATA_DIR );
			moveto(mspos, DATA_DIR);
			len--;
			str[strlen(str) - 1] = '\0';
			drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			     XOR_PUT, DATA_DIR );
			}
		    break;
		default:            // input of char
		    if(strlen(str) > 5000)
			{
			setviewport(0, 0, getmaxx(), getmaxy(), 1);
			setcolor(DATA_ATTR);
                        delete str;
                        return;
			}

		    char s[3];
		    s[0] = e.key;
		    s[1] = '\0';
		    moveto(mspos, DATA_DIR);         // remove "_"

		    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			     XOR_PUT, DATA_DIR );
		    moveto(mspos, DATA_DIR);
		    drawscaledstr(*fnt, s, DATA_SIZE, DATA_SIZE,
			     XOR_PUT, DATA_DIR );

		    len++;
		    str[strlen(str) + 1] = '\0';
		    str[strlen(str)] = e.key;

		    if(!DATA_DIR)
			mspos.X += fnt->scaledtextsize(s,
			    DATA_SIZE, DATA_SIZE).width();
		    else
			mspos.X -= fnt->scaledtextsize(s,
			    DATA_SIZE, DATA_SIZE).width();

		    moveto(mspos, DATA_DIR);
		    drawscaledstr(*fnt, "_", DATA_SIZE, DATA_SIZE,
			     XOR_PUT, DATA_DIR );
		    }
	}
    setwritemode(COPY_PUT);
    mouseShowCursor();
    setcolor(DATA_ATTR);
    setviewport(0, 0, getmaxx(), getmaxy(), 1);
    delete str;
    delete fnt;
    }
///////////////////////////
