/* IC_PART.H
		BGI can not cut images at viewport borders, so we need
		something like this.
*/

#ifndef __IC_PART_H_
#define __IC_PART_H_

#include <graphics.h>
#include "geom.h"
#include "image_p.h"

#define N_PLANE_SH 2   // Use: x << 2
#define N_PLANES 4     // Standart number of planes

/*
    Image is the area in memory. After the cut_image_horiz or cut_image_vert
    call we have new (cut) image in the same area. This speed up the work
    because we do not need to allocate new memory, but the initial image
    will be destroyed.
*/
extern void cut_image_vert(imageP image, int width, int leave_left);
extern void cut_image_horiz(imageP image, int height, int leave_up);
/////////////////////////
/*
    image_cut cut the image, keeping result in the other area of
    memory. Images are one-line height.
    Arguments: image - source image, work - destination image,
               x - beetween image beginning and dest. beginning
	           (User should assign the work->xmax and work->ymax
		   correct values), bplin - in image, sz - size of work.
*/
inline void image_cut(imageP image, imageP work, int x, int bplin, int sz);
/////////////////////////
/*
    cut_image and cut works with image using cut_image_vert and
    cut_image_horiz. Initial image will be destroyed. cut_image is used
    in help view icon scrolling.    cut_image:|          cut:
    It can not get the central      **********|***     *************
    area of the image - only        *  leave  |  *     *c  _____   *
    the periferial. cut uses two  ____________|  *     *u |leave|  *
    calls to cut_image to obtain    *    cut     *     *t |_____|  *
    any part of image.              **************     *************
*/
extern void cut_image(imageP image, rect src, rect dest);
extern void cut(imageP image, rect src);  // src - position of rectangle inside image
/////////////////////////
/*
    put_image shows the image in the viewport using the call to
    cut_image. ATTENTION!!! It can cut only periferial part of
    the image.
*/
extern void put_image_correct(imageP image, rect src);

extern void putimage(int x, int y, imageP image,    // for 25x80 cells screen, show
	      int* cells, imageP work,              // only cells, which are listed
	      int bplin, int mode = COPY_PUT);      // Do not use it for compatibility.

#endif __IC_PART_H_