#include "image.h"
#include "ic_part.h"

#include <alloc.h>
#include <mem.h>

#include <stdio.h>

inline unsigned char hi(unsigned char pix1, int pos)
    { return ((unsigned char)(pix1 >> (8 - pos % 8))) << (8 - pos % 8); }
inline unsigned char lo(unsigned char pix, int pos)
    { return ((unsigned char)(pix << (pos % 8 + 1))) >> (pos % 8 + 1); }
/////////////////////////////
void image_put_pixel(imageP image, loc pos, int col, int bitpx, int nplanes)
    {
    int line_size = ((image->xmax + 1) * bitpx + 7) >> 3;
    int start = line_size * pos.Y * nplanes;
    int work_byte = pos.X * bitpx >> 3;

    unsigned char p, pix;
    register int plane;
    for(plane = 0; plane < nplanes; plane++, work_byte += line_size)
	{
	pix = p = image->data[start + work_byte];

	switch(bitpx)
	    {
	    case 1:
		image->data[start + work_byte]
		    = (unsigned char)(hi(pix, pos.X) | lo(p, pos.X)
			     | (((col & (1 << (nplanes - plane - 1))) >> (nplanes - plane - 1))
			       << (7 - pos.X % 8)));
		break;
	    case 2:
		image->data[start + work_byte]
			= (unsigned char)(hi(pix, pos.X * 2)
					| lo(p, pos.X * 2 + 1)
			     | ((col & 3) << (6 - (pos.X * 2) % 8)));
		break;
	    case 8:
		image->data[start + work_byte]
			= (unsigned char)col;
		break;
	    }
	}
    }
/////////////////////////////
int image_get_pixel(imageP image, loc pos, int bitpx, int nplanes)
    {
    int line_size = ((image->xmax + 1) * bitpx + 7) >> 3;
    int start = line_size * pos.Y * nplanes;
    int work_byte = pos.X * bitpx >> 3;

    unsigned char pix, result = 0;
    register int plane;
    int step = (7 - pos.X % 8);
    for(plane = 0; plane < nplanes; plane++, work_byte += line_size)
	{
	switch(bitpx)
	    {
	    case 1:
		pix = image->data[start + work_byte];
		result = result
			 | ((pix >> step & 1) << (nplanes - plane - 1));
		break;
	    case 2:
		pix = image->data[start + work_byte];
		result = ((pix >> (6 - (pos.X * 2) % 8)) & 3);
		break;
	    case 8:
		result = image->data[start + work_byte];
		break;
	    }
	}
    return result;
    }
/////////////////////////////
void image_screen(imageP image, rect src, loc dest,   // src - in image, dest - on screen
		 int bitpx, int nplanes,
		 loc comp_s,                   // divx, divy, multx, multy
		 loc comp_d, int flag)         // rects are the outlines
    {                                          // image show with deformation
    if(src.height() > image->ymax + 1)
        src.corner.Y = src.origin.Y + image->ymax + 1;

    if(comp_s.X != comp_d.X || comp_s.Y != comp_d.Y || flag)
	{
	long is, js;                         // source x and y
	int id, jd;                          // destination (screen) x and y
	int step_y = ((long)comp_s.Y << 10) / comp_d.Y;  // step in src
	int step_x = ((long)comp_s.X << 10) / comp_d.X;
	for(js = (long)src.origin.Y << 10, jd = dest.Y;
	    js < (long)src.corner.Y << 10; js += step_y, jd++)
	    for(is = (long)src.origin.X << 10, id = dest.X;
		is < (long)src.corner.X << 10; is += step_x, id++)
		{
		int pix = image_get_pixel(image, loc(is >> 10, js >> 10),
		    bitpx, nplanes);
   	        putpixel(id, jd, pix);
		}
	}
    else
	{
	loc reserv = loc(image->xmax, imageP(image)->ymax);
        cut(image, src);
	putimage(dest.X, dest.Y, image, COPY_PUT);
	image->xmax = reserv.X;
	image->ymax = reserv.Y;
	}
    }
/////////////////////////////
void cpy(char* de, char* sr, int l)
    {
    for(int i = 0; i < l; i++)
	de[i] = sr[i];
    }

void screen_image(imageP image, rect src, loc dest) // no deformation
    {
    int src_bytes_plane = (src.width() + 7) >> 3;
    int dst_bytes_plane = (image->xmax + 8) >> 3;
    char work[400];
    int dst = dst_bytes_plane << 2;
    int vshift;

    imageP im = (imageP)work;
    int hshift = dest.X >> 3;

    for(int y = 0; y < src.height(); y++)
	{
	getimage(src.origin.X, src.origin.Y + y, src.corner.X,
		 src.origin.Y + y, im);
	vshift = dest.Y + y;
	for(int d = 0; d < 4; d++)
	    {
	    cpy(image->data + vshift * dst
		   + dst_bytes_plane * d + hshift,
		   im->data + src_bytes_plane * d, src_bytes_plane);
	    }
	}
    }
/////////////////////////////

/*
void main()
    {
    int gdriver = VGA, gmode = VGAHI;
    initgraph(&gdriver, &gmode, "..\\BGI");

    bar(10, 10, 100, 100);
    setcolor(3);
    circle(50, 50, 40);
    line(0, 0, 100, 100);

    imageP image = (imageP)malloc(imagesize(0, 0, 40, 40));
    getimage(10, 10, 49, 49, image);

    image_screen(image, rect(0, 0, 35, 35), loc(100, 100),
		 1, 4, loc(2, 2), loc(10, 10));

    delete image;
    closegraph();
    }
*/