#ifndef __KH_PX_TABLE_H_
#define __KH_PX_TABLE_H_

#include "abstable.h"
#include "pxtable.h"

class KH_PX_Table : public KH_AbstractTable, public KH_PXTable
    {
    public:
	KH_PX_Table(rect coordinates,             // Screen cells
	       char* tabName,                     // Table name
	       char* fName = "",                  // File for swapping
	       char* h = "",                      // Header text
	       int s = 0,                         // Shadow, pixels
	       BORDERS b_type = SHOW_BORDER,      // Border type
	       BORDERS hdr_b_type = SHOW_BORDER,  // Border around header
	       int res = 0,                       // Resize status
	       int hdr_pat = 0,                  // Attention! No window pattern.

// Use last 3 arguments for creating new table.
	       int fNo = 0,               // Number of fields in table
	       char** fields = NULL,      // Fields names array
	       char** types = NULL);       // Fields types array

	   ~KH_PX_Table() { delete iColWidth; delete colNumbers; }
	   int check_type(int type, char* string);
	   virtual long RecordNumber();
           long getYPos() { return yStart + yPos + 1; }
	   virtual int getColumnNumber();
	   virtual void getFieldName(char* name, int n);
	   virtual void showField(int sx, int x, int y, int flag,
	       int field_type);
	   virtual void saveTable();
	   virtual int writeAccess() { return 1; }  // No write protect !!!
	   virtual void editField();
	   virtual int getFieldMaxWidth();
	   virtual void insRecord();
	   virtual void delRecord();
	   virtual int searchField(int ask);
/* After processing of touch() function global_num is set to the
     number of fields in table (fieldNames->used), global[1 - global_num]
     is set to translated fields values, global[global_num + 1] is set to
     tableName, and global[0] is set to "Ask" string.
     global_i[1 - global_num] is set to FIELD_TYPES.
*/
       	   virtual void touch(int i = 0);
    };


#endif __KH_PX_TABLE_H_