#include <stdlib.h>
#include "kh_graf.h"

KH_Graf::KH_Graf(rect coordinates, char* fName, char* h, int s,
    BORDERS b_type, BORDERS hdr_b_type, int pat, int hdr_pat,
        int ax_col, int lab_col, int grid_style, int save_file_name)
    : Window(coordinates, fName, h, s, b_type, hdr_b_type, FIXED, pat, hdr_pat),
    Grafic(rect(0, 0, 10, 10), ax_col, lab_col, grid_style,
           save_file_name)
    {
    Grafic::coord = user_screen();
    Grafic::work_coord = rect(0, 0, coord.width(), coord.height());  // ???????!!!!!!!!
    }
/////////////////////
void KH_Graf::show()
    {
    Window::show();
    setfillstyle(SOLID_FILL, WHITE);
    bar(user_screen());
    }
////////////////////
void KH_Graf::exe(int act)
    {
    e.what = act ? KEYEVENT : NOEVENT;

    switch(act)
	{
	case AC_CANCEL: e.key = EVENT_ESC;    break;
	case AC_OK:     e.key = EVENT_F2;     break;
	}
    mouseHideCursor();
    if(!act)
	hilite();

    int on = 0;
    mouseShowCursor();
    while(1)
	{
	mouseShowCursor();
	if(!act && !(e.what == MOUSEEVENT && !on))
	    get_event();
	else
	    on = 1;
	mouseHideCursor();

	if(e.what == KEYEVENT)
	    switch(e.key)
		{
		case EVENT_F1: global_i[0] = action_type; return;
		case EVENT_ESC: global_num = 0; global_i[0] = AC_NULL; return;
		case EVENT_F6:
		case EVENT_F10:
		case EVENT_TAB:
		case EVENT_ALT_F3:
		case EVENT_ALT_F4:
		case EVENT_ALT_TAB:
		    unhilite(); global_num = 0;
		    global_i[0] = 0; return;
		case EVENT_F2:
		case EVENT_RETURN :  unhilite(); global_num = 0;
		    global_i[0] = action_type; return;
		}
	else
	    {
	    if(!mouse_in(e.where()))
		{
		unhilite();
		global_num = 0; global_i[0] = AC_NULL;
		return;
		}   // outside of menu box
	    }
	if(act)    // leave menu and return to the object which calls it
	    {      // after single processing of "act" command
	    global_num = 0;
	    return;
	    }
	}
    }
///////////////////
void KH_Graf::touch(int i)
    {
    char** lab_x1 = global_i[2] == -1 ? NULL : global + 10;
    int num_lab_x1 = global_i[2] == -1 ? 0 : global_i[2];
    int sub_num_lab_x1 = global_i[3] == -1 ? 0 : global_i[3];
    int* tks_x1 = global_i[2] == -1 ? NULL : global_i + 20;
    int* s_tks_x1 = global_i[3] == -1 ? NULL : global_i + 20 + num_lab_x1;

    char** lab_y1 = global_i[5] == -1 ? NULL : global + 30;
    int num_lab_y1 = global_i[5] == -1 ? 0 : global_i[5];
    int sub_num_lab_y1 = global_i[6] == -1 ? 0 : global_i[6];
    int* tks_y1 = global_i[5] == -1 ? NULL : global_i + 40;
    int* s_tks_y1 = global_i[6] == -1 ? NULL : global_i + 40 + num_lab_y1;

/*
    char** lab_x2 = global_i[8] == -1 ? NULL : global + 50;
    int num_lab_x2 = global_i[8] == -1 ? 0 : global_i[8];
    int sub_num_lab_x2 = global_i[9] == -1 ? 0 : global_i[9];
    int* tks_x2 = global_i[8] == -1 ? NULL : global_i + 60;
    int* s_tks_x2 = global_i[9] == -1 ? NULL : global_i + 60 + num_lab_x2;

    char** lab_y2 = global_i[11] == -1 ? NULL : global + 70;
    int num_lab_y2 = global_i[11] == -1 ? 0 : global_i[11];
    int sub_num_lab_y2 = global_i[12] == -1 ? 0 : global_i[12];
    int* tks_y2 = global_i[11] == -1 ? NULL : global_i + 80;
    int* s_tks_y2 = global_i[12] == -1 ? NULL : global_i + 80 + num_lab_y2;
*/
    char *endptr;
    double start, end, startx, endx, starty, endy;
    switch(i)
        {
        case 0:
            delete global[0];
            global[0] = strdup("KH_GRAF");
            break;
        case -1:                   // Options set
        case -2:
            if(global_i[1] & 1)   // 1-st x axe present
                {
                start = startx = strtod(global[1], &endptr);
                end = endx = strtod(global[2], &endptr);

                set_axe(HORIZ1, work_coord.width() - 1, start, end,
		    num_lab_x1, tks_x1, sub_num_lab_x1, s_tks_x1, lab_x1,
		    global_i[4]);
		}
            if(global_i[1] & 2)   // 1-st y axe present
                {
                start = starty = strtod(global[3], &endptr);
                end = endy = strtod(global[4], &endptr);

                set_axe(VERT1, work_coord.height() - 1, start, end,
		    num_lab_y1, tks_y1, sub_num_lab_y1, s_tks_y1, lab_y1,
		    global_i[7]);
		}
        if(i == -2)
            {
            setfillstyle(SOLID_FILL, WHITE);
            bar(user_screen());

            loc z = get_zero(startx, starty, endx, endy);
            setviewport(coord.origin.X, coord.origin.Y, coord.corner.X,
	        coord.corner.Y, 1);
            grid();
            setcolor(BLACK);     // FOR CROSS
            show_axes();
            setviewport(0, 0, getmaxx(), getmaxy(), 1);
            }
            break;
	}
    }
////////////////////////////////////////////
int KH_Graf::calc_work_rect()
    {
    if(horiz_axe->text_dir == VERT_DIR)
        work_coord.origin.X += 5 * pScreenSet->cell_width;
    else
        {
        int l = 0;
        for(int i = 0; i < horiz_axe->ticks_no; i++)
            l = max(strlen(horiz_axe->labels[i]), l);
        l += 2;
        work_coord.origin.X += l * pScreenSet->cell_width;
	}

    if(vert_axe->text_dir == HORIZ_DIR)
        work_coord.corner.Y -= 2 * pScreenSet->cell_height;
    else
        {
        int l = 0;
        for(int i = 0; i < vert_axe->ticks_no; i++)
            l = max(strlen(vert_axe->labels[i]), l);
        work_coord.corner.Y -= l * pScreenSet->cell_height;
	}
    if(horiz_axe_2 != NULL && horiz_axe_2->text_dir == VERT_DIR)
        work_coord.corner.X -= 5 * pScreenSet->cell_width;
    else if(horiz_axe_2 != NULL)
        {
        int l = 0;
        for(int i = 0; i < horiz_axe_2->ticks_no; i++)
            l = max(strlen(horiz_axe_2->labels[i]), l);
        l += 2;
        work_coord.corner.X -= l * pScreenSet->cell_width;
	}

    if(vert_axe_2 != NULL && vert_axe_2->text_dir == HORIZ_DIR)
        work_coord.origin.Y += 2 * pScreenSet->cell_height;
    else if(vert_axe_2 != NULL)
        {
        int l = 0;
        for(int i = 0; i < vert_axe_2->ticks_no; i++)
            l = max(strlen(vert_axe_2->labels[i]), l);
        work_coord.origin.Y += l * pScreenSet->cell_height;
	}

    if(work_coord.width() < 5 || work_coord.height() < 3)
        return 0;

    return 1;
    }
////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;
    drawTool = new KH_Paint();   // See KHPAINT.H

    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    static double x_ar[] = { -.80, -.60, -.40, -.20, 0, .20, .40, .60, .80 };
    static double y1_ar[] = { -200, -150, -100, -50, 0, 50, 100, 150, 200 };
    static double y2_ar[] = { -100, 100, -20, -5, 19, 100, 200, 100, 100 };


    KH_Graf* tg = new KH_Graf(rect(5, 5, 60, 20), "graf.pcy", "Grafic view",
	       6, SHOW_BORDER, SHOW_BORDER, 17, 20,
	       LIGHTGREEN, LIGHTRED, 3, 0);

    tg->show_window();

    global_i[1] = 3;      //            axes used : x1-2 and y1-2.
    global_i[2] = -1;     //            x1, ticks, autocalculation.
    global_i[3] = -1;     //            x1, number of sub-ticks = 0.
    global_i[4] = 1;      //            x1, horiz. labels.

    global_i[5] = -1;     //            y1, autocalculation.
    global_i[6] = -1;     //            y1, number of sub-ticks = 0.
    global_i[7] = 0;      //            y1, vert. orientation of labels.


    delete global[1];
    delete global[2];
    delete global[3];
    delete global[4];

    global[1] = strdup("-1");   //   min and max double values for all axes.
    global[2] = strdup("1");
    global[3] = strdup("-300");
    global[4] = strdup("600");

    tg->touch(-1);              // 1-st pass.

    tg->calc_work_rect();
    tg->touch(-2);              // Verification after change of work_rect.

    tg->get_x_array(0, 9, x_ar);
    tg->get_y_array(0, 9, y1_ar);
    tg->get_x_array(1, 9, x_ar);
    tg->get_y_array(1, 9, y2_ar);
    tg->get_x_array(2, 9, x_ar);
    tg->get_y_array(2, 9, y2_ar);

    tg->arrays[0]->graf->set_type(BAR, STACKED_BAR_GRAF);
    tg->arrays[1]->graf->set_type(BAR, STACKED_BAR_GRAF);
    tg->arrays[2]->graf->set_type(BAR, STACKED_BAR_GRAF);

    int w = tg->bar_width();
    tg->arrays[0]->graf->set_param(RED, GREEN, w, SLASH_FILL);
    tg->arrays[1]->graf->set_param(RED, CYAN, w, LINE_FILL);
    tg->arrays[2]->graf->set_param(RED, RED, w, XHATCH_FILL);

    setviewport(rect(tg->user_screen().origin + tg->get_work_coord().origin,
        tg->user_screen().origin + tg->get_work_coord().corner), 1);

    loc z = tg->get_zero(-1.00, -300, 1.00, 600) - tg->get_work_coord().origin;
    int* array = tg->get_stacked(0);
    tg->arrays[0]->graf->show(tg->arrays[0]->data_x, array, 9, z.X, z.Y);
    delete array;
    array = tg->get_stacked(1);
    tg->arrays[1]->graf->show(tg->arrays[1]->data_x, array, 9, z.X, z.Y);
    delete array;
    array = tg->get_stacked(2);
    tg->arrays[2]->graf->show(tg->arrays[2]->data_x, array, 9, z.X, z.Y);
    delete array;

    setviewport(0, 0, getmaxx(), getmaxy(), 1);


    tg->exe();
    tg->hide();
    delete tg;
    close_KNOW_HOW();
    delete drawTool;   // See KHPAINT.H
    closegraph();

    }
*/