#ifndef __NET_H_
#define __NET_H_

#include "geom.h"
#include "alloc.h"

#define DELTA 20


struct NODE
    {
    loc pos;
    int view;

    NODE* n1;
    NODE* n2;
    NODE* n3;
    NODE* n4;

    NODE(loc p, int v = 0, NODE* l = NULL, NODE* r = NULL, NODE* u = NULL,
        NODE* d = NULL)
        { pos = p; n1 = l; n2 = r; n3 = u; n4 = d; view = v; }
    NODE(NODE* node) { pos = node->pos; n1 = node->n1; n2 = node->n2;
        n3 = node->n3; n4 = node->n4; view = node->view; }

    int in_node(loc pos);
    };
//////////////////
/*    Supposing we already have NODEs which are linked at the this->next
      level, we need structure for list manipulations. There are: memory
      allocation, insertions and so on. ATTENTION!!! No check procedures.
*/
struct NET
    {
    NODE** list;
    int used;
    int total;

    NODE* current;

    NET() { used = total = 0; list = NULL; current = NULL; }
    ~NET();

    void add(NODE* t) { insert(t, used); }
    void insert(NODE* t, int number);
    NODE* remove(int number);

    loc closest(loc p);  // Find the knot which is closest to loc p.

/*    find_way() function is used to build way from current knote to another
      one with pos coordinate. We suppose that source net is acyclic graph.
      We also suppose that tree is binary.
      find() function finds way from upper level knote to lower level one.
      Algorythm:
          a. Find way from start knote to the graph top.
          b. Find way from destination knote to the graph top.
          c. Compare and exclude duplications. For example, having two graphs
             a-b-c-d and a-b-c-e-f, we should obtain d-c-e-f graph. Last
             knot duplicated is nor excluded.
*/
    int find(NET* net, loc pos);
    NET* find_way(loc pos, loc pos1);
    };

#endif __NET_H_
