/* OBJKIT.H   Class for keeping pointers to objects of the Visible family.
   Start point for any application objects, like "Menu-With-Buttons" etc.
   call exe() of current object with argument act, which modifies this function
   See manual for details.
*/

#ifndef __OBJECT_KIT_H_
#define __OBJECT_KIT_H_

#include "kit.h"
#include "global.h"

class ObjectKit : public Kit, public Visible
    {
    public:
	void assign(Visible* toCall,     // Leaving object "callFrom", with OK - like command, we will process
		    Visible* callFrom,   // user-defined function "application(act_type)" from file "appl.cpp"
		    int act_type);       // or something like that; if return value permits, then go to "toCall"
					 // object

	void set_point(Visible* s, Visible* t)  // Leaving object "s", with
	    {                                   // OK - like command, we will
	    s->set_point(get(t));               // go to "t" object
	    }

	int act_ret();
        void set_ret(int r) { ret = r; }
	virtual void exe(int act = 0);
	virtual void show();
	virtual rect bound()         // 0-th "supply" object is the "pseudo-
	    {                        // window", all objects, belonging to
	    return list[0]->bound(); // container are in this area
	    }
	virtual void repose(rect rec)
	    {
	    list[0]->repose(rec);
	    rearrange();
	    }
	virtual void rearrange() {}  // if we resize or move base window
    };

#endif __OBJECT_KIT_H_