/* PrintManager is the class, which may send buffer of GrafBuffer class
   to printers of different types. The algorithm is: load "bound", print it,
   load next...
*/

#ifndef __PRINT_MANAGER_
#define __PRINT_MANAGER_

#include "gbuf.h"
#include "image.h"

#define MAXPAGE 2000    // maximum page width

enum { EPSON9 = 1, EPSON24, LASERJET_II };
enum { DD, QD, LJ_100, LJ_150 };  // print density
enum { PAPER_OFF = '8', PAPER_ON = '9' };

class PrintManager
    {
    protected:
	int printer_type;      // see enum of printer types
	int density;           // double or quadruple
	int pass;              // how much time to repeate each pass
	int mx, my, dx, dy;    // print time deformation
	int left;              // left indent
	int paper;             // paper-out sensor disable
	int parity;            // minimal number of lines in bound (* 4 for color)
    public:
	PrintManager(int t, int d, int p = 1,
	    rect cmp = rect(1, 1, 1, 1),
	    int lt = 0, int ppr = PAPER_ON, int pa = 1)
	    { printer_type = t; density = d; pass = p;
	      mx = cmp.origin.X; my = cmp.origin.Y;
	      dx = cmp.corner.X; dy = cmp.corner.Y;
	      left = lt; paper = ppr; parity = pa; }

	void set_type(int t) { printer_type = t; }
	void set_density(int d) { density = d; }
	void set_pass(int p) { pass = p; }
	void set_comp(int multx, int multy, int divx, int divy)
	    { mx = multx; my = multy; dx = divx; dy = divy; }
	void set_left(int l) { left = l; }
	void set_paper(int p) {paper = p; }

	void init_printer(int size, int sh);    // set current resolution and so on
	void draw_string(char* str);  // draws graphic string
	void draw_image(imageP image); // print image
	void draw_buffer(GrafBuffer* buf);  // prints buffer

	void draw_pages(GrafBuffer* buf, char* work_name,
			int maxpage = MAXPAGE);
					 // print using page of maxpage width
	void print_part(rect src, GrafBuffer* buf, char* work_name);
    friend class GrafBuffer;
    };

#endif __PRINT_MANAGER_
