//===================================================================
// funcobj.hpp
//
// Version 1.1
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1998-1999 WordenWare
//
// Created:  August 28, 1998
// Revised:  April 10, 1999
//===================================================================

#ifndef _FUNCOBJ_HPP_
#define _FUNCOBJ_HPP_

#include <functional>

#include "numerics.h"

NUM_BEGIN

template<class T>
class BiggerThan
//-------------------------------------------------------------------
// Predicate object used to test if a given value is larger than
// testValue.
//-------------------------------------------------------------------
{
public:
    BiggerThan(const T& x)
	//---------------------------------------------------------------
	// Create a BiggerThan object with test value x.
	//---------------------------------------------------------------
	: _testValue(x) {}

    bool operator()(const T& value)
	//---------------------------------------------------------------
	// Return true if value is greater than this object, false
	// otherwise.
	//---------------------------------------------------------------
	{ return value > _testValue; }

private:
    T _testValue; // test value
};

template<class T>
class IncGen
//-------------------------------------------------------------------
// Generator object used to create a sequence of values starting at
// init and increasing by some increment.
//-------------------------------------------------------------------
{
public:
    IncGen(const T& init, const T& inc = T(1))
	//---------------------------------------------------------------
	// Create a sequence starting at init, with increment inc.
	//---------------------------------------------------------------
    : _start(init), _increment(inc) {}

    const T& operator()()
	//---------------------------------------------------------------
	// Return next element in sequence.
	//---------------------------------------------------------------
	{ _start += _increment; return _start - _increment; }

private:
    T _start;     // next element in sequence.
	T _increment; // increment
};

template<class T>
class ScaleValue
//-------------------------------------------------------------------
// Function object to scale values by a given factor.
//-------------------------------------------------------------------
{
public:
	ScaleValue(const T& s)
	//---------------------------------------------------------------
	// Create a scaleValue object with scaling factor s.
	//---------------------------------------------------------------
	: _scale(s) {}

	T operator()(const T& value)
	//---------------------------------------------------------------
	// Return the scaled value.
	//---------------------------------------------------------------
	{ return value * _scale; }

private:
	T _scale; // scaling factor
};

NUM_END

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 08/28/1998 - New.
// Version 1.1 - 04/10/1999 - Added Numerics namespace.
//                            Added scaleValue object.
//                            Added increment parameter to incGen.
//===================================================================
