//===================================================================
// numerics.h
//
// Version 1.1
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1998-1999 WordenWare
//
// Created:  August 28, 1998
// Revised:  April 10, 1999
//===================================================================

#ifndef _NUMERICS_H_
#define _NUMERICS_H_

#ifndef NO_NUMERICS_DLL
    #define NUMERICS_EXPORT extern "C" __declspec (dllexport)
#else
    #define NUMERICS_EXPORT
#endif

#ifndef NO_NUMERICS_NAMESPACE
    #define NUM_BEGIN namespace Numerics_1_1 {
    #define NUM_END   }
#else
    #define NUM_BEGIN 
    #define NUM_END   
#endif

#include <cfloat>

NUM_BEGIN

static const double NUMERICS_PI        = 3.14159265358979323846;
static const double NUMERICS_E         = 2.71828182845904523536;
static const double NUMERICS_EULER     = 0.5772156649;
static const int    NUMERICS_ITMAX     = 100;
static const double NUMERICS_MAX_ERROR = 5.0e-9;
static const double NUMERICS_FLOAT_MIN = DBL_MIN;
static const double NUMERICS_FLOAT_MAX = DBL_MAX;

NUM_END

namespace num = Numerics_1_1;

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 08/28/1998 - New.
// Version 1.1 - 04/10/1999 - Added Numerics namespace.
//===================================================================
