//===================================================================
// numerror.hpp
//
// Version 1.1
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1998-1999 WordenWare
//
// Created:  August 28, 1998
// Revised:  April 10, 1999
//===================================================================

#ifndef _NUMERROR_H_
#define _NUMERROR_H_

#include "numerics.h"

NUM_BEGIN

NUMERICS_EXPORT void NUMERICS_ERROR(const char *func, const char *msg);
//-------------------------------------------------------------------
// General error handling routine
//-------------------------------------------------------------------

class Exception
//-------------------------------------------------------------------
// Numerics exception class
//-------------------------------------------------------------------
{
public:
	Exception(const char* meth, const char* msg)
	//---------------------------------------------------------------
	// Create and excection thrown by meth with description msg.
	//---------------------------------------------------------------
	{ NUMERICS_ERROR(meth, msg); }
};

NUM_END

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 08/28/1998 - New.
// Version 1.1 - 04/10/1999 - Added Numerics namespace.
//                            Added exception class.
//===================================================================
