/* Power Render Hardware Detection and Control Additions */

#ifndef _PRHRDWRE_
#define _PRHRDWRE__

#ifdef __cplusplus
  extern "C" {
#endif

/* Device types */
#define DEVICE_ANY 0
#define DEVICE_NONE 0
#define DEVICE_VGA 1
#define DEVICE_SVGA 2
#define DEVICE_3DFX 4
#define DEVICE_MYSTIQUE 5
#define DEVICE_D3D 6

/* Mode Initialization Results */
#define MODE_OPEN_ERROR 0
#define MODE_SUCCESS 1
#define MODE_INVALID -1
#define MODE_RATE_INVALID -2
#define MODE_NO_VESA -4
#define MODE_NOT_SUPPORTED -5
#define MODE_BAD_INFO -6


typedef struct
{
  PR_DWORD  devicetype;
  char      chiptype[20];             /* Name of chip */
  char      boardtype[40];            /* Type of board */
  PR_DWORD  version;

  PR_DWORD  width, height;            /* Width and height of screen */
  PR_DWORD  pitch;                    /* Pitch of display surface */
  PR_DWORD  pages;                    /* Number of pages available */
  PR_DWORD  bitdepth;                 /* Number of bits per pixel */
  PR_DWORD  rate;
} PR_DEVICE;
extern PR_DEVICE PR_OutputDevice;


typedef struct {
  PR_DWORD mode_number;
  PR_DWORD width;
  PR_DWORD height;

  PR_DWORD bits;
  PR_DWORD linear;
  PR_DWORD available;
  PR_DWORD pages;
 } PRMODE_DESC;
extern PRMODE_DESC PR_VideoModes[256];



#define PR_FRONTBUFFER 0
#define PR_BACKBUFFER 1
extern PR_DWORD PR_WriteScreen;
extern PR_DWORD PR_ViewScreen;

extern PR_DWORD *ibuf;
extern block PR_VGABuffer;


void PR_AddVideoMode (PR_DWORD modenumber, PR_DWORD width, PR_DWORD height,
                             unsigned char bits, unsigned char linear,
                             unsigned char available, unsigned char pages);
/* -----------------------------------------------------------------------
   Function:   PR_AddVideoMode
   Purpose:    Adds a video mode to the mode list
   Parameters: ...
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_DetectVGA (void);
/* -----------------------------------------------------------------------
   Function:   PR_DetectVGA
   Purpose:    Looks for the presence of VGA hardware 
   Parameters: None
   Return:     TRUE if found
   ----------------------------------------------------------------------- */


PR_DWORD PR_DetectSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PR_DetectSVGA
   Purpose:    Looks for the presence of SVGA hardware
   Parameters: None
   Return:     TRUE if found
   ----------------------------------------------------------------------- */


PR_DWORD PR_SetModeVGA (PR_DWORD width, PR_DWORD height, PR_DWORD refrate);
/* -----------------------------------------------------------------------
   Function:   PR_SetModeVGA
   Purpose:    Attempts to initialize a video mode 
   Parameters: width - width of mode
               height - height of mode
               refrate - refresh rate
   Return:     MODE_INVALID, MODE_NOT_SUPPORTED, MODE_SUCCESS, MODE_BAD_INFO
   ----------------------------------------------------------------------- */


void PR_ShutdownVGA (void);
/* -----------------------------------------------------------------------
   Function:   PR_ShutdownVGA
   Purpose:    Shuts down a display device 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ShutdownSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PR_ShutdownSVGA
   Purpose:    Shuts down a display device 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_OpenScreenVGA (PR_DWORD screen);
/* -----------------------------------------------------------------------
   Function:   PR_OpenScreenVGA
   Purpose:    Selects a buffer to render on 
   Parameters: screen - PR_FRONTBUFFER or PR_BACKBUFFER
   Return:     None
   ----------------------------------------------------------------------- */


void PR_OpenScreenSVGA (PR_DWORD screen);
/* -----------------------------------------------------------------------
   Function:   PR_OpenScreenSVGA
   Purpose:    Selects a buffer to render on 
   Parameters: screen - PR_FRONTBUFFER or PR_BACKBUFFER
   Return:     None
   ----------------------------------------------------------------------- */


void PR_BeginScreenVGA (void);
/* -----------------------------------------------------------------------
   Function:   PR_BeginScreenVGA
   Purpose:    Initializes a buffer for direct access
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_EndScreenVGA (void);
/* -----------------------------------------------------------------------
   Function:   PR_EndScreenVGA
   Purpose:    Closes a screen after access
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_FlipVGA (PR_DWORD retrace);
/* -----------------------------------------------------------------------
   Function:   PR_FlipVGA
   Purpose:    Swaps front and back buffers
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_FlipSVGA (PR_DWORD retrace);
/* -----------------------------------------------------------------------
   Function:   PR_FlipSVGA
   Purpose:    Swaps front and back buffers 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif

