/* Power Render Quaternion Interface */

#ifndef _PRQUAT_
#define _PRQUAT_


#ifdef __cplusplus
  extern "C" {
#endif


void PR_QuaternionConjugate (PR_QUATERNION *q);
/* -----------------------------------------------------------------------
   Function:   PR_QuaternionConjugate
   Purpose:    Return conjugate of quaternion. 
   Parameters: q - Pointer to the quaternion
   Return:     None
   ----------------------------------------------------------------------- */


void PR_QuaternionFromVector (PR_QUATERNION *q, PR_POINT *v, PR_REAL r);
/* -----------------------------------------------------------------------
   Function:   PR_QuaternionFromVector
   Purpose:    Makes a quaternion from a vector and rotation value
   Parameters: q - Pointer to the quaternion to initialize
               v - Pointer to the vector
               r - the angle in radians
   Return:     None
   ----------------------------------------------------------------------- */


void PR_QuaternionMultiply (PR_QUATERNION *q,
                            PR_QUATERNION *a,
                            PR_QUATERNION *b);
/* -----------------------------------------------------------------------
   Function:   PR_QuaternionMultiply
   Purpose:    Return quaternion product a * b.  Note: order is important!
               To combine rotations, use the product (a=First, b=Second),
               which gives the effect of rotating by First then Second. 
   Parameters: q - Pointer to the result
               a - Pointer to the first quaternion
               b - Pointer to the second quaternion
   Return:     None
   ----------------------------------------------------------------------- */


void PR_QuaternionSlerp (PR_QUATERNION *q, PR_QUATERNION *a,
                         PR_QUATERNION *b, PR_REAL step, PR_DWORD spin);
/* -----------------------------------------------------------------------
   Function:   PR_QuaternionSlerp
   Purpose:    Spherical linear interpolation of unit quaternions with spins
   Parameters: q - Pointer to the resulting quaternion
               a - Pointer to the first quaternion
               b - Pointer to the second quaternion
               step - between 0 and 1.0
               spin - number of spins
   Return:     None
   ----------------------------------------------------------------------- */


void PR_QuaternionToMatrix (PR_QUATERNION *q, PR_MATRIX out);
/* -----------------------------------------------------------------------
   Function:   PR_QuaternionToMatrix
   Purpose:    Construct rotation matrix from (possibly non-unit) quaternion.
   Parameters: q - Pointer to the quaternion
               out - Pointer to the resulting matrix
   Return:     None
   ----------------------------------------------------------------------- */



#ifdef __cplusplus
}
#endif

#endif
