#ifndef _PRRECT_            
#define _PRRECT_         /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif


/* Dirty rectangle screen updates */
typedef struct {           /* Dirty rectangle structure */
  PR_DWORD x1;
  PR_DWORD y1;
  PR_DWORD x2;             /* Used to keep track of what portion of the */
  PR_DWORD y2;             /* screen has been changed, so we can update */
} PR_RECT;                 /* the least amount of video memory */

extern PR_RECT lastrect;   /* Dirty rectangle for the last frame */
extern PR_RECT thisrect;   /* Dirty rectangle for current frame */

extern PR_UCHAR PR_BackgroundColor;

/* Functions */
void PR_ClearLastFrame (block virt, block background);
/* -----------------------------------------------------------------------
   Function:   PR_ClearLastFrame
   Purpose:    Removes the previous image from the screen 
   Parameters: virt - rendering buffer
               background - optional background picture
   Return:     None
   ----------------------------------------------------------------------- */


void PR_UpdateRectangle (void);
/* -----------------------------------------------------------------------
   Function:   PR_UpdateRectangle
   Purpose:    Scan through each polygon that will be drawn and extend
               the rectangle boundaries if needed
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_UpdateScreen (block virt, PR_UCHAR use_vesa, PR_DWORD x, PR_DWORD y);
/* -----------------------------------------------------------------------
   Function:   PR_UpdateScreen
   Purpose:    Shows the changes on the screen using dirty rectangles 
   Parameters: virt - Rendering buffer
               use_vesa - 1 if a vesa copy is required
               x,y - Upper left corner of window on screen
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif


