# Power Render Global Make Options

# version can be either RETAIL or DEBUG
version = RETAIL

# hardware can be one of NONE, 3DFX,  (MYSTIQUE coming soon)
hardware = 3DFX


# Change these to match the directories where you installed the software
# Glide directories are only needed if hardware is 3DFX.
# MSI directories are only needed if hardware is Matrox Mystique.
INSTALL_DIR = d:\pr
GLIDE_DIR   = D:\glide24
#MSI_DIR   = D:\drivers\mga\msidos


msg_RETAIL = Linking retail version...
msg_DEBUG  = Linking debug version...

CC       = wcc386
ASM      = wasm
LIBEXE   = wlib


!ifeq version DEBUG
!  ifeq hardware NONE

INC    = -I$(INSTALL_DIR)\include
CFLAGS = -d2 -5r -fp5 -w4 -zp1 $(INC)
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib

!  else ifeq hardware MYSTIQUE

INC    = -I$(INSTALL_DIR)\include -I$(MSI_DIR)
CFLAGS = -d2 -5r -fp5 -zp1 -w4 $(INC) -D__MYST__ -D__DOS32__
MSI_LIBDIR = $(MSI_DIR)
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, &
         $(MSI_LIBDIR)\msidos_r.lib

!  else ifeq hardware 3DFX

INC    = -I$(INSTALL_DIR)\include -I$(GLIDE_DIR)\glide\src\sst1\include
CFLAGS = -d2 -5r -fp5 -zp1 $(INC) -D__3DFX__ -D__DOS32__ -DGLIDE_HARDWARE &
         -D__GLIDE__
GLIDE_LIBDIR = $(GLIDE_DIR)\glide\lib\dos\register
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, &
         $(GLIDE_LIBDIR)\glide2x.lib, $(GLIDE_LIBDIR)\texus.lib

!  endif
!else ifeq version RETAIL
!  ifeq hardware NONE
INC    = -I$(INSTALL_DIR)\include
CFLAGS = -oneatx -5r -fp5 -w4 -zm -zp1 $(INC)
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib

!  else ifeq hardware MYSTIQUE

INC    = -I$(INSTALL_DIR)\include -I$(MSI_DIR)
CFLAGS = -oneatx -5r -fp5 -w4 -zm -zp1 $(INC) -D__MYST__
MSI_LIBDIR = $(MSI_DIR)
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, &
         $(MSI_LIBDIR)\msidos_r.lib

!  else ifeq hardware 3DFX

INC    = -I$(INSTALL_DIR)\include -I$(GLIDE_DIR)\glide\src\sst1\include
CFLAGS = -oneatx -5r -fp5 -w4 -zm -zp1 $(INC) -D__3DFX__ -D__DOS32__ &
         -DGLIDE_HARDWARE -D__GLIDE__
GLIDE_LIBDIR = $(GLIDE_DIR)\glide\lib\dos\register
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, &
         $(GLIDE_LIBDIR)\glide2x.lib, $(GLIDE_LIBDIR)\texus.lib

!  endif
!endif

.EXTENSIONS:
.EXTENSIONS:.exe 
.EXTENSIONS:.obj 
.EXTENSIONS:.c .asm .h

OBJS    =  $(EXENAME).obj

.SILENT

project :  $(EXENAME).exe

.c.obj:
        *$(CC) $(CFLAGS) $[* 
.asm.obj:
        $(ASM) $[*.asm


$(EXENAME).exe : $(OBJS)
             echo $(msg_$(version))

 @%write  $(EXENAME).LK1 NAME $(EXENAME)

!ifeq version DEBUG
 @%append $(EXENAME).LK1 DEBUG ALL
!endif

 @%append $(EXENAME).LK1 OPTION STACK=32k
 @%append $(EXENAME).LK1 FIL $(EXENAME).OBJ
 @%append $(EXENAME).LK1 LIBR $(LIBS)
 *wlink SYS dos4g @$(EXENAME).LK1

