#include <stdlib.h>
#include <direct.h>
#include <string.h>

#include <pr.h>
#include <prgui.h>

#ifdef __3DFX__
#include <glide.h>
#include <pr3dfx.h>
#endif

#ifdef WIN32
#include <windows.h>
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Object Centering Utility

Centers the vertices of an object around the origin.  This should not
be used with objects that use hierarchies and different pivots.

 Revision History:
 June 15, 1997: Created

*/

char outfile[80];               /* Name of the output file */
PR_OBJECT *object1;
PR_REAL cenx, ceny, cenz;
PR_DWORD device;



void InitializeDevices (void)
{
#ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
#endif

#ifndef WIN32
  if ((device == DEVICE_SVGA) || (device == DEVICE_ANY))
    device = PR_DetectSVGA ();   /* Attempt to find the device */

  if ((device == DEVICE_VGA) || (device == DEVICE_ANY))
    device = PR_DetectVGA ();   /* Attempt to find the device */
#endif

#ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
#endif

#ifndef WIN32
  if (device == DEVICE_SVGA)
    {
     PR_InitializeSVGA ();
     atexit (PR_ShutdownSVGA);
    }
  else if (device == DEVICE_VGA)
    {
     PR_InitializeVGA ();
     atexit (PR_ShutdownVGA);
    }
#endif
}


void main (int argc, char *argv[])
{
  PRGUI_InitPath (argv[0]);


  if (argc < 3)
    {
     PR_FatalError (
                "CENTPRO Utility    version "
                PR_VERSION_NUMBER
                "\n"
		"Copyright 1997 Egerter Software\n\n"
		"Usage: \n"
        "CENTPRO file1.PRO file2.PRO\n", "CENTPRO");
    }

  printf ("CENTPRO Utility    version ");
  printf (PR_VERSION_NUMBER);
  printf ("\nCopyright 1997 Egerter Software\n\n");

#if defined (MSGLIDE) || defined (WTGLIDE)
  device = DEVICE_3DFX;
#else
  device = DEVICE_SVGA;
#endif

  PR_Initialize (50);
  InitializeDevices ();


  PR_AllocMaterials (512);
  PR_AllocTextures (255);
  PR_AllocShadeTables (32);

  object1 = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object1 == NULL)
     PR_FatalError ("An error has occurred when loading the file.\n", "CENTPRO");
     
  PR_CenterObject (object1, &cenx, &ceny, &cenz);

  PR_SavePRO (argv[2], object1, SAVE_ALL_MATERIALS);
}



