#ifndef _FILEUTIL_H_
#define _FILEUTIL_H_

#include <stdio.h>
#include "common.h"

int _pascal_ FileExist( char *name );

//
// Read a file into an unsigned char _FAR_ buffer and return the pointer
// Takes the name of the file, an integer by reference, and a mem buf
// pointer.  If buf is 0, the function will try to allocate enough memory
// for the file.
// Returns 0 if failure or the pointer to the buffer contain the data
// read.
//
char _FAR_* _pascal_ readfile( char *filenamein, int &BufSize,
                               char _FAR_ *buf = 0 );
//
// Write a char _FAR_ buffer to a file with size bytes
// Takes name of file to be written, pointer to buffer, and size of buffer
//
// returns number of bytes actually written or 0 if failed.
//
unsigned  _pascal_ writefile( char *filenameout,
                                char _FAR_ *obuff, unsigned size );

char *PushDir( void );
void _pascal_ Chdir( char *path );
int PopDir( char *path );


#endif
