// This program demonstrates binary I/O methods for super_precision objects.

//              Copyright (c) 1997 William T. Wyatt, Jr.

#include "super.cc"

int main ( )
{
	int i, radix, ictr, j;
	cout << "Enter digits:"; cin >> i;
	cout << "Enter radix:"; cin >> radix;

	// Make y the square root of 2.
	super_precision :: setup (i,radix);
	super_precision x = 2, y;
	y = sqrt (x);
	j = y.disclose_mantissa_word_length();

	// Print the size of the object and the mantissa.
	cout << "sizeof(y)=" << sizeof(y) << endl;
	cout << "sizeof( *(y.mantissa)) = " << 4 << endl;

	// Make y a "persistent" object.  Write it out to file "sup_0001.pob".
	FILE *disk_file_id;
	disk_file_id = fopen ( "sup_0001.pob", "w");
	fwrite ( &y, 1, sizeof(y), disk_file_id);
			// Using 4 = sizeof ( *(y.mantissa))
	for ( ictr = 0; ictr < j; ictr++)
	{		// Write one word at a time.  If you want more
			// efficiency by writing the entire mantissa at once,
			// write a member or friend function that has access
			// to the protected data area of object y.
		i = y.get_mantissa_word (ictr);
		fwrite ( &i, 1, 4, disk_file_id);
	}
	fclose ( disk_file_id);

	// Set y to zero, to prove the restoration.  Then read y from disk.
	y = 0;
	disk_file_id = fopen ( "sup_0001.pob", "r");
	fread ( &y, 1, sizeof(y), disk_file_id);
	for ( ictr = 0; ictr < j; ictr++)
	{		// Read and load one word at a time, checking each.
		fread ( &i, 1, 4, disk_file_id);
		y.super_fill ( ictr + 1, i);
	}
	fclose ( disk_file_id);

	// Prove we got the whole object.
	y *= y;
	y -= 2;

	cout << "Difference of 2 and sqrt(2)^2 = " << y << endl;

	return 0;
}
