/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: memmgr.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Implementation for the Memory management classes.
*
* $Id: memmgr.cpp 1.2 1995/09/16 11:16:06 kjb release $
*
****************************************************************************/

#include "tcl\memmgr.hpp"
#include <stdlib.h>

/*---------------------------- Implementation -----------------------------*/

bool TCMemStack::allocatePoolBlock()
/****************************************************************************
*
* Function:		TCMemStack::allocatePoolBlock
* Returns:		True if block was allocated, false on failure
*
* Description:	Allocates a new large pool block of the specified size,
*				and links it onto the list of allocated pool blocks.
*
****************************************************************************/
{
	BlockList *temp = (BlockList*)malloc(sizeof(BlockList) + blockSize);
	if (temp) {
		temp->next = curBlock;
		curBlock = temp;
		blockCount++;
		return true;
		}
	else
		return false;
}

void TCMemStack::freeFrom(uint block)
/****************************************************************************
*
* Function:		TCMemStack::freeFrom
* Parameters:	block	- Pool block number to start freeing from
*
* Description:	Free's all the pool blocks from 'block' to the current
*				maximum.
*
****************************************************************************/
{
	PRECONDITION(block <= blockCount);
	while (block < blockCount) {
		BlockList *temp = curBlock;
		curBlock = temp->next;
		free(temp);
		blockCount--;
		}
}

void *TCMemStack::allocate(size_t size)
/****************************************************************************
*
* Function:		TCMemStack::allocate
* Parameters:	size	- Size of memory block to allocate
* Returns:		Pointer to the allocated block, or NULL if allocation failed
*
* Description:	Attempts to allocate space for the requested block from
*				the current memory pool. If this fails, we attempt to
*				allocate another memory pool and allocate the memory
*				from there.
*
****************************************************************************/
{
	PRECONDITION(size != 0);
	if (size > blockSize - curLoc) {
		if (allocatePoolBlock())
			curLoc = 0;
		else
			return NULL;
		}
	void *temp = poolStart() + curLoc;
	curLoc += size;
	return temp;
}
