
opdclass o_reg   = { 1, NO , NO , NO , 0};
opdclass o_smem  = { 8, NO , NO , NO , 0};
opdclass o_rmem  = { 8, YES, NO , YES, -2};
opdclass o_mem   = {16, NO , NO , NO , 0};
opdclass o_off   = { 8, YES, NO , NO , 0};
opdclass o_data  = { 8, YES, NO , NO , 0};
opdclass o_data2 = {16, YES, NO , NO , 0};
opdclass o_cond  = { 4, NO , NO , NO , 0};

insclass i_reg   = {1, 1, &o_reg , &o_none, -4, 0};
insclass i_regp  = {1, 1, &o_reg , &o_none,  0, 0};
insclass i_rimed = {2, 2, &o_reg , &o_data, -6, 8};
insclass i_rimd2 = {3, 2, &o_reg , &o_data2,-6, 16};
insclass i_rdir  = {2, 2, &o_reg , &o_smem, -6, 8};
insclass i_rindx = {2, 2, &o_reg , &o_off , -6, 8};
insclass i_rxtd  = {3, 2, &o_reg , &o_mem , -6,16};
insclass i_imed  = {3, 1, &o_data2,&o_none, 16, 0};
insclass i_dir   = {2, 1, &o_smem, &o_none,  8, 0};
insclass i_indx  = {2, 1, &o_off , &o_none,  8, 0};
insclass i_xtd   = {3, 1, &o_mem , &o_none, 16, 0};
insclass i_rel   = {2, 1, &o_rmem, &o_none,  8, 0};
insclass i_cond  = {2, 2, &o_cond, &o_rmem,  0, 8};

choicedef c_adc = {"adcs" , "adcz" , 2, 0, 0xff, NO};
choicedef c_add = {"adds" , "addz" , 2, 0, 0xff, NO};
choicedef c_and = {"ands" , "andz" , 2, 0, 0xff, NO};
choicedef c_bit = {"bits" , "bitz" , 2, 0, 0xff, NO};
choicedef c_cmp = {"cmps" , "cmpz" , 2, 0, 0xff, NO};
choicedef c_eor = {"eors" , "eorz" , 2, 0, 0xff, NO};
choicedef c_lda = {"ldas" , "ldaz" , 2, 0, 0xff, NO};
choicedef c_ldr = {"ldrs" , "ldrz" , 2, 0, 0xff, NO};
choicedef c_ora = {"oras" , "oraz" , 2, 0, 0xff, NO};
choicedef c_sbc = {"sbcs" , "sbcz" , 2, 0, 0xff, NO};
choicedef c_sub = {"subs" , "subz" , 2, 0, 0xff, NO};
choicedef c_dad = {"addds", "adddz", 1, 0, 0xff, NO};
choicedef c_ldd = {"ldds" , "lddz" , 1, 0, 0xff, NO};
choicedef c_std = {"stds" , "stdz" , 1, 0, 0xff, NO};
choicedef c_sta = {"stas" , "staz" , 1, 0, 0xff, NO};
choicedef c_str = {"strs" , "strz" , 1, 0, 0xff, NO};
choicedef c_dsb = {"subds", "subdz", 1, 0, 0xff, NO};
choicedef c_jsr = {"jsrs" , "jsrz" , 1, 0, 0xff, NO};
choicedef c_cpx = {"cpxs" , "cpxz" , 1, 0, 0xff, NO};

opdef optab[] = {
	"aba"    , &i_noopd, 0x1b, geninstr,
	"abx"    , &i_noopd, 0x3a, geninstr,
	"adc"    , (insclass *)&c_adc, 0x00, choiceinstr,
	"adcs"   , &i_rdir , 0x99, geninstr,
	"adci"   , &i_rimed, 0x89, geninstr,
	"adcx"   , &i_rindx, 0xa9, geninstr,
	"adcz"   , &i_rxtd , 0xb9, geninstr,
	"add"    , (insclass *)&c_add, 0x00, choiceinstr,
	"adds"   , &i_rdir , 0x9b, geninstr,
	"addi"   , &i_rimed, 0x8b, geninstr,
	"addd"   , (insclass *)&c_dad, 0x00, choiceinstr,
	"addds"  , &i_dir  , 0xd3, geninstr,
	"adddi"  , &i_imed , 0xc3, geninstr,
	"adddx"  , &i_indx , 0xe3, geninstr,
	"adddz"  , &i_xtd  , 0xf3, geninstr,
	"addx"   , &i_rindx, 0xab, geninstr,
	"addz"   , &i_rxtd , 0xbb, geninstr,
	"and"    , (insclass *)&c_and, 0x00, choiceinstr,
	"ands"   , &i_rdir , 0x94, geninstr,
	"andi"   , &i_rimed, 0x84, geninstr,
	"andx"   , &i_rindx, 0xa4, geninstr,
	"andz"   , &i_rxtd , 0xb4, geninstr,
	"asla"   , &i_reg  , 0x48, geninstr,
	"asld"   , &i_noopd, 0x05, geninstr,
	"aslx"   , &i_indx , 0x68, geninstr,
	"asl"    , &i_xtd  , 0x78, geninstr,
	"asra"   , &i_reg  , 0x47, geninstr,
	"asrx"   , &i_indx , 0x67, geninstr,
	"asr"    , &i_xtd  , 0x77, geninstr,
	"bc"     , &i_cond , 0x20, geninstr,
	"bit"    , (insclass *)&c_bit, 0x00, choiceinstr,
	"bits"   , &i_rdir , 0x95, geninstr,
	"biti"   , &i_rimed, 0x85, geninstr,
	"bitx"   , &i_rindx, 0xa5, geninstr,
	"bitz"   , &i_rxtd , 0xb5, geninstr,
	"bra"    , &i_rel  , 0x20, geninstr,
	"bsr"    , &i_rel  , 0x8d, geninstr,
	"cba"    , &i_noopd, 0x11, geninstr,
	"clc"    , &i_noopd, 0x0c, geninstr,
	"cli"    , &i_noopd, 0x0e, geninstr,
	"clra"   , &i_reg  , 0x4f, geninstr,
	"clrx"   , &i_indx , 0x6f, geninstr,
	"clr"    , &i_xtd  , 0x7f, geninstr,
	"clv"    , &i_noopd, 0x0a, geninstr,
	"cmp"    , (insclass *)&c_cmp, 0x00, choiceinstr,
	"cmps"   , &i_rdir , 0x91, geninstr,
	"cmpi"   , &i_rimed, 0x81, geninstr,
	"cmpx"   , &i_rindx, 0xa1, geninstr,
	"cmpz"   , &i_rxtd , 0xb1, geninstr,
	"coma"   , &i_reg  , 0x43, geninstr,
	"comx"   , &i_indx , 0x63, geninstr,
	"com"    , &i_xtd  , 0x73, geninstr,
	"cpx"    , (insclass *)&c_cpx, 0x00, choiceinstr,
	"cpxs"   , &i_dir  , 0x9c, geninstr,
	"cpxi"   , &i_imed , 0x8c, geninstr,
	"cpxx"   , &i_indx , 0xac, geninstr,
	"cpxz"   , &i_xtd  , 0xbc, geninstr,
	"daa"    , &i_noopd, 0x19, geninstr,
	"deca"   , &i_reg  , 0x4a, geninstr,
	"decx"   , &i_indx , 0x6a, geninstr,
	"dec"    , &i_xtd  , 0x7a, geninstr,
	"des"    , &i_noopd, 0x34, geninstr,
	"dex"    , &i_noopd, 0x09, geninstr,
	"eor"    , (insclass *)&c_eor, 0x00, choiceinstr,
	"eors"   , &i_rdir , 0x98, geninstr,
	"eori"   , &i_rimed, 0x88, geninstr,
	"eorx"   , &i_rindx, 0xa8, geninstr,
	"eorz"   , &i_rxtd , 0xb8, geninstr,
	"inca"   , &i_reg  , 0x4c, geninstr,
	"incx"   , &i_indx , 0x6c, geninstr,
	"inc"    , &i_xtd  , 0x7c, geninstr,
	"ins"    , &i_noopd, 0x31, geninstr,
	"inx"    , &i_noopd, 0x08, geninstr,
	"jmpx"   , &i_indx , 0x6e, geninstr,
	"jmp"    , &i_xtd  , 0x7e, geninstr,
	"jsr"    , (insclass *)&c_jsr, 0x00, choiceinstr,
	"jsrs"   , &i_dir  , 0x9d, geninstr,
	"jsrx"   , &i_indx , 0xad, geninstr,
	"jsrz"   , &i_xtd  , 0xbd, geninstr,
	"lda"    , (insclass *)&c_lda, 0x00, choiceinstr,
	"ldas"   , &i_rdir , 0x96, geninstr,
	"ldai"   , &i_rimed, 0x86, geninstr,
	"ldax"   , &i_rindx, 0xa6, geninstr,
	"ldaz"   , &i_rxtd , 0xb6, geninstr,
	"ldd"    , (insclass *)&c_ldd, 0x00, choiceinstr,
	"ldds"   , &i_dir  , 0xdc, geninstr,
	"lddi"   , &i_imed , 0xcc, geninstr,
	"lddx"   , &i_indx , 0xec, geninstr,
	"lddz"   , &i_xtd  , 0xfc, geninstr,
	"ldr"    , (insclass *)&c_ldr, 0x00, choiceinstr,
	"ldrs"   , &i_rdir , 0x9e, geninstr,
	"ldri"   , &i_rimd2, 0x8e, geninstr,
	"ldrx"   , &i_rindx, 0xae, geninstr,
	"ldrz"   , &i_rxtd , 0xbe, geninstr,
	"lsla"   , &i_reg  , 0x45, geninstr,
	"lsld"   , &i_noopd, 0x05, geninstr,
	"lslx"   , &i_indx , 0x65, geninstr,
	"lsl"    , &i_xtd  , 0x75, geninstr,
	"lsra"   , &i_reg  , 0x44, geninstr,
	"lsrd"   , &i_noopd, 0x04, geninstr,
	"lsrx"   , &i_indx , 0x64, geninstr,
	"lsr"    , &i_xtd  , 0x74, geninstr,
	"mul"    , &i_noopd, 0x3d, geninstr,
	"nega"   , &i_reg  , 0x40, geninstr,
	"negx"   , &i_indx , 0x60, geninstr,
	"neg"    , &i_xtd  , 0x70, geninstr,
	"nop"    , &i_noopd, 0x01, geninstr,
	"ora"    , (insclass *)&c_ora, 0x00, choiceinstr,
	"oras"   , &i_rdir , 0x9a, geninstr,
	"orai"   , &i_rimed, 0x8a, geninstr,
	"orax"   , &i_rindx, 0xaa, geninstr,
	"oraz"   , &i_rxtd , 0xba, geninstr,
	"psha"   , &i_regp , 0x36, geninstr,
	"pshx"   , &i_noopd, 0x3c, geninstr,
	"pula"   , &i_regp , 0x32, geninstr,
	"pulx"   , &i_noopd, 0x38, geninstr,
	"rola"   , &i_reg  , 0x49, geninstr,
	"rolx"   , &i_indx , 0x69, geninstr,
	"rol"    , &i_xtd  , 0x79, geninstr,
	"rora"   , &i_reg  , 0x46, geninstr,
	"rorx"   , &i_indx , 0x66, geninstr,
	"ror"    , &i_xtd  , 0x76, geninstr,
	"rti"    , &i_noopd, 0x3b, geninstr,
	"rts"    , &i_noopd, 0x39, geninstr,
	"sba"    , &i_noopd, 0x10, geninstr,
	"sbc"    , (insclass *)&c_sbc, 0x00, choiceinstr,
	"sbcs"   , &i_rdir , 0x92, geninstr,
	"sbci"   , &i_rimed, 0x82, geninstr,
	"sbcx"   , &i_rindx, 0xa2, geninstr,
	"sbcz"   , &i_rxtd , 0xb2, geninstr,
	"sec"    , &i_noopd, 0x0d, geninstr,
	"sei"    , &i_noopd, 0x0f, geninstr,
	"sev"    , &i_noopd, 0x0b, geninstr,
	"sta"    , (insclass *)&c_sta, 0x00, choiceinstr,
	"stas"   , &i_rdir , 0x97, geninstr,
	"stax"   , &i_rindx, 0xa7, geninstr,
	"staz"   , &i_rxtd , 0xb7, geninstr,
	"std"    , (insclass *)&c_std, 0x00, choiceinstr,
	"stds"   , &i_dir  , 0xdd, geninstr,
	"stdx"   , &i_indx , 0xed, geninstr,
	"stdz"   , &i_xtd  , 0xfd, geninstr,
	"str"    , (insclass *)&c_str, 0x00, choiceinstr,
	"strs"   , &i_rdir , 0x9f, geninstr,
	"strx"   , &i_rindx, 0xaf, geninstr,
	"strz"   , &i_rdir , 0xbf, geninstr,
	"sub"    , (insclass *)&c_sub, 0x00, choiceinstr,
	"subs"   , &i_rdir , 0x90, geninstr,
	"subi"   , &i_rimed, 0x80, geninstr,
	"subd"   , (insclass *)&c_dsb, 0x00, choiceinstr,
	"subds"  , &i_dir  , 0x93, geninstr,
	"subdi"  , &i_imed , 0x83, geninstr,
	"subdx"  , &i_indx , 0xa3, geninstr,
	"subdz"  , &i_xtd  , 0xb3, geninstr,
	"subx"   , &i_rindx, 0xa0, geninstr,
	"subz"   , &i_rxtd , 0xb0, geninstr,
	"swi"    , &i_noopd, 0x3f, geninstr,
	"tab"    , &i_noopd, 0x16, geninstr,
	"tap"    , &i_noopd, 0x06, geninstr,
	"tba"    , &i_noopd, 0x17, geninstr,
	"tpa"    , &i_noopd, 0x07, geninstr,
	"tsta"   , &i_reg  , 0x4d, geninstr,
	"tstx"   , &i_indx , 0x6d, geninstr,
	"tst"    , &i_xtd  , 0x7d, geninstr,
	"tsx"    , &i_noopd, 0x30, geninstr,
	"txs"    , &i_noopd, 0x35, geninstr,
	"wai"    , &i_noopd, 0x3e, geninstr,
};

#define oplen sizeof(optab)/sizeof(opdef)

symbol predef[] = {
	{"ra" , 0x0, &o_reg , (segmnt *)0 },
	{"rb" , 0x1, &o_reg , (segmnt *)0 },
	{"rx" , 0x1, &o_reg , (segmnt *)0 },
	{"sp" , 0x0, &o_reg , (segmnt *)0 },
	{"nz" , 0x6, &o_cond, (segmnt *)0 },
	{"z"  , 0x7, &o_cond, (segmnt *)0 },
	{"ne" , 0x6, &o_cond, (segmnt *)0 },
	{"eq" , 0x7, &o_cond, (segmnt *)0 },
	{"nc" , 0x4, &o_cond, (segmnt *)0 },
	{"c"  , 0x5, &o_cond, (segmnt *)0 },
	{"gez", 0xc, &o_cond, (segmnt *)0 },
	{"gz" , 0xe, &o_cond, (segmnt *)0 },
	{"gt" , 0x2, &o_cond, (segmnt *)0 },
	{"lez", 0xf, &o_cond, (segmnt *)0 },
	{"le" , 0x3, &o_cond, (segmnt *)0 },
	{"lz" , 0xd, &o_cond, (segmnt *)0 },
	{"m"  , 0xb, &o_cond, (segmnt *)0 },
	{"ov" , 0x9, &o_cond, (segmnt *)0 },
	{"nov", 0x8, &o_cond, (segmnt *)0 },
	{"p"  , 0xa, &o_cond, (segmnt *)0 },
	{"ge" , 0x4, &o_cond, (segmnt *)0 },
	{"lt" , 0x5, &o_cond, (segmnt *)0 },
	{""   , 0x0, &o_none, (segmnt *)0 },
};
