#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "local.h"
#include "errors.h"
#include "types.h"
#include "lines.h"

extern BOOL prm_debug;
extern FILENAME *nametable[1];
extern char modname[];

LOCAL **localtable;

HASHREC **localhash;

static int newlocnum = 0;
static char currentlocal[256];

void LocalDefinitions(int mode)
{
	int id;
	char buf[MAX_NAMESIZE+1];

	id = ReadNumber(0);
	CheckForComma(TRUE);
	ReadString(buf,MAX_NAMESIZE+1);
	CheckForPeriod();
	if (id >= MAX_LOCALS)
		fatal("Local ID too big in module %s", modname);
	if (mode == SCAN && prm_debug) {
		HASHREC **q;
		if (!(q =LookupHash(localhash,buf))) {
			LOCAL *q = AllocateMemory(sizeof(LOCAL));
			q->name = AllocateMemory(strlen(buf)+5);
			q->modname = AllocateMemory(strlen(modname)+1);
			strcpy(q->name+4, buf);
			memset(q->name,'0',4);
			strcpy(q->modname, modname);
			q->sect = 0;
			q->id = newlocnum++;
			q->offset = 0;
			q->datatype = TY_TYPE;
			localtable[id] = q;
		}
	}
	else
		strcpy(currentlocal, buf);
}
void LocalRegisterName(int mode, int id, int module, long typenum)
{
	char buf[270];
	if (!prm_debug)
		return;
	sprintf(buf,"%04x",module);
	if (mode == SCAN) {
		if (!localtable[id])
			return;
		localtable[id]->datatype = typenum;
		localtable[id]->module = module;
		memcpy(localtable[id]->name,buf,4);
		AddHash(localhash, localtable[id]);
	}
	else {
		LOCAL **p;
		strcat(buf, currentlocal);
		p = LookupHash(localhash, buf);
		if (p)
			localtable[id] = *p;
	}
}
void LocalSetAddress(void)
{
	LOCAL *q;
	int id;
	long address;
	int sect;
	id = ReadNumber(0);
	CheckForComma(TRUE);
	if (ReadChar() != 'R')
		BadObjectFile();
	sect = ReadNumber(0);
	CheckForComma(TRUE);
	address = ReadNumber(0);
	CheckForComma(TRUE);
	if (ReadChar() != '+')
		BadObjectFile();
	CheckForPeriod();
	if ((q = localtable[id]) != 0) {
		q->offset = address;
		q->sect = GetSection(sect);
	}
}
LOCAL *GetLocal(char *name)
{
	LOCAL **rv = LookupHash(localhash,name);
	if (rv)
		return(*rv);
	return(0);
}
void LocalModuleRundown(uint mode)
{
	int i;
	if (mode == SCAN) {
		LOCAL **p=localtable;
		for (i=0; i< MAX_LOCALS; i++) {
			*p = 0;
			p++;
		}
	}
}
void LocalTableInit(void)
{
	LOCAL **p;
	int i;
	localtable = AllocateMemory(sizeof(LOCAL *) * MAX_LOCALS);
	p = localtable;
	for (i=0; i < MAX_LOCALS; i++) {
		*p = 0;
		p++;
	}
	localhash = CreateHashTable(HASH_TABLE_SIZE);
}
void LocalTableRundown(void)
{
	HASHREC **p = localhash;
	int i;
	DeallocateMemory(localtable);
	for (i=0; i < HASH_TABLE_SIZE; i++) {
		LOCAL *q = *p;
		while (q) {
			LOCAL *r = q->link;
			DeallocateMemory(q->name);
			DeallocateMemory(q->modname);
			DeallocateMemory(q);
			q = r;
		}
		p++;
	}
  RemoveHashTable(localhash);
}

		
		