/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * struct.c
 * 
 * structure handling (very simplistic 
 */
#include <stdio.h>
#include <string.h>
#include "utype.h"
#include "umem.h"
#include "asm.h"
#include "input.h"
#include "dc.h" 
#include "gencode.h"
#include "struct.h"

extern int sectionnum;
extern int lastsectionnum;
extern int org;
extern BYTE *outputbuf;
extern BOOL ifskip;

static int structsection;
static EXPRESSION *structptr;
static BOOL instruct;
static long lastorg;
static BYTE *lastoutput;

void InError(void)
{
  if (instruct)
		Error("Already in structure");
}
void StructCheck(void)
{
	if (instruct) {
		Error("Currently in structure");
		endstruct(FALSE);
	}
}
void strucini(void)
{
	structsection = 0;
	structptr = 0;
	instruct = FALSE;
}
/* begin a structure */
void initstruct(EXPRESSION *label)
{
	if (ifskip) {
		dolist();
		return;
	}
	if (instruct) {
		InError();
		dolist();
		return;
	}
	
	if (!label) {
		structptr = 0;
	}
	else {
		label->islabel = FALSE;
		label->isstruct = TRUE;
		label->isintermed = FALSE;
		label->x.value = 0;
		structptr = label;
	}
	instruct = TRUE;
	structsection = lastsectionnum;
	lastsectionnum = sectionnum;
	sectionnum = 0;
	lastoutput = outputbuf;
	lastorg = 0;
	outputbuf = 0;
	setorg ( 0);
	dolist();
}
/* end a structure */
void endstruct(BOOL tolist)
{
	if (ifskip) {
		dolist();
		return;
	}
	if (!instruct) {
		Error("Not in structure");
		if (tolist)
			dolist();
		return;
	}
	if (structptr) {
		structptr->size = org;
		structptr = 0;
	}
	outputbuf = lastoutput;
	org = lastorg;
	sectionnum = lastsectionnum;
	lastsectionnum = structsection;
	instruct = FALSE;
	
	if (tolist) {
		dolist();
	}
}
/* instantiate a structure */
void inststruct(EXPRESSION *label,  EXPRESSION *stru)
{
	if (ifskip) {
		dolist();
		return;
	}
	if (label)
		label->size = stru->size;
	InError();
	setorg(org + stru->x.value);
	dolist();
}
		