#include <stdio.h>                     
#include <memory.h>
#include <string.h>
#include "utype.h"
#include "umem.h"
#include "asmcom.h"
#include "as68k.h"
#include "locgen.h"
#include "fpgen.h"

extern int pass;
extern HASHREC **hashtable;
extern FILE *listfile;
extern int level;
extern int lineno[];
extern int macrolevel;
extern int prm_procrevision;
extern BOOL ifskip;
extern uint allocsize;
extern int sectionnum;

extern int branchdefault;
extern int opcodesize;
extern BYTE pcbuf[BUFLEN];
extern long org;

int coprocid;
BOOL usefp = FALSE;
BOOL usedfloating = FALSE;
void floatinit(void)
{
	coprocid = 2;
	usedfloating = FALSE;
}

void setfopt(EXPRESSION *exp)
{
	if (!numericExpression(exp) || exp->isextern)
		badexpression();
	coprocid = (exp->x.value & 7) << 1;
}
BOOL floatea_fill(OPERANDDATA *op, int size, BOOL pcallowed, BOOL anallowed, BOOL dnallowed, BOOL constallowed)
{
	int sz = 0;
	if (size >= 0) {
		switch(size) {
			case TBYTE:
				sz = 6;
				break;
			case TWORD:
				sz = 4;
				break;
			case TLONG:
				sz = 0;
				break;
			case TPACKED:
				sz = 3;
				break;
			case TSINGLE:
				sz = 1;
				break;
			case TDOUBLE:
				sz = 5;
				break;
			case TEXTENDED:
				sz = 2;
				break;
		}
		pcbuf[2] |= (sz << 2) | 0x40;
	}
	switch (op->type) {
		case TCONST:
			pcbuf[1] |= EACONST;
			if (!constallowed)
				illop();
				switch(size) {
					case TPACKED: {
							BYTE fp[12];
							BYTE pack[12];
							if (op->basedisp->isfp)
								memcpy(fp,op->basedisp->x.floatptr,12);
							else
								LongFloat(fp,op->basedisp->x.value);
							FloatPacked(pack,fp);
							memcpy(pcbuf+opcodesize,pack,12);
							opcodesize += 12;
						}
						break;

					default:						
					case TEXTENDED: {
							BYTE fp[12];
							if (op->basedisp->isfp)
								memcpy(fp,op->basedisp->x.floatptr,12);
							else
								LongFloat(fp,op->basedisp->x.value);
							memcpy(pcbuf+opcodesize,fp,12);
							opcodesize += 12;
						}
						break;
					case TSINGLE: {
							BYTE single[4];
							BYTE fp[12];
							if (op->basedisp->isfp)
								memcpy(fp,op->basedisp->x.floatptr,12);
							else
								LongFloat(fp,op->basedisp->x.value);
							FloatSingle(single,fp);
							memcpy(pcbuf+opcodesize,single,4);
							opcodesize += 4;
						}
						break;
					case TDOUBLE: {
							BYTE dbl[8];
							BYTE fp[12];
							if (op->basedisp->isfp)
								memcpy(fp,op->basedisp->x.floatptr,12);
							else
								LongFloat(fp,op->basedisp->x.value);
							FloatDouble(dbl,fp);
							memcpy(pcbuf+opcodesize,dbl,8);
							opcodesize += 8;
						}
						break;
					case TLONG: {
						long val= op->basedisp->x.value;
						if (op->basedisp->isfp) {
						  FloatLong(&val,op->basedisp->x.floatptr);
						}
						pcbuf[opcodesize] = val >> 24;
						pcbuf[opcodesize+1] = (val >> 16) & 0xff; 
						pcbuf[opcodesize+2] = (val >> 8) & 0xff; 
						pcbuf[opcodesize+3] = (val) & 0xff; 
						opcodesize += 4;
						}
						break;
					case TWORD: {
						long val= op->basedisp->x.value;
						if (op->basedisp->isfp) {
							FloatLong(&val,op->basedisp->x.floatptr);
						}
						pcbuf[opcodesize] = (val >> 8) & 0xff; 
						pcbuf[opcodesize+1] = (val) & 0xff; 
						opcodesize += 2;
						}
						break;
					case TBYTE: {
						long val= op->basedisp->x.value;
						if (op->basedisp->isfp) {
							FloatLong(&val,op->basedisp->x.floatptr);
						}
						pcbuf[opcodesize] = 0; 
						pcbuf[opcodesize+1] = val & 0xff; 
						opcodesize+=2;
						}
						break;
				}
			return(TRUE);
		default:
	 		return(ea_fill( op, 0, -1, pcallowed, anallowed, dnallowed,constallowed));
	}
}
void op_freg(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!dest) {
		missingop();
		return;
	}
	NoFloat();
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	opcodesize += 2;
	pcbuf[0] = 0xf0 + coprocid;
	pcbuf[1] = 0;
	if (source)
		if (source->type == TFREG)
			if (op->size != TEXTENDED && op->size)
				badsize();
			else {
				BadControl(source->reg);
				pcbuf[2] |= source->reg << 2;
			}
	  else
			floatea_fill(source, op->size, TRUE,FALSE,TRUE,TRUE);
	else
		pcbuf[2] |= dest->reg << 2;
	if (dest)
		if (dest->type != TFREG)
			NeedFP();
		else {
			BadControl(dest->reg);
			pcbuf[2] |= dest->reg >> 1;
			pcbuf[3] |= (dest->reg << 7) & 0x80;
		}
}
void op_fregd(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source) {
		missingop();
		return;
	}
	op_freg(op,source,dest);
}
void op_fregt(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source) {
		extraop();
		return;
	}
	if (!dest) {
		missingop();
		return;
	}
	NoFloat();
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	opcodesize += 2;
	pcbuf[0] = 0xf0 + coprocid;
	pcbuf[1] = 0;
		if (dest->type == TFREG)
			if (op->size != TEXTENDED && op->size)
				badsize();
			else {
				BadControl(dest->reg);
				pcbuf[2] |= dest->reg << 2;
			}
	  else
			floatea_fill(dest, op->size, TRUE,FALSE,TRUE,TRUE);
}
void op_fbcc(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  EXPRESSION offset = *dest->basedisp;
	pcbuf[0] |= 0xf0 | coprocid;
	pcbuf[1] |= 0x80;
	if (source) {
		extraop();
		return;
	}
	if (!dest) {
		missingop();
	}
	NoFloat();
	badfloat(op->size);
	if (!op->size)
		if (branchdefault == TBYTE)
			op->size = TWORD;
		else
			op->size = branchdefault;
	if (!offset.size)
		offset.size = op->size;
	if (!offset.size && (offset.isextern || offset.relmode || offset.section != sectionnum)) {
		if (prm_procrevision == 2)
			offset.size = TLONG;
		else
			offset.size = TWORD;
	}
	if (op->size == TLONG)
		proctype(2);
  if (dest->type != TADDR && dest->type != TCONST)
		illop();
	offset.x.value = 4;
	if (offset.isdef && !(offset.isextern || offset.relmode))
		offset.x.value = dest->basedisp->x.value-(org+2);
	if (iswordsigned(&offset)) {
		putword(&offset,TRUE);
	}
	else {
		pcbuf[1] |= 0x40;
		putdword(&offset,TRUE);
	}
}
void op_fdbcc(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest) 
{
  if (!source || !dest) {
		missingop();
		return;
	}
	NoFloat();
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	pcbuf[0] = 0xf0 | coprocid;
	pcbuf[1] = 0x48;
	opcodesize+=2;
	if (op->size && op->size != TWORD)
		badsize();
  if (source->type != TDREG || (dest->type != TADDR && dest->type != TCONST))
		illop();
	BadControl(source->reg);
	pcbuf[1] |= source->reg & 7;
	if (dest->basedisp->isdef)
		dest->basedisp->x.value = dest->basedisp->x.value - (org+2);
	else
		dest->basedisp->x.value = 0x02;
	if (!iswordsigned(dest->basedisp))
		Error("Branch param out of range");
  putword(dest->basedisp,TRUE);
}
void op_ftrapcc(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest) 
{
	proctype(2);
	if (source)
		extraop();
	badfloat(op->size);
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	opcodesize += 2;
	pcbuf[0] = 0xf0 + coprocid;
	pcbuf[1] = 0x78;
	
	if (dest) {
		if (op->size == TBYTE)
			badsize();
		if (op->size == TWORD) {
			putword(dest->basedisp,FALSE);
		  pcbuf[1] |= 2;
		}
		else {
			putdword(dest->basedisp,FALSE);
			pcbuf[1] |= 3;
		}
	}
	else
		pcbuf[1] |= 4;
}
void op_fsincos(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest, OPERANDDATA *extra) 
{
	if (!extra || !source || !dest) {
		missingop();
		return;
	}
	NoFloat();
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	opcodesize += 2;
	pcbuf[0] = 0xf0 + coprocid;
	pcbuf[1] = 0;
	if (source->type == TFREG)
		if (op->size && op->size != TEXTENDED)
			badsize();
		else {
			BadControl(source->reg);
			pcbuf[2] |= source->reg << 2;
		}
	else
		floatea_fill(source, op->size, TRUE,FALSE,TRUE,TRUE);
	if (dest->type != TFREG || extra->type != TFREG)
		NeedFP();
	else {
		BadControl(dest->reg);
		BadControl(extra->reg);
		pcbuf[2] |= extra->reg >> 1;
		pcbuf[3] |= ((extra->reg << 7) & 0x80) + dest->reg & 7;
	}

}
void op_fmovecr(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	if (op->size && op->size != TEXTENDED)
		badsize();
	if (source->type != TCONST || dest->type != TFREG)
		illop();
	if (source->basedisp->x.value & 0xffffff80L)
		illop();
	BadControl(dest->reg);
	pcbuf[0] |= coprocid;
	opcodesize += 2;
	pcbuf[2] = 0x5c + ((dest->reg & 7) >> 1);
	pcbuf[3] = ((dest->reg & 1 ) << 7) | source->basedisp->x.value;
}
void op_fmove(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest, OPERANDDATA *extraop)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	NoFloat();
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	if (extraop) {
		pcbuf[0] = 0xf0 + coprocid;
		pcbuf[1] = 0;
		if (source->type != TFREG || source->reg > 7 || (op->size != TPACKED && op->size)) 
			illop();
		op->size = TPACKED;
		if (extraop->type == TDREG) {
			putuword(0x7c00 | (extraop->reg<<4));
		}
		else
			if (extraop->type == TKFACT) {
				putuword(0x6c00 | (extraop->basedisp->x.value & 127));
			}
			else
				illop();
	}
	else {
		opcodesize += 2;
		pcbuf[0] = 0xf0 | coprocid;
		pcbuf[1] = 0;
	}
	
	if (source->type == TFREG) {
		if (source->reg > 7) {
			if (op->size && op->size != TLONG)
				badsize();
			pcbuf[2] |= 0xa0 | (source->reg >> 8);
			floatea_fill(dest,-1,FALSE,TRUE,TRUE,FALSE);
		}
		else {
			if (dest->type == TFREG) {
				if (op->size && op->size != TEXTENDED)
					badsize();
				pcbuf[2] |= (source->reg << 1) | (dest->reg >> 2);
				pcbuf[3] |= dest->reg << 6;
			}
			else {
				pcbuf[2] |= 0x60 | (source->reg >> 1);
				pcbuf[3] |= source->reg << 7;
				floatea_fill(dest,op->size,FALSE,FALSE,FALSE,FALSE);
			}
		}
	}
	else
		if (dest->type == TFREG) {
			if (dest->reg > 7) {
				if (op->size && op->size != TLONG)
					badsize();
				pcbuf[2] |= 0x80 | (dest->reg >> 8);
				floatea_fill(source,-1,TRUE,TRUE,TRUE,TRUE);
			}
			else {
				pcbuf[2] |= 0x40 | (dest->reg >> 1);
				pcbuf[3] |= dest->reg << 7;
				floatea_fill(source,op->size,TRUE,FALSE,TRUE,TRUE);
			}
		}
		else
			illop();
}
void op_fmovem(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	NoFloat();
	pcbuf[0] |= coprocid;
	if (op->size && op->size != TLONG && op->size != TEXTENDED)
		badsize();
	if (source->type == TFPREGLIST) {
		if (source->reg < 256) {
			int val = source->reg;
			if (op->size == TLONG)
				badsize();
			else {
				int mode = 0x1000;
				if (dest->type == TPOSTINC)
					illop();
				if (dest->type == TPREDEC) {
					unsigned temp = 0;
					int i;
					unsigned mask1 = 1;
					unsigned mask2 = 0x80;
					mode = 0;
					for (i=0; i < 8; i++) {
						if (source->reg & mask1)
							temp |= mask2;
						mask1 <<=1;
						mask2 >>=1;
					}
					val = temp;
				}
				putuword(val | 0xe000 | mode);
				floatea_fill(dest,-1,FALSE,FALSE,FALSE,FALSE);
			}
		}
		else {
			if (op->size == TEXTENDED)
				badsize();
			if (dest->type == TPOSTINC)
				illop();
			if (source->reg & 255)
				illop();
			putuword(source->reg | 0xa000);
			floatea_fill(dest,-1,FALSE,TRUE,TRUE,FALSE);
		}
	}
	else
		if (dest->type == TFPREGLIST) {
			if (dest->reg < 256) {
				if (op->size == TLONG)
					badsize();
				else {
					if (source->type == TPREDEC)
						illop();
					putuword(dest->reg | 0xd000);
					floatea_fill(source,-1,FALSE,FALSE,FALSE,FALSE);
				}
			}
			else {
				if (op->size == TEXTENDED)
					badsize();
				if (dest->reg & 255)
					illop();
				if (dest->type == TPREDEC)
					illop();
				putuword(dest->reg | 0x8000);
				floatea_fill(dest,-1,FALSE,TRUE,TRUE,FALSE);
			}
		}
		else
			if (source->type == TDREG) {
				int mode = 0x1800;
				if (op->size == TLONG)
					badsize();
				if (dest->type == TPOSTINC)
					illop();
				if (dest->type == TPREDEC)
					mode = 0x800;
				putuword(0xe000 + (source->reg<<4) + mode);
				floatea_fill(dest,-1,FALSE,FALSE,FALSE,FALSE);
			}
			else {
				int mode = 0x1800;
				if (dest->type == TDREG) {
					if (op->size == TLONG)
						badsize();
					if (source->type == TPREDEC)
						illop();
					putuword(0xc000 + (dest->reg<<4) + mode);
					floatea_fill(source,-1,TRUE,FALSE,FALSE,FALSE);
				}
				else
					illop();
			}	
}
void op_fnop(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source || dest)
		extraop();
	NoFloat();
	if (op->size)
		badsize();
	opcodesize+=2;
	pcbuf[2]=pcbuf[3]=0;
	pcbuf[0] |= coprocid;
}
void op_fsaverest(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (source)	
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	NoFloat();
	if (op->size)
		badsize();
	pcbuf[0] |= coprocid;
	if (pcbuf[1] & 0x40) {
		if (dest->type == TPREDEC)
			illop();
		floatea_fill(dest,-1,TRUE,FALSE,FALSE,FALSE);
	}
	else{
		if (dest->type == TPOSTINC)
			illop();
		floatea_fill(dest,-1,FALSE,FALSE,FALSE,FALSE);
	}
}
void op_fscc(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source) {
		extraop();
		return;
	}
	if (op->size && op->size != TBYTE)
		badsize();
	opcodesize+=2;
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	pcbuf[0] = 0xf0 | coprocid;
	pcbuf[1] = 0x40;
	floatea_fill(dest,-1, FALSE,FALSE,TRUE,FALSE);
}
void op_fdreg(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  proctype(4);
  op_freg(op, source,  dest);
}
void op_fsreg(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	proctype(4);
  op_freg(op, source,  dest);
}