#include <stdio.h>                     
#include <memory.h>
#include <string.h>
#include "utype.h"
#include "umem.h"
#include "as68k.h"
#include "asmcom.h"
#include "locgen.h"
#include "mmugen.h"

extern int pass;
extern HASHREC **hashtable;
extern FILE *listfile;
extern int level;
extern int lineno[];
extern int macrolevel;
extern int prm_procrevision;
extern BOOL ifskip;
extern uint allocsize;
extern int sectionnum;

extern int opcodesize;
extern BYTE pcbuf[BUFLEN];
extern long org;

void validmmu4()
{
	if (prm_procrevision != 4)
		proctype(100);
}
void validmmu3()
{
	if (prm_procrevision != 3)
		proctype(100);
}
void op_cinvpush(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	validmmu4();
	if (op->size)
		badsize();
	if (!source) {
		missingop();
		return;
	}
	if (source->type != TCACHE || (dest && ((pcbuf[1] & 0x18) == 0x18
				|| ((pcbuf[1] & 0x18) != 0x18 && dest->type != TINDIR))))
		illop();
	else {
		pcbuf[1] |= source->basedisp->x.value;
		if (dest) {
			if (dest->reg > 7)
				illop();
			pcbuf[1] |= dest->reg;
		}
	}
}
void op_pflush(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest, OPERANDDATA *extra)
{
	if (op->size)
		badsize();
	if (prm_procrevision == 3) {
		validmmu3();
		if ((pcbuf[0] & 0x07) == 0x05)
			illop();
		pcbuf[2] = 0x20;
		pcbuf[3] = 0;
		opcodesize+=2;
		if (pcbuf[1] & 1) {
/*			pflusha */
			if (dest || extra)
				illop();
			pcbuf[2]|=4;
			pcbuf[1] &= 0xc0;
		}
		else {
			if (!source || !dest || source->type != TCONST || dest->type != TCONST)
				illop();
			pcbuf[1] &= 0xc0;
			if (extra) {
				if (extra->type == TPREDEC || extra->type == TPOSTINC)
					illop();
				ea_fill(extra,op->size,-1,FALSE,FALSE,FALSE,FALSE);
				pcbuf[2] |= 8;
			}
			pcbuf[2] |= 0x10;
			pcbuf[3] |= (source->basedisp->x.value & 0x1f);
			pcbuf[3] |= (dest->basedisp->x.value & 7) << 5;
		}
	}
	else 
		if (prm_procrevision == 4) {
			validmmu4();
			if (dest || extra)
				illop();
			if (source) {
				if (pcbuf[1] & 1)
					extraop();
				if (source->type != TINDIR || source->reg > 7)
					illop();
				pcbuf[1] &= 0xf8;
				pcbuf[1] |= source->reg & 7;
			}
			else {
				if (!(pcbuf[1] & 1))
					illop();
				pcbuf[1] &= 0xf8;
			}
			pcbuf[0] |= 0x05;

		}
		else
			invproc();
}
void op_pload(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (prm_procrevision != 3)
		invproc();
	validmmu3();
	if (op->size)
		badsize();
	if (!source || !dest) {
		missingop();
		return;
	}
	if (source->type != TCONST || dest->type == TPREDEC || dest->type == TPOSTINC)
		illop();
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	pcbuf[0] = 0xf0;
	pcbuf[1] = 0;
	opcodesize+=2;
	
	pcbuf[3] |= source->basedisp->x.value & 0x1f;
	ea_fill(dest,op->size,-1,FALSE,FALSE,FALSE,FALSE);
}
void op_pmove(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (prm_procrevision != 3)
		invproc();
	validmmu3();
	if (op->size)
		badsize();
	if (!source || !dest) {
		missingop();
		return;
	}
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	pcbuf[0] = 0xf0;
	pcbuf[1] = 0;
	opcodesize+=2;
	if (source->type == TMMUREG) {
		pcbuf[2] |= source->reg >>8;
		pcbuf[3] |= source->reg &0xff;
		if (pcbuf[2] & 1)
			illop();
		pcbuf[2] |= 2;
		if (dest->type == TPREDEC || dest->type == TPOSTINC)
			illop();
		ea_fill(dest,op->size,-1,FALSE,FALSE,FALSE,FALSE);
	}
	else {
		if (dest->type == TMMUREG) {
			if (dest->reg == XMMUREG)
				if (pcbuf[2] & 1)
					illop();
			pcbuf[2] |= dest->reg >>8;
			pcbuf[3] |= dest->reg &0xff;
			if (source->type == TPREDEC || source->type == TPOSTINC)
				illop();
			ea_fill(source,op->size,-1,FALSE,FALSE,FALSE,FALSE);
		}
		else
			illop();
	}
}
void op_ptest(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest, OPERANDDATA *extra)
{
	if (prm_procrevision == 3) {
		if (!source || !dest || !extraop) {
			missingop();
			return;
		}
		validmmu3();
		pcbuf[2] = pcbuf[0];
		pcbuf[3] = pcbuf[1];
		pcbuf[0] = 0xf0;
		pcbuf[1] = 0;
		if (source->type != TCONST || dest->type == TPREDEC || dest->type == TPOSTINC
					|| extra->type != TPTEST)
			illop();
		opcodesize+=2;
		ea_fill(dest,0,-1,FALSE,FALSE,FALSE,FALSE);
		pcbuf[2] |= extra->basedisp->x.value >> 8;
		pcbuf[3] |= extra->basedisp->x.value & 0xe0;
		pcbuf[3] |= source->basedisp->x.value & 0x1f;
	}
	else
		if (prm_procrevision == 4) {
			if (dest || extra)
				extraop();
			if (!source) {
				missingop();
				return;
			}
			validmmu4();
			if (source->type != TINDIR || source->reg > 7)
				illop();
			pcbuf[1] = ((pcbuf[0] & 0x2)<<4) | 0x48 | (source->reg & 7);
			pcbuf[0] = 0xf5;
		}
		else
			invproc();
}