#include <stdio.h>       
#include <ctype.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include "cmdline.h"
#include "umem.h"
#include "asmcom.h"
#include "as68k.h"
#include "yacc_tab.h"
#include "locgen.h"
#include "locexpr.h"
#include "interp.h"
extern FILE *listfile;
extern int pass;
extern int opcodesize;
extern LIST *undeflist;
extern long org;
extern int macrolevel;
extern int sectionnum;
extern char *prm_includepath;
extern int ifskip;
extern BOOL prm_case_sensitive;
extern PHITEXT macrophiparms, phiparms;
extern int currentphifg;
extern BOOL putback;
extern int repeat;
extern BOOL phiused;

extern int level;
extern HASHREC **hashtable;
extern char buf[BUFLEN];
extern char *bufptr;
extern char *macroptr;
extern BOOL firstsymbol;
extern BOOL newline;
extern BOOL loadsdata;

static BOOL ininclude;

OPCODEDATA dispatchtable[] = {
	{ "!=",		CONTROL | FUNC,  NE, 0, 0},
	{ "#INCLUDE", CONTROL | FUNC, INCLUDE, 0, 0},
	{ "&&",		CONTROL | FUNC,  LOGAND, 0, 0},
	{ ".ALIGN", CONTROL | FUNC , ALIGN, 0, 0},
	{ ".EJECT", CONTROL | FUNC,		PAGEBREAK, 0, 0},
	{ ".ELSE", CONTROL | FUNC, ELSE, 0, 0},
	{ ".ELIF", CONTROL | FUNC, ELSEIF, 0, 0},
	{ ".ENDIF", CONTROL | FUNC, ENDIF, 0, 0},
	{ ".ENDSTRUCT", CONTROL | FUNC,		ENDSTRUCT, 0, 0},
	{ ".ENTRY", CONTROL | FUNC, PUBLICX, 0, 0},
	{ ".EXPORT", CONTROL | FUNC, PUBLICX, 0, 0},
	{ ".EXTERN", CONTROL | FUNC, EXTERNAL, 0, 0},
	{ ".IF", CONTROL | ISIF, IF_NE, 0, 0},
	{ ".IMPORT", CONTROL | FUNC, EXTERNAL, 0, 0},
  { ".MODE", CONTROL | FUNC, MODE, 0, 0 },
	{ ".MSG",  CONTROL | FUNC, MSG, 0, 0 },
	{ ".NOFIX", CONTROL | FUNC, NOFIX, 0, 0 },
	{ ".OPTION", CONTROL | FUNC, OPTEQU, 0, 0},
	{ ".REGION", CONTROL | FUNC,		SECTION, 0, 0},
	{ ".SPACE",		CONTROL | FUNC, LINES, 0, 0},
	{ ".STRUCT", CONTROL | FUNC,		STRUCT, 0, 0},
  { "<<", CONTROL | FUNC, SHLEFT, 0, 0 },
  { "<=", CONTROL | FUNC, LE, 0, 0 },
  { "==", CONTROL | FUNC, EQ, 0, 0 },
  { ">=", CONTROL | FUNC, GE, 0, 0 },
  { ">>", CONTROL | FUNC, SHRIGHT, 0, 0 },
	{ "A",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
/*	{ "CL",	CONTROL | ISOPT, OPTCL, 0, 0 }, */
	{ "CRE",	CONTROL | ISOPT, OPTCRE, 0, 0 },
	{ "D",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "ELSE", CONTROL | FUNC, ELSE, 0, 0},
	{ "ELIF", CONTROL | FUNC, ELSEIF, 0, 0},
	{ "ENDIF", CONTROL | FUNC, ENDIF, 0, 0},
	{ "END",	CONTROL | FUNC, END , 0, 0},
	{ "ENDM", CONTROL | FUNC,		MACEXIT, 0, 0},
	{ "ENDC", CONTROL | FUNC, ENDIF, 0, 0},
  { "EQU",		CONTROL | FUNC, EQU, 0, 0},
	{ "FAIL", CONTROL | FUNC,		FAIL, 0, 0},
	{ "FRL",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "FRS",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
  { "IC",   CONTROL | DATA, IC, 0, 0},
	{ "IDNT", CONTROL | FUNC,		IGNORE, 0, 0},
	{ "IF", CONTROL | ISIF, IF_NE, 0, 0},
	{ "IFNB", CONTROL | ISIF2, IF_NB, 0, 0},
	{ "IFB", CONTROL | ISIF2, IF_B, 0, 0},
	{ "IFNDEF", CONTROL | ISIF2, IF_NDEF, 0, 0},
	{ "IFDEF", CONTROL | ISIF2, IF_DEF, 0, 0},
	{ "IFIDN", CONTROL | ISIF2, IF_IDN, 0, 0},
	{ "IFIDNI", CONTROL | ISIF2, IF_IDNI, 0, 0},
	{ "IFDIF", CONTROL | ISIF2, IF_DIF, 0, 0},
	{ "IFDIFI", CONTROL | ISIF2, IF_DIFI, 0, 0},
	{ "IFC", CONTROL | ISIF, IF_C, 0, 0},
	{ "IFEQ", CONTROL | ISIF, IF_EQ, 0, 0},
	{ "IFGE", CONTROL | ISIF, IF_GE, 0, 0},
	{ "IFGT", CONTROL | ISIF, IF_GT, 0, 0},
	{ "IFLE", CONTROL | ISIF, IF_LE, 0, 0},
	{ "IFLT", CONTROL | ISIF, IF_LT, 0, 0},
	{ "IFNC", CONTROL | ISIF, IF_NC, 0, 0},
	{ "IFNE", CONTROL | ISIF, IF_NE, 0, 0},
	{ "IFSTYLE",	CONTROL | ISOPTEQU, OPTEQUIFSTYLE, 0, 0 },
	{ "INCLUDE", CONTROL | FUNC, INCLUDE, 0, 0},
	{ "INFO",	CONTROL | ISOPTEQU, OPTEQUINFO, 0, 0 },
	{ "LIST", CONTROL | FUNC,	LISTON, 0, 0},
	{ "LLEN", CONTROL | FUNC,		IGNORE, 0, 0},
	{ "MACRO", CONTROL | FUNC, MACRO, 0, 0 },
	{ "MACSTYLE",	CONTROL | ISOPTEQU, OPTEQUMACSTYLE, 0, 0 },
	{ "MC",	CONTROL | ISOPT, OPTMC, 0, 0 },
	{ "MD",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "MEX",	CONTROL | ISOPT, OPTMEX, 0, 0 },
	{ "MEXIT", CONTROL | FUNC,		MACEXIT, 0, 0},
	{ "NOA",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOCEX",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOCL",	CONTROL | ISOPT, OPTNOCL, 0, 0 },
	{ "NOEQU",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOFORMAT", CONTROL | FUNC,		IGNORE, 0, 0},
	{ "NOL", CONTROL | FUNC,	LISTOFF, 0, 0},
	{ "NOLIST", CONTROL | FUNC,	LISTOFF, 0, 0},
	{ "NOMC",	CONTROL | ISOPT, OPTNOMC, 0, 0 },
	{ "NOMD",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOMEX",	CONTROL | ISOPT, OPTNOMEX, 0, 0 },
	{ "NOO",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOOLD",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOPCO",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOPAGE", CONTROL | FUNC,		PAGEOFF, 0, 0},
	{ "NOPCS",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "NOT", OP_NEG,				0x4600, 0, 0},
	{ "O",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "OFFSET", CONTROL | FUNC, ORG, 0, 0},
	{ "OLD",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "OPT", CONTROL | FUNC, OPT, 0, 0},
	{ "P",	CONTROL | ISOPT, OPTP, 0, 0 },
	{ "PAGE", CONTROL | FUNC,		PAGEON, 0, 0},
	{ "PCO",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "PCS",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "REG", CONTROL | FUNC,		MREG, 0, 0},
	{ "SECTION", CONTROL | FUNC,		SECTION, 0, 0},
  { "SET",		CONTROL | FUNC, SET, 0, 0},
	{ "SIZEOF", CONTROL | FUNC, SIZEOF, 0, 0},
	{ "SPC",		CONTROL | FUNC, LINES, 0, 0},
	{ "SUBTITLE", CONTROL | ISOPTEQU, OPTEQUSUBTTL, 0, 0},
	{ "SUBTTL", CONTROL | FUNC, SUBTTL, 0, 0},
	{ "TARGET",	CONTROL | ISOPTEQU, OPTEQUTARGET, 0, 0 },
	{ "WARN",	CONTROL | ISOPTEQU, OPTEQUWARN, 0, 0 },
	{ "XDEF", CONTROL | FUNC, PUBLICX, 0, 0},
	{ "XREF", CONTROL | FUNC, EXTERNAL, 0, 0},
	{ "||",		CONTROL | FUNC,  LOGOR, 0, 0},
	{ "\x94T\x90Text", CONTROL | FUNC, PHITEXTSTREAM, 0, 0},
	{ "*1",		CONTROL | SCALETYPE, 0, 0, 0},
	{ "*2",		CONTROL | SCALETYPE, 1, 0, 0},
	{ "*4",		CONTROL | SCALETYPE, 2, 0, 0},
	{ "*8",		CONTROL | SCALETYPE, 3, 0 ,0},
	{ ".B",		CONTROL | TYPETYPE,  TBYTE, 0, 0},
  { ".D",   CONTROL | TYPETYPE,  TDOUBLE, 0, 0},
  { ".L",   CONTROL | TYPETYPE,  TLONG, 0, 0},
  { ".P",   CONTROL | TYPETYPE,  TPACKED, 0, 0},
  { ".S",   CONTROL | TYPETYPE,  TSINGLE, 0, 0},
  { ".W",   CONTROL | TYPETYPE,  TWORD, 0, 0},
  { ".X",   CONTROL | TYPETYPE,  TEXTENDED, 0, 0},
	{ "A0",		CONTROL | AREG, 0, 0, 0},
	{ "A1",		CONTROL | AREG, 1, 0, 0},
	{ "A2",		CONTROL | AREG, 2, 0, 0},
	{ "A3",		CONTROL | AREG, 3, 0, 0},
	{ "A4",		CONTROL | AREG, 4, 0, 0},
	{ "A5",		CONTROL | AREG, 5, 0, 0},
	{ "A6",		CONTROL | AREG, 6, 0, 0},
	{ "A7",		CONTROL | AREG, 7, 0, 0},
	{ "ABCD", OP_DECIMAL, 0xc100, 0, 0},
	{ "ADD",  OP_ADDGENERIC,  0xd000, 0, 0},
	{ "ADDA", OP_AADDSUB,  0xd0c0, 0, 0},
	{ "ADDI", OP_IADDSUB,  0x0600, 0, 0},
	{ "ADDQ", OP_QADDSUB,  0x5000, 0, 0},
	{ "ADDX", OP_XADDSUB,  0xd100, 0, 0},
	{ "AND",  OP_ANDGENERIC,  0xc000, 0, 0},
	{ "ANDI", OP_LOGIMM,   0x0200, 0, 0},
	{ "ASL",  OP_SHIFT,    0xe100 , 0xe1c0, 0},
	{ "ASR",  OP_SHIFT,		 0xe000 , 0xe0c0, 0},
	{ "BCC",	OP_BRANCH,   0x6400, 0, 0},
	{ "BCHG", OP_BIT,			 0x0040, 0, 0},
	{ "BCLR", OP_BIT,			 0x0080, 0, 0},
	{ "BCS",	OP_BRANCH,   0x6500, 0, 0},
	{ "BEQ",	OP_BRANCH,   0x6700, 0, 0},
	{ "BFCHG",OP_BITFIELD, 0xeac0, 0, 0},
	{ "BFCLR",OP_BITFIELD, 0xecc0, 0, 0},
	{ "BFEXTS",OP_BITFIELDRET, 0xebc0, 0, 0},
	{ "BFEXTU",OP_BITFIELDRET, 0xe9c0, 0, 0},
	{ "BFFFO",OP_BITFIELDRET, 0xedc0, 0, 0},
	{ "BFINS",OP_BITFIELDGET, 0xefc0, 0, 0},
	{ "BFSET",OP_BITFIELD, 0xeec0, 0, 0},
	{ "BFTST",OP_BITFIELD, 0xe8c0, 0, 0},
	{ "BGE",	OP_BRANCH,   0x6c00, 0, 0},
	{ "BGND", OP_1WORD,  0x4afa, 0, 0},
	{ "BGT",	OP_BRANCH,   0x6e00, 0, 0},
	{ "BHI",	OP_BRANCH,   0x6200, 0, 0},
	{ "BHS",	OP_BRANCH,   0x6400, 0, 0},
	{ "BKPT", OP_BKPT,		 0x4848, 0, 0},
	{ "BLE",	OP_BRANCH,   0x6f00, 0, 0},
	{ "BLO",	OP_BRANCH,   0x6500, 0, 0},
	{ "BLS",	OP_BRANCH,   0x6300, 0, 0},
	{ "BLT",	OP_BRANCH,   0x6d00, 0, 0},
	{ "BMI",	OP_BRANCH,   0x6b00, 0, 0},
	{ "BNE",	OP_BRANCH,   0x6600, 0, 0},
	{ "BPL",	OP_BRANCH,   0x6a00, 0, 0},
	{ "BRA",	OP_BRANCH,   0x6000, 0, 0},
	{ "BRB",	CONTROL | ISOPT, OPTBRB, 0, 0 },
	{ "BRL",	CONTROL | ISOPT, OPTBRL, 0, 0 },
	{ "BRW",	CONTROL | ISOPT, OPTBRW, 0, 0 },
	{ "BRS",	CONTROL | ISOPT, OPTBRS, 0, 0 },
	{ "BSET", OP_BIT,			 0x00c0, 0, 0},
	{ "BSR",	OP_BRANCH,   0x6100, 0, 0},
	{ "BTST", OP_BIT,			 0x0000, 0, 0},
	{ "BVC",	OP_BRANCH,   0x6800, 0, 0},
	{ "BVS",	OP_BRANCH,   0x6900, 0, 0},  
	{ "CAAR",  CONTROL | AREG, CAARREG, 0, 0 },
	{ "CACR",  CONTROL | AREG, CACRREG, 0, 0 },
	{ "CALLM", OP_CALLM,   0x06c0, 0, 0},
	{ "CAS",  OP_CAS,      0x08c0, 0, 0},
  { "CAS2", OP_CAS2,		 0x0cfc, 0, 0},
	{ "CCR",  CONTROL | AREG, CCRREG, 0, 0 },
	{ "CEX",	CONTROL | ISOPT, OPTIGNORE, 0, 0 },
	{ "CHK",	OP_CHK,			 0x4100, 0, 0},
	{ "CHK2", OP_CHK2,		 0x00c0, 0, 0},
  { "CINVA", OP_CINVPUSH, 0xf418,0,0},
  { "CINVL", OP_CINVPUSH, 0xf408,0,0},
  { "CINVP", OP_CINVPUSH, 0xf410,0,0},
	{ "CLR",	OP_CLEAR,		 0x4200, 0, 0},
	{ "CMP",  OP_CMP,   0xb000, 0, 0},
	{ "CMP2", OP_CMP2,		 0x00c0, 0, 0},
	{ "CMPA", OP_AADDSUB,  0xb0c0, 0, 0},
	{ "CMPI", OP_ICMP,		 0x0c00, 0, 0},
	{ "CMPM", OP_CMPM,		 0xb108, 0, 0},
  { "CPUSHA", OP_CINVPUSH, 0xf438,0,0},
  { "CPUSHL", OP_CINVPUSH, 0xf428,0,0},
  { "CPUSHP", OP_CINVPUSH, 0xf430,0,0},
  { "CRP", CONTROL | MMUREG, CRPREG, 0, 0 },
	{ "D0",		CONTROL | DREG, 0, 0, 0},
	{ "D1",		CONTROL | DREG, 1, 0, 0},
	{ "D2",		CONTROL | DREG, 2, 0, 0},
	{ "D3",		CONTROL | DREG, 3, 0, 0},
	{ "D4",		CONTROL | DREG, 4, 0, 0},
	{ "D5",		CONTROL | DREG, 5, 0, 0},
	{ "D6",		CONTROL | DREG, 6, 0, 0},
	{ "D7",		CONTROL | DREG, 7, 0, 0},
	{ "DBCC",	OP_DBRANCH,   0x54c8, 0, 0},
	{ "DBCS",	OP_DBRANCH,   0x55c8, 0, 0},
	{ "DBEQ",	OP_DBRANCH,   0x57c8, 0, 0},
	{ "DBF",	OP_DBRANCH,   0x51c8, 0, 0},
	{ "DBGE",	OP_DBRANCH,   0x5cc8, 0, 0},
	{ "DBGT",	OP_DBRANCH,   0x5ec8, 0, 0},
	{ "DBHI",	OP_DBRANCH,   0x52c8, 0, 0},
	{ "DBHS",	OP_DBRANCH,   0x54c8, 0, 0},
	{ "DBLE",	OP_DBRANCH,   0x5fc8, 0, 0},
	{ "DBLO",	OP_DBRANCH,   0x55c8, 0, 0},
	{ "DBLS",	OP_DBRANCH,   0x53c8, 0, 0},
	{ "DBLT",	OP_DBRANCH,   0x5dc8, 0, 0},
	{ "DBMI",	OP_DBRANCH,   0x5bc8, 0, 0},
	{ "DBNE",	OP_DBRANCH,   0x56c8, 0, 0},
	{ "DBPL",	OP_DBRANCH,   0x5ac8, 0, 0},
	{ "DBRA",	OP_DBRANCH,   0x51c8, 0, 0},
	{ "DBT",	OP_DBRANCH,   0x50c8, 0, 0},
	{ "DBVC",	OP_DBRANCH,   0x58c8, 0, 0},
	{ "DBVS",	OP_DBRANCH,   0x59c8, 0, 0},
  { "DC",		CONTROL | DATA, DC, 0, 0},
  { "DCB",		CONTROL | DATA, DCB, 0, 0},
	{ "DFC",  CONTROL | AREG, DFCREG, 0, 0 },
	{ "DIVS", OP_MULDIV,		0x81c0, 0x4c40, 0},
	{ "DIVSL",OP_MULDIVL,		0x4c40,0, 0},
	{ "DIVU", OP_MULDIVU,		0x80c0, 0x4c40, 0},
	{ "DIVUL",OP_MULDIVUL,	0x4c40,0, 0},
  { "DS"	 ,CONTROL | DATA, DS, 0, 0},
	{ "EOR",  OP_EOR,  0xb000, 0, 0},
	{ "EORI", OP_LOGIMM,   0x0a00, 0, 0},
	{ "EXG",	OP_EXG,				0xc100, 0, 0},
	{ "EXT",  OP_EXT,				0x4800, 0, 0},
	{ "EXTB", OP_EXT,				0x4800, 0, 0},
	{ "FABS", OP_FREG, 0x18, 0, 0},
	{ "FACOS", OP_FREG, 0x1C, 0, 0},
	{ "FADD", OP_FREGD, 0x22, 0, 0},
	{ "FASIN", OP_FREG, 0x0C, 0, 0},
	{ "FATAN", OP_FREG, 0x0a, 0, 0},
	{ "FATANH", OP_FREG, 0x0d, 0, 0},
	{ "FBEQ", OP_FBCC, 1, 0, 0},
	{ "FBF", OP_FBCC, 0x00, 0, 0},
	{ "FBGE", OP_FBCC, 0x13, 0, 0},
	{ "FBGL", OP_FBCC, 0x16, 0, 0},
	{ "FBGLE", OP_FBCC, 0x17, 0, 0},
	{ "FBGT", OP_FBCC, 0x12, 0, 0},
	{ "FBLE", OP_FBCC, 0x15, 0, 0},
	{ "FBLT", OP_FBCC, 0x14, 0, 0},
	{ "FBNE", OP_FBCC, 0x0e, 0, 0},
	{ "FBNGE", OP_FBCC, 0x1c, 0, 0},
	{ "FBNGL", OP_FBCC, 0x19, 0, 0},
	{ "FBNGT", OP_FBCC, 0x1d, 0, 0},
	{ "FBNLE", OP_FBCC, 0x1a, 0, 0},
	{ "FBNLT", OP_FBCC, 0x1b, 0, 0},
	{ "FBNGLE", OP_FBCC, 0x18, 0, 0},
	{ "FBOGE", OP_FBCC, 0x03, 0, 0},
	{ "FBOGL", OP_FBCC, 0x06, 0, 0},
	{ "FBOGT", OP_FBCC, 0x02, 0, 0},
	{ "FBOR", OP_FBCC, 0x07, 0, 0},
	{ "FBOLE", OP_FBCC, 0x05, 0, 0},
	{ "FBOLT", OP_FBCC, 0x04, 0, 0},
	{ "FBSEQ", OP_FBCC, 0x11, 0, 0},
	{ "FBSF", OP_FBCC, 0x10, 0, 0},
	{ "FBSNE", OP_FBCC, 0x1e, 0, 0},
	{ "FBST", OP_FBCC, 0x1f, 0, 0},
	{ "FBT", OP_FBCC, 0x0f, 0, 0},
	{ "FBUGE", OP_FBCC, 0x0b, 0, 0},
	{ "FBUGT", OP_FBCC, 0x0a, 0, 0},
	{ "FBULE", OP_FBCC, 0x0d, 0, 0},
	{ "FBULT", OP_FBCC, 0x0c, 0, 0},
	{ "FBUEQ", OP_FBCC, 0x09, 0, 0},
	{ "FBUN", OP_FBCC, 0x08, 0, 0},
	{ "FCMP", OP_FREGD, 0x38, 0, 0},
	{ "FCOS", OP_FREG, 0x1d, 0, 0},
	{ "FCOSH", OP_FREG, 0x19, 0, 0},
	{ "FDABS", OP_FREG, 0x5c, 0, 0},
	{ "FDADD", OP_FREG, 0x66, 0, 0},
	{ "FDBEQ", OP_FDBCC, 1, 0, 0},
	{ "FDBF", OP_FDBCC, 0x00, 0, 0},
	{ "FDBGE", OP_FDBCC, 0x13, 0, 0},
	{ "FDBGL", OP_FDBCC, 0x16, 0, 0},
	{ "FDBGLE", OP_FDBCC, 0x17, 0, 0},
	{ "FDBGT", OP_FDBCC, 0x12, 0, 0},
	{ "FDBLE", OP_FDBCC, 0x15, 0, 0},
	{ "FDBLT", OP_FDBCC, 0x14, 0, 0},
	{ "FDBNE", OP_FDBCC, 0x0e, 0, 0},
	{ "FDBNGE", OP_FDBCC, 0x1c, 0, 0},
	{ "FDBNGL", OP_FDBCC, 0x19, 0, 0},
	{ "FDBNGT", OP_FDBCC, 0x1d, 0, 0},
	{ "FDBNLE", OP_FDBCC, 0x1a, 0, 0},
	{ "FDBNLT", OP_FDBCC, 0x1b, 0, 0},
	{ "FDBNGLE", OP_FDBCC, 0x18, 0, 0},
	{ "FDBOGE", OP_FDBCC, 0x03, 0, 0},
	{ "FDBOGL", OP_FDBCC, 0x06, 0, 0},
	{ "FDBOGT", OP_FDBCC, 0x02, 0, 0},
	{ "FDBOR", OP_FDBCC, 0x07, 0, 0},
	{ "FDBOLE", OP_FDBCC, 0x05, 0, 0},
	{ "FDBOLT", OP_FDBCC, 0x04, 0, 0},
	{ "FDBSEQ", OP_FDBCC, 0x11, 0, 0},
	{ "FDBSF", OP_FDBCC, 0x10, 0, 0},
	{ "FDBSNE", OP_FDBCC, 0x1e, 0, 0},
	{ "FDBST", OP_FDBCC, 0x1f, 0, 0},
	{ "FDBT", OP_FDBCC, 0x0f, 0, 0},
	{ "FDBUGE", OP_FDBCC, 0x0b, 0, 0},
	{ "FDBUGT", OP_FDBCC, 0x0a, 0, 0},
	{ "FDBULE", OP_FDBCC, 0x0d, 0, 0},
	{ "FDBULT", OP_FDBCC, 0x0c, 0, 0},
	{ "FDBUEQ", OP_FDBCC, 0x09, 0, 0},
	{ "FDBUN", OP_FDBCC, 0x08, 0, 0},
	{ "FDIV", OP_FREGD, 0x20, 0, 0},
	{ "FDDIV", OP_FDREG, 0x64, 0, 0},
	{ "FDMOVE", OP_FDREG, 0x44, 0, 0},
	{ "FDMUL", OP_FDREG, 0x67, 0, 0},
	{ "FDNEG", OP_FDREG, 0x5e, 0, 0},
	{ "FDSQRT", OP_FDREG, 0x45, 0, 0},
	{ "FDSUB", OP_FDREG, 0x6c, 0, 0},
	{ "FETOX", OP_FREG, 0x10, 0, 0},
	{ "FETOXM1", OP_FREG, 0x08, 0, 0},
	{ "FGETEXP", OP_FREG, 0x1e, 0, 0},
	{ "FGETMAN", OP_FREG, 0x1f, 0, 0},
	{ "FINT", OP_FREG, 0x01, 0, 0},
	{ "FINTRZ", OP_FREG, 0x03, 0, 0},
	{ "FLOG10", OP_FREG, 0x15, 0, 0},
	{ "FLOG2", OP_FREG, 0x16, 0, 0},
	{ "FLOGN", OP_FREG, 0x14, 0, 0},
	{ "FLOGNP1", OP_FREG, 0x06, 0, 0},
	{ "FMOD", OP_FREGD, 0x21, 0, 0},
	{ "FMOVE", OP_FMOVE, 0x0, 0, 0},
	{ "FMOVECR", OP_FMOVECR, 0xf000, 0, 0},
	{ "FMOVEM", OP_FMOVEM, 0xf000, 0, 0},
	{ "FMUL", OP_FREGD, 0x23, 0, 0},
	{ "FNEG", OP_FREG, 0x1a, 0, 0},
	{ "FNOP", OP_FNOP, 0xf040, 0, 0},
	{ "FOPT", CONTROL | FUNC, FOPT, 0, 0},
	{ "FORMAT", CONTROL | FUNC,		IGNORE, 0, 0},
	{ "FP0",		CONTROL | FREG, 0, 0, 0},
	{ "FP1",		CONTROL | FREG, 1, 0, 0},
	{ "FP2",		CONTROL | FREG, 2, 0, 0},
	{ "FP3",		CONTROL | FREG, 3, 0, 0},
	{ "FP4",		CONTROL | FREG, 4, 0, 0},
	{ "FP5",		CONTROL | FREG, 5, 0, 0},
	{ "FP6",		CONTROL | FREG, 6, 0, 0},
	{ "FP7",		CONTROL | FREG, 7, 0, 0},
	{ "FPCR",	CONTROL | FREG, FPCR, 0, 0},
	{ "FPIAR",	CONTROL | FREG, FPIAR, 0, 0},
	{ "FPSR",	CONTROL | FREG, FPSR, 0, 0},
	{ "FREM", OP_FREG, 0x25, 0, 0},
	{ "FRESTORE", OP_FSAVEREST, 0xf140, 0, 0},
	{ "FSAVE", OP_FSAVEREST, 0xf100, 0, 0},
	{ "FSABS", OP_FSREG, 0x58, 0, 0},
	{ "FSADD", OP_FSREG, 0x62, 0, 0},
	{ "FSAVE", OP_FSAVEREST, 0xf100, 0, 0},
	{ "FSCALE", OP_FREG, 0x26, 0, 0},
	{ "FSDIV", OP_FSREG, 0x60, 0, 0},
	{ "FSEQ", OP_FSCC, 1, 0, 0},
	{ "FSF", OP_FSCC, 0x00, 0, 0},
	{ "FSGE", OP_FSCC, 0x13, 0, 0},
	{ "FSGL", OP_FSCC, 0x16, 0, 0},
	{ "FSGLDIV", OP_FREG, 0x24, 0, 0},
	{ "FSGLE", OP_FSCC, 0x17, 0, 0},
	{ "FSGLMUL", OP_FREG, 0x27, 0, 0},
	{ "FSGT", OP_FSCC, 0x12, 0, 0},
	{ "FSIN", OP_FREG, 0x0e, 0, 0},
	{ "FSINCOS", OP_FSINCOS, 0x30, 0, 0},
	{ "FSINH", OP_FREG, 0x02, 0, 0},
	{ "FSLE", OP_FSCC, 0x15, 0, 0},
	{ "FSLT", OP_FSCC, 0x14, 0, 0},
	{ "FSMOVE", OP_FSREG, 0x40, 0, 0},
	{ "FSMUL", OP_FSREG, 0x63, 0, 0},
	{ "FSNE", OP_FSCC, 0x0e, 0, 0},
	{ "FSNEG", OP_FSREG, 0x5a, 0, 0},
	{ "FSNGE", OP_FSCC, 0x1c, 0, 0},
	{ "FSNGL", OP_FSCC, 0x19, 0, 0},
	{ "FSNGT", OP_FSCC, 0x1d, 0, 0},
	{ "FSNLE", OP_FSCC, 0x1a, 0, 0},
	{ "FSNLT", OP_FSCC, 0x1b, 0, 0},
	{ "FSNGLE", OP_FSCC, 0x18, 0, 0},
	{ "FSOGE", OP_FSCC, 0x03, 0, 0},
	{ "FSOGL", OP_FSCC, 0x06, 0, 0},
	{ "FSOGT", OP_FSCC, 0x02, 0, 0},
	{ "FSOR", OP_FSCC, 0x07, 0, 0},
	{ "FSOLE", OP_FSCC, 0x05, 0, 0},
	{ "FSOLT", OP_FSCC, 0x04, 0, 0},
	{ "FSQRT", OP_FREG, 0x04, 0, 0},
	{ "FSSQRT", OP_FSREG, 0x41, 0, 0},
	{ "FSSEQ", OP_FSCC, 0x11, 0, 0},
	{ "FSSF", OP_FSCC, 0x10, 0, 0},
	{ "FSSNE", OP_FSCC, 0x1e, 0, 0},
	{ "FSST", OP_FSCC, 0x1f, 0, 0},
	{ "FSSUB", OP_FSREG, 0x68, 0, 0},
	{ "FST", OP_FSCC, 0x0f, 0, 0},
	{ "FSUB", OP_FREGD, 0x28, 0, 0},
	{ "FSUGE", OP_FSCC, 0x0b, 0, 0},
	{ "FSUGT", OP_FSCC, 0x0a, 0, 0},
	{ "FSULE", OP_FSCC, 0x0d, 0, 0},
	{ "FSULT", OP_FSCC, 0x0c, 0, 0},
	{ "FSUEQ", OP_FSCC, 0x09, 0, 0},
	{ "FSUN", OP_FSCC, 0x08, 0, 0},
	{ "FTAN", OP_FREG, 0x0f, 0, 0},
	{ "FTANH", OP_FREG, 0x09, 0, 0},
	{ "FTENTOX", OP_FREG, 0x12, 0, 0},
	{ "FTRAPEQ", OP_FTRAPCC, 1, 0, 0},
	{ "FTRAPF", OP_FTRAPCC, 0x00, 0, 0},
	{ "FTRAPGE", OP_FTRAPCC, 0x13, 0, 0},
	{ "FTRAPGL", OP_FTRAPCC, 0x16, 0, 0},
	{ "FTRAPGLE", OP_FTRAPCC, 0x17, 0, 0},
	{ "FTRAPGT", OP_FTRAPCC, 0x12, 0, 0},
	{ "FTRAPLE", OP_FTRAPCC, 0x15, 0, 0},
	{ "FTRAPLT", OP_FTRAPCC, 0x14, 0, 0},
	{ "FTRAPNE", OP_FTRAPCC, 0x0e, 0, 0},
	{ "FTRAPNGE", OP_FTRAPCC, 0x1c, 0, 0},
	{ "FTRAPNGL", OP_FTRAPCC, 0x19, 0, 0},
	{ "FTRAPNGT", OP_FTRAPCC, 0x1d, 0, 0},
	{ "FTRAPNLE", OP_FTRAPCC, 0x1a, 0, 0},
	{ "FTRAPNLT", OP_FTRAPCC, 0x1b, 0, 0},
	{ "FTRAPNGLE", OP_FTRAPCC, 0x18, 0, 0},
	{ "FTRAPOGE", OP_FTRAPCC, 0x03, 0, 0},
	{ "FTRAPOGL", OP_FTRAPCC, 0x06, 0, 0},
	{ "FTRAPOGT", OP_FTRAPCC, 0x02, 0, 0},
	{ "FTRAPOR", OP_FTRAPCC, 0x07, 0, 0},
	{ "FTRAPOLE", OP_FTRAPCC, 0x05, 0, 0},
	{ "FTRAPOLT", OP_FTRAPCC, 0x04, 0, 0},
	{ "FTRAPSEQ", OP_FTRAPCC, 0x11, 0, 0},
	{ "FTRAPSF", OP_FTRAPCC, 0x10, 0, 0},
	{ "FTRAPSNE", OP_FTRAPCC, 0x1e, 0, 0},
	{ "FTRAPST", OP_FTRAPCC, 0x1f, 0, 0},
	{ "FTRAPT", OP_FTRAPCC, 0x0f, 0, 0},
	{ "FTRAPUGE", OP_FTRAPCC, 0x0b, 0, 0},
	{ "FTRAPUGT", OP_FTRAPCC, 0x0a, 0, 0},
	{ "FTRAPULE", OP_FTRAPCC, 0x0d, 0, 0},
	{ "FTRAPULT", OP_FTRAPCC, 0x0c, 0, 0},
	{ "FTRAPUEQ", OP_FTRAPCC, 0x09, 0, 0},
	{ "FTRAPUN", OP_FTRAPCC, 0x08, 0, 0},
	{ "FTST", OP_FREGT, 0x3a, 0, 0},
	{ "FTWOTOX", OP_FREG, 0x11, 0, 0},
	{ "ILLEGAL", OP_1WORD,		0x4afc, 0, 0},
	{ "ISP",  CONTROL | AREG, ISPREG, 0, 0 },
	{ "JMP",	OP_JMP,				0x4ec0, 0, 0},
	{ "JSR",	OP_JMP,				0x4e80, 0, 0},
	{ "LEA",	OP_LEA,				0x41c0, 0, 0},
	{ "LINK", OP_LINK,			0x4800, 0, 0},
	{ "LPSTOP",	OP_LPSTOP,	0xf800, 0, 0},
	{ "LSL",  OP_SHIFT,    0xe308 , 0xe3c0, 0},
	{ "LSR",  OP_SHIFT,		 0xe208 , 0xe2c0, 0},
  { "MMU",	CONTROL | MMUREG, XMMUREG,0,0},
	{ "MOVE", OP_MOVEGENERIC,			0x0000, 0x4040, 0},
	{ "MOVEA", OP_MOVEA, 		0x0040, 0, 0},
	{ "MOVEC", OP_MOVEC,		0x4e7a, 0, 0},
 	{ "MOVEM", OP_MOVEM,		0x4880, 0, 0},
	{ "MOVEP", OP_MOVEP,		0x0108, 0, 0},
	{ "MOVEQ", OP_MOVEQ,		0x7000, 0, 0},
	{ "MOVES", OP_MOVES,		0x0e00, 0, 0},
	{ "MSP",  CONTROL | AREG, MSPREG, 0, 0 },
	{ "MULS", OP_MULDIV,		0xc1c0, 0x4c00, 0},
	{ "MULU", OP_MULDIVU,		0xc0c0, 0x4c00, 0},
	{ "NBCD", OP_NEGDECIMAL, 0x4800, 0, 0},
	{ "NEG", OP_NEG,				0x4400, 0, 0},
	{ "NEGX", OP_NEG,				0x4000, 0, 0},
	{ "NOP",	OP_1WORD,			0x4e71, 0, 0},
	{ "OR",  OP_ORGENERIC,  	0x8000, 0, 0},
	{ "ORI", OP_LOGIMM,  	 	0x0000, 0, 0},
	{ "PACK", OP_PACK,			0x8140, 0, 0},
	{ "PC", CONTROL | AREG, PCREG, 0, 0},
	{ "PEA",  OP_PEA,				0x4840, 0, 0},
  { "PFLUSH",OP_PFLUSH,0xf008,0,0},
  { "PFLUSHA",OP_PFLUSH,0xf019,0,0},
  { "PFLUSHAN",OP_PFLUSH,0xf511,0,0},
  { "PFLUSHN",OP_PFLUSH,0xf500,0,0},
	{ "PLOADR",OP_PLOAD,0x2200,0,0},
  { "PLOADW",OP_PLOAD,0x2000,0,0},
	{ "PMOVE",OP_PMOVE,0x0000,0,0},
	{ "PMOVEFD",OP_PMOVE,0x0100,0,0},
	{ "PTESTR",OP_PTEST,0x8200,0,0},
	{ "PTESTW",OP_PTEST,0x8000,0,0},
	{ "RESET", OP_1WORD,		0x4e70, 0, 0},
	{ "ROL",  OP_SHIFT,    0xe718 , 0xe7c0, 0},
	{ "ROR",  OP_SHIFT,		 0xe618 , 0xe6c0, 0},
	{ "ROXL",  OP_SHIFT,    0xe510 , 0xe5c0, 0},
	{ "ROXR",  OP_SHIFT,		 0xe410 , 0xe4c0, 0},
	{ "RTD",	OP_RTD,				0x4e74, 0, 0},
	{ "RTE",  OP_RTE,    		0x4e73, 0, 0},
	{ "RTM",  OP_RTM,				0x06c0, 0, 0},
	{ "RTR",	OP_1WORD,			0x4e77, 0, 0},
	{ "RTS",	OP_1WORD,			0x4e75, 0, 0},
	{ "SBCD", OP_DECIMAL,		0x8100, 0, 0},
	{ "SCC",	OP_NEGDECIMAL,   0x54c0, 0, 0},
	{ "SCS",	OP_NEGDECIMAL,   0x55c0, 0, 0},
	{ "SEQ",	OP_NEGDECIMAL,   0x57c0, 0, 0},
	{ "SF",	OP_NEGDECIMAL,   0x51c0, 0, 0},
	{ "SFC",  CONTROL | AREG, SFCREG, 0, 0 },
	{ "SGE",	OP_NEGDECIMAL,   0x5cc0, 0, 0},
	{ "SGT",	OP_NEGDECIMAL,   0x5ec0, 0, 0},
	{ "SHI",	OP_NEGDECIMAL,   0x52c0, 0, 0},
	{ "SHS",	OP_NEGDECIMAL,   0x54c0, 0, 0},
	{ "SLE",	OP_NEGDECIMAL,   0x5fc0, 0, 0},
	{ "SLO",	OP_NEGDECIMAL,   0x55c0, 0, 0},
	{ "SLS",	OP_NEGDECIMAL,   0x53c0, 0, 0},
	{ "SLT",	OP_NEGDECIMAL,   0x5dc0, 0, 0},
	{ "SMI",	OP_NEGDECIMAL,   0x5bc0, 0, 0},
	{ "SNE",	OP_NEGDECIMAL,   0x56c0, 0, 0},
	{ "SP",		CONTROL | AREG, 7, 0, 0},
	{ "SPL",	OP_NEGDECIMAL,   0x5ac0, 0, 0},
	{ "SR",  CONTROL | AREG, SRREG, 0, 0 },
  { "SRP",	CONTROL | MMUREG, SRPREG,0,0},
	{ "ST",	OP_NEGDECIMAL,   0x50c0, 0, 0},
	{ "STOP", OP_STOP,			0x4e72, 0, 0},
	{ "SUB",  OP_SUBGENERIC,  0x9000, 0, 0},
	{ "SUBA", OP_AADDSUB,  0x90c0, 0, 0},
	{ "SUBI", OP_IADDSUB,  0x0400, 0, 0},
	{ "SUBQ", OP_QADDSUB,  0x5100, 0, 0},
	{ "SUBX", OP_XADDSUB,  0x9100, 0, 0},
	{ "SVC",	OP_NEGDECIMAL,   0x58c0, 0, 0},
	{ "SVS",	OP_NEGDECIMAL,   0x59c0, 0, 0},
  { "SWAP", OP_SWAP,	   0x4840, 0, 0},
  { "TAS",  OP_NEGDECIMAL, 	 0x4ac0, 0, 0},
	{ "TBLS", OP_TBL, 0x0800,0,0,0},
	{ "TBLSN", OP_TBL, 0x0c00,0,0,0},
	{ "TBLU", OP_TBL, 0x0000,0,0,0},
	{ "TBLUN", OP_TBL, 0x0400,0,0,0},
  { "TC",	CONTROL | MMUREG, TCREG,0,0},
  { "TRAP", OP_TRAP,	   0x4e40, 0, 0},
	{ "TRAPCC",	OP_TRAPCC,   0x54f8, 0, 0},
	{ "TRAPCS",	OP_TRAPCC,   0x55f8, 0, 0},
	{ "TRAPEQ",	OP_TRAPCC,   0x57f8, 0, 0},
	{ "TRAPF",	OP_TRAPCC,   0x51f8, 0, 0},
	{ "TRAPGE",	OP_TRAPCC,   0x5cf8, 0, 0},
	{ "TRAPGT",	OP_TRAPCC,   0x5ef8, 0, 0},
	{ "TRAPHI",	OP_TRAPCC,   0x52f8, 0, 0},
	{ "TRAPHS",	OP_TRAPCC,   0x54f8, 0, 0},
	{ "TRAPLE",	OP_TRAPCC,   0x5ff8, 0, 0},
	{ "TRAPLO",	OP_TRAPCC,   0x55f8, 0, 0},
	{ "TRAPLS",	OP_TRAPCC,   0x53f8, 0, 0},
	{ "TRAPLT",	OP_TRAPCC,   0x5df8, 0, 0},
	{ "TRAPMI",	OP_TRAPCC,   0x5bf8, 0, 0},
	{ "TRAPNE",	OP_TRAPCC,   0x56f8, 0, 0},
	{ "TRAPPL",	OP_TRAPCC,   0x5af8, 0, 0},
	{ "TRAPT",	OP_TRAPCC,   0x50f8, 0, 0},
	{ "TRAPV",  OP_1WORD,		 0x4e76, 0, 0},
	{ "TRAPVC",	OP_TRAPCC,   0x58f8, 0, 0},
	{ "TRAPVS",	OP_TRAPCC,   0x59f8, 0, 0},
	{ "TST",		OP_TST,			 0x4a00, 0, 0},
  { "TT0",	CONTROL | MMUREG, TT0REG,0,0},
  { "TT1",	CONTROL | MMUREG, TT1REG,0,0},
	{ "TTL",		CONTROL | FUNC,			 TITLE, 0, 0},
  { "UNLK",		OP_UNLK, 		 0x4e58, 0, 0},
  { "UNPK",		OP_PACK,		 0x8180, 0, 0},
	{ "USP",  CONTROL | AREG, USPREG, 0, 0 },
	{ "VBR",  CONTROL | AREG, VBRREG, 0, 0 },
	{ "ZPC", CONTROL | AREG, ZPCREG, 0, 0},
	{ 0, 0, 0,0,0 }
} ;
void nontermerr(void)
{
 	Error("Non-terminated character constant");
}
int yylex(void)
{
	char buffer[BUFLEN];
	char buf1[BUFLEN];
	int curchar;

lexlp:
	curchar = parsechar(&bufptr);
	if (curchar == 0 || newline) {
		newline = FALSE;
		while (!nextLine( buf, BUFLEN)) {
			closeFile();
			if (level < 0) {
				level = -1;
				return(EOF);
			}
		}
		bufptr = buf;
		curchar = parsechar(&bufptr);
		firstsymbol = TRUE;
		if (iswhitespacechar(curchar))
			curchar = skipSpace(&bufptr);
		if (curchar == '*') {
			newline = TRUE;
			return '\n';
		}
	}
	if (iswhitespacechar(curchar))
		curchar = skipSpace(&bufptr);
	if (iscommentchar(curchar)) {
		if (curchar == ';')
			do {
				curchar = parsechar(&bufptr);
			} while (curchar != 0x0a);
		else
			do { 
				curchar = parsechar(&bufptr);
			} while (!iscommentchar(curchar) && curchar != 0x0a);
		if (curchar == 0x0a) {
			newline = TRUE;
			loadsdata = FALSE;
			return('\n');
		}
		goto lexlp;
	}
  if (curchar == '`') {
		curchar = parsechar(&bufptr);
		yylval.val = 0xffff;
		if (curchar == 'N') {
			curchar = parsechar(&bufptr);
			yylval.val = 0x3210;
		}
		else {
			if (curchar == 'H') {
				yylval.val = 0xff10;
				curchar = parsechar(&bufptr);
				if (curchar == 'L') {
					curchar = parsechar(&bufptr);
					yylval.val = 0x2301;
				}
				else
					if (curchar == 'H') {
						curchar = parsechar(&bufptr);
						yylval.val = 0x3210;
					}
					else
						if (curchar == 'I') {
							curchar = parsechar(&bufptr);
							yylval.val = 0xFFF1;
						}
			}
			else
				if (curchar == 'L') {
					yylval.val = 0xff01;
					curchar = parsechar(&bufptr);
					if (curchar == 'L') {
						curchar = parsechar(&bufptr);
						yylval.val = 0x0123;
					} 	
					else
						if (curchar == 'H') {
							curchar = parsechar(&bufptr);
							yylval.val = 0x1032;
						}
					else
						if (curchar == 'O') {
							curchar = parsechar(&bufptr);
							yylval.val = 0xfff0;
						}
	 			}
				else
					if (curchar >= '0' && curchar < '4' ) {
						while (curchar >= '0' && curchar < '4') {
							yylval.val <<= 4;
							yylval.val |= (curchar - '0');
						}
					}
					else
						if (isalpha(curchar)) {
							int i = 0;
							EXPRESSION **q;
							while(isalpha(curchar) ) {
								buffer[i] = curchar;
	 							buf1[i] = toupper(curchar);
								curchar = parsechar(&bufptr);
								i++;
							}
							buf1[i] = 0;
							buffer[i] = 0;
							/* This only supports FUNC types */
							if ((q = LookupHash(hashtable, buf1)) != 0) {
								if ((*q)->isopcode) {
							  	yylval.opcptr = (*q)->x.xdata;
									return(((OPCODEDATA*)(yylval.opcptr))->op1);
								}
							}
							BadTick();
						}
						else
							BadTick();
			
		}
		putphiback(curchar);
		bufptr--;
		return(SWAPPER);
	}
	if (curchar == '\'') {
		yylval.val = 0;
		if (phiused) {
			yylval.val = getphichar(&bufptr) & 0x3ff ;
			curchar = parsechar(&bufptr);
			if (curchar != '\'')
				nontermerr();
		}
		else {
			curchar = getphichar(&bufptr);
			while (curchar != '\'' && curchar) {
				yylval.val*=256;
				yylval.val+=curchar;
				curchar = parsechar(&bufptr);
			}
			if (curchar != '\'')
				nontermerr();
		}
		return(NUM);
	}
	if (curchar == '"' || (curchar == '<' && ininclude)) {
		int endchar = '"';
		char lbuf[BUFLEN];
		if (curchar == '<')
			endchar = '>';
		curchar = getphistring(lbuf,&bufptr, endchar);
		if (curchar == 0)
			Error("Non-terminated string constant");
		yylval.string = AllocateMemory(strlen(lbuf)+1);
		strcpy(yylval.string, lbuf);
		return(STRING);
	}
		
	if (curchar == '$') {
		curchar = parsechar(&bufptr);
		yylval.val = 0;
		while(isxdigit(curchar)) {
			char temp = toupper(curchar);
			yylval.val*=16;
			if (temp >= 'A')
				temp-= 7;
			temp -= '0';
			yylval.val+=temp;
			curchar = parsechar(&bufptr);
		}
		putphiback(curchar);
		bufptr--;
		return(NUM);
	}
	if (curchar == '%' || (phiused && curchar == SYM_CENT)) {
		int val = curchar;
		curchar = parsechar(&bufptr);
		if (curchar != '0' && curchar != '1') {
			bufptr--;
			putphiback(curchar);
			return(val);
		}
		yylval.val = 0;
		while(curchar == '0' || curchar == '1') {
			char temp = toupper(curchar);
			yylval.val*=2;
			temp -= '0';
			yylval.val+=temp;
			curchar = parsechar(&bufptr);
		}
		putphiback(curchar);
			bufptr--;
		return(NUM);
	}
	if ((phiused && curchar == SYM_YEN)) {
		curchar = parsechar(&bufptr);
		if (curchar < '0' || curchar > '7') {
			bufptr--;
			putphiback(curchar);
			return('%');
		}
		yylval.val = 0;
		while(curchar >= '0' && curchar <= '7') {
			char temp = toupper(curchar);
			yylval.val*=8;
			temp -= '0';
			yylval.val+=temp;
			curchar = parsechar(&bufptr);
		}
		putphiback(curchar);
		bufptr--;
		return(NUM);
	}
	if (isdigit (curchar) || (phiused && curchar == SYM_LB)) {
		int ishex = FALSE;
		char buf[40];
		char *pos = buf;
		if (curchar == SYM_LB) {
			curchar = parsechar(&bufptr);
		}
		yylval.val = 0;
		while(isxdigit(curchar)) {
			*pos++ = toupper(curchar);
			curchar = parsechar(&bufptr);
		}
		*pos = 0;
		pos = buf;
		if (curchar == 'h' || curchar == 'H') {
			ishex = TRUE;
			curchar = parsechar(&bufptr);
		}
		while (*pos) { 
			char temp = *pos++;
			temp -= '0';
			if (ishex) {
				yylval.val*=16;
				if (temp > 9)
					temp-= 7;
			}
			else {
				yylval.val*=10;
				if (temp > 9)
					Error("Invalid use of hex digit");
			}
			yylval.val+=temp;
		}
		if (curchar == '.' || curchar == 'e' || curchar == 'E') {
			GetFloatNumber(curchar,yylval.val,&yylval.floatptr[0]);
			return(FNUM);
		}
		bufptr--;
		putphiback(curchar);
		return(NUM);
	}
	if (FALSE && curchar == ':') {
		curchar = parsechar(&bufptr);
		if (isxdigit(curchar)) {
			int index = 0;
			memset(yylval.floatptr,0,12);
			while (isxdigit(curchar)) {
				int temp = toupper(curchar);
				if (temp >= 'A')
					temp -= 'A'-10;
				else
					temp -= '0';
				if (index < 24) {
					if (!(index & 1))
						temp = temp << 4;
					yylval.floatptr[index>>1] |= temp;
					index++;
				}
			}
			putphiback(curchar);
			bufptr--;
			return (FNUMSPEC);
		}
		else {
			putphiback(curchar);
			bufptr--;
			return(':');
		}
	}
	if (isstartchar(curchar) || curchar == SYM_ALTSTAR || curchar =='*' || curchar == '#') {
		EXPRESSION **q;
		char *oldptr = bufptr-1;
		int i = 0;
		if (prm_case_sensitive)
			installphichar(curchar,buffer,i);
		else
			installphichar(phiupper(curchar),buffer,i);
		i+= installphichar(phiupper(curchar),buf1,i);
		curchar = parsechar(&bufptr);
		while(issymchar(curchar) && curchar != '.') {
			if (prm_case_sensitive)
				installphichar(curchar,buffer,i);
			else
				installphichar(phiupper(curchar),buffer,i);
			i += installphichar(phiupper(curchar),buf1,i);
			curchar = parsechar(&bufptr);
		}
		bufptr--;
		putphiback(curchar);
		buffer[i] = 0;
		buf1[i] = 0;
		if ((q = LookupHash(hashtable, buf1)) != 0 && (*q)->isopcode) {
			OPCODEDATA *t = ((EXPRESSION *)(*q))->x.xdata;
			if ((t->type == (CONTROL | FUNC)) && (t->op1 == INCLUDE) )
				ininclude = TRUE;
			goto gotopcode;
		}
		curchar = parsechar(&bufptr);
		while(issymchar(curchar)) {
			if (prm_case_sensitive)
				installphichar(curchar,buffer,i);
			else
				installphichar(phiupper(curchar),buffer,i);
			i += installphichar(phiupper(curchar),buf1,i);
			curchar = parsechar(&bufptr);
		}
		bufptr--;
		putphiback(curchar);
		buffer[i] = 0;
		buf1[i] = 0;
		if ((buffer[i-1] & 0xf0) == 0x90)
			buffer[i-1] = 0x90;
		if (firstsymbol) {
			firstsymbol = FALSE;
			macroptr = bufptr;
		}
		if ((q = CheckLocalLabel(buffer)) != 0) 
			goto copyexpression;
		if ((q = LookupHash(hashtable, buffer)) == 0) {
			EXPRESSION *p;
			if (buf1[0] == '*' || buf1[0] == '#') {
				repeat = 0;
				putback = 0;
				bufptr = oldptr+1;
				return(*oldptr++);
	 		}
			p  = AllocateMemory(sizeof(EXPRESSION));
			if (pass == 2) {
				int i = findsection(buffer);
				if (i) {
					SECTIONREC *q = getsection(i);
					p->name = AllocateMemory(strlen(q->name)+1);
					strcpy(p->name,q->name);
					p->x.value = q->highest;
				}	
				else						 {
					if (!ifskip)
						UndefError(buffer,FALSE);
					goto getname;
				}
			}
			else {
getname:
				p->name = AllocateMemory(strlen(buffer)+1);
				strcpy(p->name,buffer);
				p->x.value = 0;
			}
			p->size = 0;
			p->link = 0;
			p->loclablink = 0;
			p->isdef = FALSE;
			p->isintermed = TRUE;
			p->islabel = FALSE;
			p->isextern = FALSE;
			p->defpass = 0;
			p->isopcode = FALSE;
			p->ismacro = FALSE;
			p->isoperand = FALSE;
			p->ischangeable = FALSE;
			p->ismovemreg = FALSE;
			p->isstruct = FALSE;
			p->rel = FALSE;
			p->islocalpub = FALSE;
			p->ispublic = FALSE;
			p->relpc = FALSE;
			p->relmode = RM_NONE;
			p->isfp = FALSE;
			p->floatspec = FALSE;
			p->id = 0;
			p->xrefcount = 0;
			p->section = 0;
			p->xrefcount = 0;
			p->swapper = 0xffff;
			p->datatype = 0;
			yylval.expr = p;
			return(SYMBOL);
		}
		else {
gotopcode:
			if ((*q)->isopcode) {
				OPCODEDATA *temp = (*q)->x.xdata;
				yylval.opcptr = temp;
				if (temp->type & CONTROL) {
					if (temp->type & ISIF) {
						yylval.val = temp->op1;
						return(IF);
					}
					if (temp->type & ISIF2) {
						yylval.val = temp->op1;
						return(IF2);
					}
					if (temp->type & FUNC)
						return(temp->op1);
					if (temp->type & DATA) {
						loadsdata = TRUE;
						return(temp->op1);
					}
					if (temp->type &SCALETYPE)  {
						yylval.reg = temp->op1;
						return(SCALE);
					}
					if (temp->type & TYPETYPE) {
						yylval.reg = temp->op1;
						return(TYPE);
					}
					if (temp->type & ISOPT) {
						yylval.val = temp->op1;
						return(OPTTYPE);
					}
					if (temp->type & ISOPTEQU) {
						yylval.val = temp->op1;
						return(OPTEQUTYPE);
					}
					yylval.reg = temp->op1;
					return(temp->type & (~CONTROL));
			 	}
				else {
					loadsdata = TRUE;
					if (temp->type == OP_MOVEM)
						return(OPCODE_MOVEM);
					if (temp->type == OP_FMOVEM)
						return(OPCODE_FPMOVEM);
					if (temp->type & OP_MMU)
						return(OPCODE_MMU);
			  	return(OPCODE);
				}
	
			}
			else {
copyexpression:
				addxref(*q);
				yylval.expr = AllocateMemory(sizeof(EXPRESSION));
				*yylval.expr = **q;
				yylval.expr->name = AllocateMemory(strlen((*q)->name)+1);
				strcpy(yylval.expr->name, (*q)->name);
				yylval.expr->isintermed = TRUE;
				if (loadsdata && pass == 2 && !ifskip && undeflist) {
					LDATA *r = undeflist->data;
					LIST *p = undeflist;
					if ((r->relofs == org) || (r->relofs == org+1) && !strcmp(r->name, (*q)->name)) {
						yylval.expr->size = r->size;
						undeflist = undeflist->link;
						DeallocateMemory(r->name);
						DeallocateMemory(r);
						DeallocateMemory(p);
					}
					else
						yylval.expr->size = 0;
				}   	
				else 
					yylval.expr->size = 0;
				if (yylval.expr->ismacro)
					return(MACROSYM);
				if (yylval.expr->ismovemreg)
					return(MOVEMREGSYM);
				if (yylval.expr->isoperand)
					return(OPERANDSYM);
				if (yylval.expr->isstruct)
					return(STRUCTSYM);
				if (yylval.expr->isfp)
					return(FSYM);
				return(SYMBOL);
			}
		}
	}
	if (curchar == '\n') {
		loadsdata = FALSE;
		ininclude = FALSE;
	}
	if (curchar == '<' || curchar == '>' || curchar == '!' || curchar == '='
			|| curchar == '|'  || curchar == '&' ) {
		EXPRESSION **q;
		int temp;
		buf1[0] = curchar;
    buf1[1] = temp = parsechar(&bufptr);
    buf1[2] = 0;
		q = LookupHash(hashtable,buf1);
		if ((temp <= 0x7f) && q) {
	  	yylval.opcptr = (*q)->x.xdata;
			return(((OPCODEDATA *)yylval.opcptr)->op1);
		}
		putphiback(temp);
		bufptr--;
	}
	else {
		switch(curchar) {
			case SYM_EQ:
				return(EQ);
			case SYM_NE:
				return(NE);
			case SYM_ALTDIV:
				return('/');
			case SYM_ALTSTAR:
				return('*');
			case SYM_LE:
				return(LE);
			case SYM_GE:
				return(GE);
			case SYM_SHL:
				return(SHLEFT);
			case SYM_SHR:
				return(SHRIGHT);
		}
	}
	return(curchar);
}