/*
        Custom Computer Consultants
        Universal Cross Assembler
        Z8 Symbols
        5 April 1986
*/
#include <stdio.h>
#include <uasm.h>

char   *version = {"Z8 Assembler -- V3.5  4/5/86\n"} ;


#define RSEG    0       /*      Register Segment        */
#define CSEG    1       /*      Code Segment            */
#define DSEG    2       /*      Data Segment            */
#define XSEG    3       /*      External Data Segment   */
#define ASCII   4       /*      String                  */
#define PAGE    5       /*      Page Eject              */
#define RADIX   6       /*      Define Radix            */
#define REG     7       /*      Register Address        */
#define DB      8       /*      Define Byte             */
#define DS      9       /*      Define Storage          */
#define DW      10      /*      Define Word             */
#define EQU     11      /*      Equate                  */
#define ORG     12      /*      Origin                  */

extern int     pass1 ;
extern int     lbl ;
extern int     i, j, k ;
extern int     lnspp ;
extern int     cc ;
extern int     ilc ;
extern int     active ;
extern int     instl ;
extern int     parval ;
extern int     radix ;
extern int     cput ;
extern int     syte, sytx ;

extern unsigned        unpar ;
extern unsigned        ha, he, hsp ;

extern unsigned  char    ch ;
extern unsigned  char    sym ;

extern char    *iptr ;  
extern char    segtype[] ;

extern unsigned  char    ib[] ;
extern unsigned  char    pv[] ;
extern unsigned  char    px[] ;

extern           int     pj[] ;
extern           int     il[] ;
extern char    *pc[], *pseudo[] ;

extern int     (*pp[])() ;
extern int     (*ppo[])() ;

extern char    ibuf[] ;

extern struct  symbol  symtab[] ;

#define SYMTYPE  (symtab[sytx].flags&(NSEG-1))

code_seg() { return CSEG ; }

not_cseg(seg)
int    seg ;
{
       if( seg == RSEG || seg == DSEG ) return TRUE ;
       else return FALSE ;
}

set_il()
{
       il[RSEG] =    0 ;
       il[CSEG] =    0 ;
       il[DSEG] =    0 ;
       il[XSEG] = 4096 ;
}

set_type()
{
       segtype[RSEG] = '^'  ;
       segtype[CSEG] = '\'' ;
       segtype[DSEG] = '\"' ;
       segtype[XSEG] = '+'  ;
}

amatch(s)
char   *s ;
{
       int     tc ;

       tc = cc - 1 ;
       while( *s ) {
         if( toupper(ch) != *s++ ) { iptr = &ibuf[cc=tc] ; getch() ;
                                     return FALSE ;
                                     }
         getch() ;
         }
       return TRUE ;
}

gen(len)
int     len ;
{
        ib[2] = parval & 0xFF ;
        ib[1] = len == 3 ? parval >> 8 : ib[2] ;
        instl = len ;
        ib[0] = pv[k] ;
        return TRUE ;
}

isreg(r)
int    r ;
{
       return ((( r >= 0   ) && ( r <= 127 )) ||
               (( r >= 240 ) && ( r <= 255 ))   ) ;
}

iswreg(r)
int    r ;
{
       return (( r >= 0 ) && ( r <= 15 )) ;
}

nopr()  { return gen(1) ; }

immd()  { if( nomatch("#") )            return FALSE ;
          parval = eval() ;
          return gen(2) ; }

dreg()  { parval = eval() ;
          if     (( SYMTYPE == RSEG ) && iswreg(parval)) parval |= 0xE0 ;
          else if(( SYMTYPE == DSEG ) && isreg(parval)) ;
               else push('M') ;
          return gen(2) ; }


indr()  { if( nomatch("@") )            return FALSE ;
          return dreg() ; }

wreg()  { parval = eval() ;
          if ( SYMTYPE != RSEG  )        return FALSE ;
          if ( !iswreg(parval)  )        return FALSE ;
          ib[0] = (pv[k] + (parval << 4 )) ;
          instl = 1 ;
          return TRUE ; }

arith()
{        
          int  dst, dt, src, st, mode, type, rc  ;

          dt = st = 1 ;        /* Unrecognized         */
          mode = 4 ;           /* Default R,R          */
          rc = TRUE ;

          if( amatch("@") ) dt |= 4 ;       /* Set Indirect Flag */
          dst = eval() ; type = SYMTYPE ;
          if( (( type == RSEG ) && iswreg(dst)) ||
              (( type == DSEG ) && isreg(dst)) )   dt = (dt & ~1) | type ;

          if( amatch(",#") ) {
              src = eval() ;
              st = 8 ;
              }
          else {
               if( amatch(",@") )    st |= 4 ;
               else if( notcomma() ) return FALSE ;
               src = eval() ; type = SYMTYPE ;
               if( (( type == RSEG ) && iswreg(src)) ||
                   (( type == DSEG ) && isreg(src)) )  st = (st & ~1) | type ;
               }

          switch ( dt*10+st ) {

            case  0 : mode = 2 ; 
                      goto ww ;

            case  4 : mode = 3 ;
            
            ww:       parval = ( dst << 4 ) | src ;
                      instl = 2 ;
                      break ;

            case  2 : dst |= 0xE0 ; goto rr ;

            case 20 : src |= 0xE0 ; goto rr ;

            case 22 : ;
            rr:       mode = 4 ;
                      parval = ( src << 8 ) + dst ;
                      instl = 3 ;
                      break ;

            case  6 : dst |= 0xE0 ; goto rir ;

            case 24 : src |= 0xE0 ; goto rir ;

            case 26 : ;
            rir:      mode = 5 ;
                      parval = ( src << 8 ) + dst ;
                      instl = 3 ;
                      break ;

            case  8 : dst |= 0xE0 ; goto rim ;

            case 28 : ;
            rim:      mode = 6 ;
                      parval = ( dst << 8 ) + src ;
                      instl = 3 ;
                      break ;

            case 48 : dst |= 0xE0 ; goto iim ;

            case 68 : ;
            iim:      mode = 7 ;
                      parval = ( dst << 8 ) + src ;
                      instl = 3 ;
                      break ;

            default : parval = ( src << 8 ) + dst ;
                      instl = 3 ;
                      rc = FALSE ;
            }
          gen(instl) ;
          ib[0] |= mode ;
          return rc ;
}

/*     Destination Type        Source Type

       0     r                 r   
       2     R                 R   
       4     @r                @r   
       6     @R                @R   
       8     r(r)              r(r)
       A     R(r)              R(r)
       C      -                #IM
*/

ldins()
{
       int     dst, dt, src, st, x, type ;

       dt = st = 1 ;           /* Unrecognized */

       if( amatch("@") )       dt = dt | 4 ;
       dst = eval() ; type = SYMTYPE ;
       if( (( type == RSEG ) && iswreg(dst)) ||
           (( type == DSEG ) && isreg(dst)) )    dt = (dt & ~1) | type ;
       if( amatch("(") ) {
         x = eval() ;  type = SYMTYPE ;
         if(( type == RSEG ) && iswreg(x) )      dt = dt | 8 ;
         if( nomatch(")") )                      return FALSE ;
         }

       if( notcomma() )                          return FALSE ;

       if( amatch("#") ) { src = eval() ; st = 12 ; }
       else {
         if( amatch("@") )     st = st | 4 ;
         src = eval() ;  type = SYMTYPE ;
         if( (( type == RSEG ) && iswreg(src)) ||
             (( type == DSEG ) && isreg(src)) )  st = (st & ~1) | type ;
         if( amatch("(") ) {
           x = eval() ; type = SYMTYPE ;
           if(( type == RSEG ) && iswreg(x) )    st = st | 8 ;
           if( nomatch(")") )                    return FALSE ;
           }
         }
       switch( dt * 16 + st ) {

                     /* 00 - r,r       */
         case   0 :  ib[instl++] = ( dst << 4 ) + 0x08 ;
                     ib[instl++] = src + 0xE0 ;                return TRUE ;

                     /* 02 - r,R       */
         case   2 :  ib[instl++] = ( dst << 4 ) + 0x08 ;
                     ib[instl++] = src ;                       return TRUE ;

                     /* 04 - r,@r      */
         case   4 :  ib[instl++] = 0xE3 ;
                     ib[instl++] = ( dst << 4 ) + src ;        return TRUE ;

                     /* 06 - r,@R      */
         case   6 :  ib[instl++] = 0xE5 ;
                     ib[instl++] = src ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* 08 - r,r(r)    */
         case   8 :  ib[instl++] = 0xC7 ;
                     ib[instl++] = ( dst << 4 ) + x ;
                     ib[instl++] = src + 0xE0 ;                return TRUE ;

                     /* 10 - r,R(r)    */
         case  10 :  ib[instl++] = 0xC7 ;
                     ib[instl++] = ( dst << 4 ) + x ;
                     ib[instl++] = src ;                       return TRUE ;

                     /* 12 - r,IM      */
         case  12 :  ib[instl++] = ( dst << 4 ) + 0x0C ;
                     ib[instl++] = src ;                       return TRUE ;

                     /* 32 - R,r       */
         case  32 :  ib[instl++] = ( src << 4 ) + 0x09 ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* 34 - R,R       */
         case  34 :  ib[instl++] = 0xE4 ;
                     ib[instl++] = src ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* 36 - R,Ir      */
         case  36 :  ib[instl++] = 0xE5 ;
                     ib[instl++] = src + 0xE0 ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* 38 - R,IR      */
         case  38 :  ib[instl++] = 0xE5 ;
                     ib[instl++] = src ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* 44 - R,IM      */
         case  44 :  ib[instl++] = 0xE6 ;
                     ib[instl++] = dst ;
                     ib[instl++] = src ;                       return TRUE ;

                     /* 64 - Ir,r      */
         case  64 :  ib[instl++] = 0xF3 ;
                     ib[instl++] = ( dst << 4 ) + src ;        return TRUE ;

                     /* 66 - Ir,R      */
         case  66 :  ib[instl++] = 0xF5 ;
                     ib[instl++] = src ;
                     ib[instl++] = dst + 0xE0 ;                return TRUE ;

                     /* 96 - IR,r      */
         case  96 :  ib[instl++] = 0xF5 ;
                     ib[instl++] = src + 0xE0 ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* 98 - IR,R      */
         case  98 :  ib[instl++] = 0xF5 ;
                     ib[instl++] = src ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* 108 - IR,IM    */
         case 108 :  ib[instl++] = 0xE7 ;
                     ib[instl++] = dst ;
                     ib[instl++] = src ;                       return TRUE ;

                     /* 128 - r(r),r   */
         case 128 :  ib[instl++] = 0xD7 ;
                     ib[instl++] = ( src << 4 ) + x ;
                     ib[instl++] = dst + 0xE0 ;                return TRUE ;

                     /* 160 - R(r),r   */
         case 160 :  ib[instl++] = 0xD7 ;
                     ib[instl++] = ( src << 4 ) + x ;
                     ib[instl++] = dst ;                       return TRUE ;

                     /* Default is R,R */
         default  :  ib[instl++] = 0xE4 ;
                     ib[instl++] = src ;
                     ib[instl++] = dst ;                       return FALSE ;
         }
}


wrrl()  { if( !wreg() )                        return FALSE ;
          if( notcomma() )                     return FALSE ;
          crela(2) ;
          ib[1] = parval & 0xFF ;
          instl = 2 ;
          return TRUE ; }

ccra()
{
       parval = eval() ;
       if( notcomma() ) {           /* cc is "ALWAYS"       */
         ib[0] = pv[k] + 0x80 ;
         parval = parval - ( ilc + 2 ) ;
         if( parval > 127 || parval < -128 ) push('R') ;
         }
       else {
         if( (parval < 0) || (parval > 15) )   return FALSE ;
         ib[0] = pv[k] + ( parval << 4 ) ;
         crela(2) ;
         }
       ib[1] = parval & 0xFF ;
       instl = 2 ;
       return TRUE ;
 }

ccda()
{
       parval = eval() ;
       if( notcomma() ) {              /* cc is "ALWAYS"       */
         ib[0] = pv[k] + 0x80 ;
         }
       else {
         if( (parval < 0) || (parval > 15) )   return FALSE ;
         ib[0] = pv[k] + ( parval << 4 ) ;
         parval = eval() ;
         }
       ib[1] = parval >> 8 ;
       ib[2] = parval & 0xFF ;
       instl = 3 ;
       return TRUE ;
}

                      
rela()  { crela(2) ;
          return gen(2) ; }

crela(n)
int     n ;
{
        parval = eval() - ( ilc + n ) ;
        if( parval > 127 || parval < -128 ) push('R') ;
}

indp()  { if( nomatch("@") )                return FALSE ;
          dreg() ;
          if( parval & 1 )                  return FALSE ;
          return TRUE ; }


coda()  { parval = eval() ;
          return gen(3) ; }

drep()  { if( !dreg() )                return FALSE ;
          return                  ib[1] & 1 ? FALSE : TRUE ; }

ipiw()
{
       int     dst, src, type ;

       if( nomatch("@@") )           return FALSE ;
       dst = eval() ;  type = SYMTYPE ;
       if(( type != RSEG ) || !iswreg(dst) || ( dst & 1 )) return FALSE ;
       if( notcomma() )                                    return FALSE ;
       if( nomatch("@") )           return FALSE ;
       src = eval() ;
       if(( type != RSEG ) || !iswreg(src))                return FALSE ;
       parval = ( src << 4 ) + dst ;
       return gen(2) ;
}



ipwr()
{
       int     dst, src, type ;

       if( nomatch("@@") )           return FALSE ;
       dst = eval() ;  type = SYMTYPE ;
       if(( type != RSEG ) || !iswreg(dst) || ( dst & 1 )) return FALSE ;
       if( notcomma() )                                    return FALSE ;
       src = eval() ;
       if(( type != RSEG ) || !iswreg(src))                return FALSE ;
       parval = ( src << 4 ) + dst ;
       return gen(2) ;
}
 
iwip()
{
       int     dst, src, type ;

       if( nomatch("@") )                                  return FALSE ;
       dst = eval() ;  type = SYMTYPE ;
       if(( type != RSEG ) || !iswreg(dst))                return FALSE ;
       if( notcomma() )                                    return FALSE ;
       if( nomatch("@") )                                  return FALSE ;
       src = eval() ;
       if(( type != RSEG ) || !iswreg(src) || (src & 1))   return FALSE ;
       parval = ( dst << 4 ) + src ;
       return gen(2) ;
}

wrip()
{
       int     dst, src, type ;

       dst = eval() ;  type = SYMTYPE ;
       if(( type != RSEG ) || !iswreg(dst))                return FALSE ;
       if( notcomma() )                                    return FALSE ;
       if( nomatch("@") )                                  return FALSE ;
       src = eval() ;
       if(( type != RSEG ) || !iswreg(src) || (src & 1))   return FALSE ;
       parval = ( dst << 4 ) + src ;
       return gen(2) ;
}

#define INFO     1
#define NOINFO   0

doseg()
{
       il[active] = ilc ;
       ilc = il[j] ;
       active = j ;
       return NOINFO ;
}

dods()
{
       instl = eval() ;
       return NOINFO ;
}

dodw()
{                
       parval = eval() ;
       ib[cput++] = parval >> 8 ;
       ib[cput++] = parval & 0xFF ;
       while ( sym == ',' ) {
         getch() ;
         parval = eval() ;
         ib[cput++] = parval >> 8 ;
         ib[cput++] = parval & 0xFF ;
         }
       instl = cput ;
       return INFO ;
}

dodb()
{
       parval = eval() ;
       ib[cput++] = parval & 0xFF ;
       while ( sym == ',' ) {
         getch() ;
         ib[cput++] = eval() & 0xFF ;
         }
       instl = cput ;
       return INFO ;
}                            

doreg()
{
       parval = eval() ;
       if ( pass1 && (lbl == OK) ) {
         symtab[syte-1].value = parval ;
         symtab[syte-1].flags = RSEG ;
         }
       return NOINFO ;
}

doequ()
{
       parval = eval() ;
       if ( pass1 && (lbl == OK) ) {
         symtab[syte-1].value = parval ;
         symtab[syte-1].flags = active ;
         }
       return NOINFO ;
}

doorg()
{
       parval = eval() ;
       ilc = parval ;
       if ( hsp == 0 ) ha = he = ilc ;
       return NOINFO ;
}

dopage()
{
       lnspp = 0 ;
       return NOINFO ;
}

doradix()
{
       radix = parval ;
       return NOINFO ;
}

doascii()
{
       while( isin(ch," \t") ) getch() ;
       sym = ch ; getch() ;
       while( ch != sym && ch != '\n' ) {
         ib[cput++] = ch ;
         getch() ;
         }
       ib[cput++] = EOS ;
       instl = cput ;
       return INFO ;
}

/*
        build_pseudo -- build a table of pointers to pseudo-ops
*/

build_pseudo()
{
        
        j = -1 ;
        pseudo[++j] = "ASCII" ; pj[j] = ASCII ; ppo[ASCII] = doascii ;
        pseudo[++j] = "CSEG"  ; pj[j] = CSEG  ; ppo[CSEG]  = doseg   ;
        pseudo[++j] = "DB"    ; pj[j] = DB    ; ppo[DB]    = dodb    ;
        pseudo[++j] = "DS"    ; pj[j] = DS    ; ppo[DS]    = dods    ;
        pseudo[++j] = "DSEG"  ; pj[j] = DSEG  ; ppo[DSEG]  = doseg   ;
        pseudo[++j] = "DW"    ; pj[j] = DW    ; ppo[DW]    = dodw    ;
        pseudo[++j] = "EQU"   ; pj[j] = EQU   ; ppo[EQU]   = doequ   ;
        pseudo[++j] = "ORG"   ; pj[j] = ORG   ; ppo[ORG]   = doorg   ;
        pseudo[++j] = "PAGE"  ; pj[j] = PAGE  ; ppo[PAGE]  = dopage  ;
        pseudo[++j] = "RADIX" ; pj[j] = RADIX ; ppo[RADIX] = doradix ;
        pseudo[++j] = "REG"   ; pj[j] = REG   ; ppo[REG]   = doreg   ;
        pseudo[++j] = "RSEG"  ; pj[j] = RSEG  ; ppo[RSEG]  = doseg   ;
        pseudo[++j] = "XSEG"  ; pj[j] = XSEG  ; ppo[XSEG]  = doseg   ;
        return ++j ;
}

/*
        buildopc -- build opcode definition tables
                pc - opcode strings
                px - index by opcode into opcode values & post processing
                pv - opcode values
                pp - post processing functions
*/
buildopc()
{


        i = j = 0 ;

        pc[i]="ADC"   ; px[i++]=j ;     pv[j]=0x10 ; pp[j++]=arith ;

        pc[i]="ADD"   ; px[i++]=j ;     pv[j]=0x00 ; pp[j++]=arith ;

        pc[i]="AND"   ; px[i++]=j ;     pv[j]=0x50 ; pp[j++]=arith ;

        pc[i]="BC"    ; px[i++]=j ;     pv[j]=0x7B ; pp[j++]=rela ;
        pc[i]="BNOV"  ; px[i++]=j ;     pv[j]=0xCB ; pp[j++]=rela ;
        pc[i]="BEQ"   ; px[i++]=j ;     pv[j]=0x6B ; pp[j++]=rela ;
        pc[i]="BGE"   ; px[i++]=j ;     pv[j]=0x9B ; pp[j++]=rela ;
        pc[i]="BGT"   ; px[i++]=j ;     pv[j]=0xAB ; pp[j++]=rela ;
        pc[i]="BLE"   ; px[i++]=j ;     pv[j]=0x2B ; pp[j++]=rela ;
        pc[i]="BLT"   ; px[i++]=j ;     pv[j]=0x1B ; pp[j++]=rela ;
        pc[i]="BMI"   ; px[i++]=j ;     pv[j]=0x5B ; pp[j++]=rela ;
        pc[i]="BNC"   ; px[i++]=j ;     pv[j]=0xFB ; pp[j++]=rela ;
        pc[i]="BNE"   ; px[i++]=j ;     pv[j]=0xEB ; pp[j++]=rela ;
        pc[i]="BNOV"  ; px[i++]=j ;     pv[j]=0xCB ; pp[j++]=rela ;
        pc[i]="BNZ"   ; px[i++]=j ;     pv[j]=0xEB ; pp[j++]=rela ;
        pc[i]="BOV"   ; px[i++]=j ;     pv[j]=0x4B ; pp[j++]=rela ;
        pc[i]="BPL"   ; px[i++]=j ;     pv[j]=0xDB ; pp[j++]=rela ;
        pc[i]="BRA"   ; px[i++]=j ;     pv[j]=0x8B ; pp[j++]=rela ;
        pc[i]="BRN"   ; px[i++]=j ;     pv[j]=0x0B ; pp[j++]=rela ;
        pc[i]="BUGE"  ; px[i++]=j ;     pv[j]=0xFB ; pp[j++]=rela ;
        pc[i]="BUGT"  ; px[i++]=j ;     pv[j]=0xBB ; pp[j++]=rela ;
        pc[i]="BULE"  ; px[i++]=j ;     pv[j]=0x3B ; pp[j++]=rela ;
        pc[i]="BULT"  ; px[i++]=j ;     pv[j]=0x7B ; pp[j++]=rela ;
        pc[i]="BZ"    ; px[i++]=j ;     pv[j]=0x6B ; pp[j++]=rela ;


        pc[i]="CALL"  ; px[i++]=j ;     pv[j]=0xD4 ; pp[j++]=indp ;
                                        pv[j]=0xD6 ; pp[j++]=coda ;

        pc[i]="CCF"   ; px[i++]=j ;     pv[j]=0xEF ; pp[j++]=nopr ;
 
        pc[i]="CLR"   ; px[i++]=j ;
                                        pv[j]=0xB1 ; pp[j++]=indr ;
                                        pv[j]=0xB0 ; pp[j++]=dreg ;

        pc[i]="COM"   ; px[i++]=j ;
                                        pv[j]=0x61 ; pp[j++]=indr ;
                                        pv[j]=0x60 ; pp[j++]=dreg ;

        pc[i]="CP"    ; px[i++]=j ;     pv[j]=0xA0 ; pp[j++]=arith ;


        pc[i]="DA"    ; px[i++]=j ;
                                        pv[j]=0x41 ; pp[j++]=indr ;
                                        pv[j]=0x40 ; pp[j++]=dreg ;

        pc[i]="DEC"   ; px[i++]=j ;
                                        pv[j]=0x01 ; pp[j++]=indr ;
                                        pv[j]=0x00 ; pp[j++]=dreg ;

        pc[i]="DECW"  ; px[i++]=j ;
                                        pv[j]=0x81 ; pp[j++]=indr ;
                                        pv[j]=0x80 ; pp[j++]=drep ;

        pc[i]="DI"    ; px[i++]=j ;     pv[j]=0x8F ; pp[j++]=nopr ;

        pc[i]="DJNZ"  ; px[i++]=j ;     pv[j]=0x0a ; pp[j++]=wrrl ;

        pc[i]="EI"    ; px[i++]=j ;     pv[j]=0x9F ; pp[j++]=nopr ;

        pc[i]="INC"   ; px[i++]=j ;
                                        pv[j]=0x21 ; pp[j++]=indr ;
                                        pv[j]=0x0E ; pp[j++]=wreg ;
                                        pv[j]=0x20 ; pp[j++]=dreg ;
                                   
        pc[i]="INCW"  ; px[i++]=j ;
                                        pv[j]=0xA1 ; pp[j++]=indr ;
                                        pv[j]=0xA0 ; pp[j++]=drep ;


        pc[i]="IRET"  ; px[i++]=j ;     pv[j]=0xBF ; pp[j++]=nopr ;


        pc[i]="JP"    ; px[i++]=j ;     pv[j]=0x30 ; pp[j++]=indp ;
                                        pv[j]=0x0D ; pp[j++]=ccda ;

        pc[i]="JR"    ; px[i++]=j ;     pv[j]=0x0B ; pp[j++]=ccra ;

        pc[i]="LD"    ; px[i++]=j ;     pv[j]=0xE4 ; pp[j++]=ldins ;

        pc[i]="LDC"   ; px[i++]=j ;
                                        pv[j]=0xD2 ; pp[j++]=ipwr ;
                                        pv[j]=0xC2 ; pp[j++]=wrip ;

        pc[i]="LDCI"  ; px[i++]=j ;
                                        pv[j]=0xD3 ; pp[j++]=ipiw ;
                                        pv[j]=0xC3 ; pp[j++]=iwip ;


        pc[i]="LDE"   ; px[i++]=j ;
                                        pv[j]=0x92 ; pp[j++]=ipwr ;
                                        pv[j]=0x82 ; pp[j++]=wrip ;

        pc[i]="LDEI"  ; px[i++]=j ;
                                        pv[j]=0x93 ; pp[j++]=ipiw ;
                                        pv[j]=0x83 ; pp[j++]=iwip ;


        pc[i]="NOP"   ; px[i++]=j ;     pv[j]=0xFF ; pp[j++]=nopr ;

        pc[i]="OR"    ; px[i++]=j ;     pv[j]=0x40 ; pp[j++]=arith ;

        pc[i]="POP"   ; px[i++]=j ;
                                        pv[j]=0x51 ; pp[j++]=indr ;
                                        pv[j]=0x50 ; pp[j++]=dreg ;
        pc[i]="PUSH"  ; px[i++]=j ;
                                        pv[j]=0x71 ; pp[j++]=indr ;
                                        pv[j]=0x70 ; pp[j++]=dreg ;

        pc[i]="RCF"   ; px[i++]=j ;     pv[j]=0xCF ; pp[j++]=nopr ;

        pc[i]="RET"   ; px[i++]=j ;     pv[j]=0xAF ; pp[j++]=nopr ;

        pc[i]="RL"    ; px[i++]=j ;
                                        pv[j]=0x91 ; pp[j++]=indr ;
                                        pv[j]=0x90 ; pp[j++]=dreg ;

        pc[i]="RLC"   ; px[i++]=j ;
                                        pv[j]=0x11 ; pp[j++]=indr ;
                                        pv[j]=0x10 ; pp[j++]=dreg ;

        pc[i]="RR"    ; px[i++]=j ;
                                        pv[j]=0xE1 ; pp[j++]=indr ;
                                        pv[j]=0xE0 ; pp[j++]=dreg ;

        pc[i]="RRC"   ; px[i++]=j ;
                                        pv[j]=0xC1 ; pp[j++]=indr ;
                                        pv[j]=0xC0 ; pp[j++]=dreg ;

        pc[i]="SBC"   ; px[i++]=j ;     pv[j]=0x30 ; pp[j++]=arith ;

        pc[i]="SCF"   ; px[i++]=j ;     pv[j]=0xDF ; pp[j++]=nopr ;

        pc[i]="SRA"   ; px[i++]=j ;
                                        pv[j]=0xD1 ; pp[j++]=indr ;
                                        pv[j]=0xD0 ; pp[j++]=dreg ;

        pc[i]="SRP"   ; px[i++]=j ;     pv[j]=0x31 ; pp[j++]=immd ;

        pc[i]="SUB"   ; px[i++]=j ;     pv[j]=0x20 ; pp[j++]=arith ;

        pc[i]="SWAP"  ; px[i++]=j ;
                                        pv[j]=0xF1 ; pp[j++]=indr ;
                                        pv[j]=0xF0 ; pp[j++]=dreg ;

        pc[i]="TCM"   ; px[i++]=j ;     pv[j]=0x60 ; pp[j++]=arith ;

        pc[i]="TM"    ; px[i++]=j ;     pv[j]=0x70 ; pp[j++]=arith ;

        pc[i]="XOR"   ; px[i++]=j ;     pv[j]=0xB0 ; pp[j++]=arith ;

                        px[i] = j ;
        return i ;
}

/*
        End of Z8sym.c
*/


