/*ͻ*\
   Filename:  MENU\MAIN_MN.CPP                    
   Name:      John Wiggins                        
   Course:    Programming II                      
   Function:  Create window and buttons,          
              switch (dispatch) to function user  
              selects.                            
\*ͼ*/
#include <graphics.h>
#include "medusa.h"
#include "msi_wndw.h" // New and improved windows, menus, & buttons header.
#include "mous.h"     // includes dos.h
#include "windw.h"    // includes string.h & event.h

void MainMenu(configure &CurConfig)
{
  ProgramPtr ProgramHead = NULL;
  // Hide mouse while drawing graphics.
  mouse.HideMouse();
  // Flags.
  int repeat = TRUE,  redraw = FALSE;
  // Check to see if file exists.
  int DataExists = exist_file("data\\program.dat");

  // Read in data file (if it exists.)
  if (DataExists == TRUE)
    LoadAll(ProgramHead);
  // By using pointers, I'm given the ability to erase buttons
  // and such from the memory and screen.
  CapWindw *MainMenuWindw;
  Button *View_Butn, *ERA_Butn, *Search_Butn, *Option_Butn,
         *About_Butn, *Quit_Butn, *Create_Butn, *ReadMe_Butn;
  EventMsg eventMsg;

  // Make new buttons.
  View_Butn   = new Button(MENUCENTER + 25, 100, "^View",    64);
  Search_Butn = new Button(MENUCENTER + 25, 140, "^Search",  64);
  ERA_Butn    = new Button(MENUCENTER + 25, 180, "^E.R.A.",  64);
  Option_Butn = new Button(MENUCENTER + 25, 220, "^Option",  64);
  About_Butn  = new Button(MENUCENTER + 25, 260, "^About",   64);
  Quit_Butn   = new Button(MENUCENTER + 25, 300, "^Quit",    64);
  ReadMe_Butn = new Button(MENUCENTER + 25, 340, "^Help", 64);
  if (CurConfig.DebugFlag == TRUE)
  {
    // Make new window.  (With the create button.)
    MainMenuWindw = new CapWindw(MENUCENTER, 50, 245, 390, TRUE, FALSE,
                                 "Main Menu");
    Create_Butn = new Button(MENUCENTER + 25, 380, "^Create", 64);
  }
  // Make new window.  (With/out the create button.)
  else
    MainMenuWindw = new CapWindw(MENUCENTER, 50, 245, 350, TRUE, FALSE,
                                 "Main Menu");
  // Draw menu, for the first time and the buttons.
  MainMenuWindw->DrawWindow();	  View_Butn->DrawWindow();
  Option_Butn->DrawWindow();      ERA_Butn->DrawWindow();
  Search_Butn->DrawWindow();      About_Butn->DrawWindow();
  Quit_Butn->DrawWindow();        ReadMe_Butn->DrawWindow();
  if (CurConfig.DebugFlag == TRUE)
    Create_Butn->DrawWindow();
  // Draw descriptive text.
  setcolor(YELLOW);
  outtextxy(MENUCENTER + 110, 102, "View all");
  outtextxy(MENUCENTER + 110, 116, "records");
  outtextxy(MENUCENTER + 110, 142, "Search for");
  outtextxy(MENUCENTER + 110, 156, "records");
  outtextxy(MENUCENTER + 110, 182, "Edit, remove,");
  outtextxy(MENUCENTER + 110, 196, "and add records");
  outtextxy(MENUCENTER + 110, 222, "Change/view");
  outtextxy(MENUCENTER + 110, 236, "options");
  outtextxy(MENUCENTER + 110, 262, "About program");
  outtextxy(MENUCENTER + 110, 302, "Exit program");
  outtextxy(MENUCENTER + 110, 342, "A little help");
  if (CurConfig.DebugFlag == TRUE)
  {
    outtextxy(MENUCENTER + 110, 382, "Create new");
    outtextxy(MENUCENTER + 110, 396, "records");
  }
  mouse.ShowMouse();
  // Loop until user selects the "Quit" button.
  while (repeat)
  {
    GetEvent(eventMsg);
    // Switch like statement.
    if (View_Butn->Clicked(eventMsg))
    {
      // Only view the data if it exists.
      if (DataExists == TRUE)
        ViewAll(ProgramHead);
      else
        NoDataError(CurConfig);
    }
    if (ERA_Butn->Clicked(eventMsg))
    {
      ERAMenu(ProgramHead, DataExists);
      redraw = TRUE;
    }
    if (Search_Butn->Clicked(eventMsg))
    {
      if (DataExists == TRUE)
      {
        SearchRecord(ProgramHead);
        redraw = TRUE;
      }
      else
        NoDataError(CurConfig);
    }
    if (Option_Butn->Clicked(eventMsg))
    {
      OptionMenu(CurConfig);
      redraw = TRUE;
    }
    if (About_Butn->Clicked(eventMsg))
      About();
    if (Quit_Butn->Clicked(eventMsg))
      Quit(ProgramHead, repeat);
    if (ReadMe_Butn->Clicked(eventMsg))
    {
      ReadMe();
      redraw=TRUE;
    }
    if (Create_Butn->Clicked(eventMsg) && CurConfig.DebugFlag == TRUE)
    {
      Create(DataExists);
      if (DataExists == TRUE)
      {
        Remove(ProgramHead);
        LoadAll(ProgramHead);
      }
    }
    // If the option, search, or ERA menu has been selected,
    // redraw main menu.  (Way around out-of-memory errors.)
    if (redraw == TRUE)
    {
      // Hide mouse when drawing graphics.
      mouse.HideMouse();
      // Remove remains of option/search menus.
      cleardevice();
      // Redraw window and buttons.
      MainMenuWindw->DrawWindow();	      View_Butn->DrawWindow();
      Option_Butn->DrawWindow();              ERA_Butn->DrawWindow();
      Search_Butn->DrawWindow();              About_Butn->DrawWindow();
      Quit_Butn->DrawWindow();                ReadMe_Butn->DrawWindow();
      if (CurConfig.DebugFlag == TRUE)
        Create_Butn->DrawWindow();
      // Redraw descriptive text.
      setcolor(YELLOW);
      outtextxy(MENUCENTER + 110, 102, "View all");
      outtextxy(MENUCENTER + 110, 116, "records");
      outtextxy(MENUCENTER + 110, 142, "Search for");
      outtextxy(MENUCENTER + 110, 156, "records");
      outtextxy(MENUCENTER + 110, 182, "Edit, remove,");
      outtextxy(MENUCENTER + 110, 196, "and add records");
      outtextxy(MENUCENTER + 110, 222, "Change/view");
      outtextxy(MENUCENTER + 110, 236, "options");
      outtextxy(MENUCENTER + 110, 262, "About program");
      outtextxy(MENUCENTER + 110, 302, "Exit program");
      outtextxy(MENUCENTER + 110, 342, "A little help");
      if (CurConfig.DebugFlag == TRUE)
      {
        outtextxy(MENUCENTER + 110, 382, "Create new");
        outtextxy(MENUCENTER + 110, 396, "records");
      }
      mouse.ShowMouse();
      // Reset flag.
      redraw = FALSE;
    } // End if
  } // End while.

  // Delete the window and the buttons.
  delete MainMenuWindw;	  delete View_Butn;
  delete ERA_Butn;        delete Search_Butn;
  delete Option_Butn;     delete About_Butn;
  delete Quit_Butn;       delete ReadMe_Butn;
  if (CurConfig.DebugFlag == TRUE)
    delete Create_Butn;
  // Remove the data from memory.  (Not sure if this is needed.)
  delete ProgramHead;
}

// Quit message.
void Quit(ProgramPtr ProgramHead, int &repeat)
{
  // NOTE:  Ask if user wants to save data even the user hadn't
  //        changed anything.  This is used so flags woulnd't have to be
  //        passed every which way.
  YesNoCanWindw wndw("Quit", "Do you wish to", "save data?");
  wndw.DrawWindow();
  wndw.RunWindow();
  if ((wndw.GetButton() == YES) || (wndw.GetButton() == NO))
  {
    if (wndw.GetButton() == YES)
      SaveAll(ProgramHead);
    repeat = FALSE;
  }
}

