/*ͻ*\
   Filename:  MENU\OPTION_MN.CPP 
   Name:      John Wiggins       
   Course:    Programming II     
   Function:  Option menu.       
\*ͼ*/
#include <stdio.h>
#include <graphics.h>
#include <iostream.h>
#include <conio.h>
#include <stdlib.h>
#include "medusa.h"
#include "msi_wndw.h"
#include "mous.h"   // includes dos.h
#include "windw.h"  // includes string.h & event.h

void OptionMenu(configure &CurConfig)
{
  // I use this to avoid out-of memory error messages while I was
  // attempting to use a buffer.
  cleardevice();
  // Loop value
  int repeat = TRUE;
  CapWindw *Window;
  Button *JokeButn, *TitleButn, *SaveOptButn,
         *CurButn,  *HelpButn,  *MainMenuButn;
  // Event handler.
  EventMsg eventMsg;
  // Make new option buttons and window.
  Window = new CapWindw(MENUCENTER, 110, 265, 265, TRUE, FALSE,
                        "Options Menu");
  JokeButn     = new Button(MENUCENTER+ 40, 160, "^Joke", 64);
  TitleButn    = new Button(MENUCENTER+ 40, 200, "^Title", 64);
  SaveOptButn  = new Button(MENUCENTER+ 40, 240, "^Save", 64);
  CurButn      = new Button(MENUCENTER+ 40, 280, "^Current", 64);
  HelpButn     = new Button(MENUCENTER+ 40, 320, "^Help", 64);
  MainMenuButn = new Button(MENUCENTER+125, 320, "^Menu", 64);

  // Hide the mouse while drawing the graphical window/buttons.
  mouse.HideMouse();

  // Draw option window.
  Window->DrawWindow();
  // Draw option buttons.
  JokeButn->DrawWindow();	  TitleButn->DrawWindow();
  SaveOptButn->DrawWindow();      CurButn->DrawWindow();
  HelpButn->DrawWindow();         MainMenuButn->DrawWindow();

  // Show the mouse after menu/buttons have been drawn.
  mouse.ShowMouse();
  // Show descriptive text.
  setcolor(YELLOW);
  outtextxy(MENUCENTER+125, 162, "Toggle jokes.");
  outtextxy(MENUCENTER+125, 202, "Toggle opening");
  outtextxy(MENUCENTER+125, 216, "title.");
  outtextxy(MENUCENTER+125, 242, "Save options.");
  outtextxy(MENUCENTER+125, 282, "View options.");
  setcolor(BLACK);

  // Loop until Main Menu button has been pressed.
  while(repeat)
  {
    // Get what event has happened.
    GetEvent(eventMsg);
    // Event switch statement.
    if (JokeButn->Clicked(eventMsg))     JokeToggle(CurConfig);
    if (TitleButn->Clicked(eventMsg))    TitleScreenToggle(CurConfig);
    if (SaveOptButn->Clicked(eventMsg))  SaveOptions(CurConfig);
    if (CurButn->Clicked(eventMsg))      DisplayConfig(CurConfig);
    if (HelpButn->Clicked(eventMsg))     Help('O');
    if (MainMenuButn->Clicked(eventMsg)) repeat = FALSE;
  }
  // Remove the window.
  delete Window;
  // Remove the buttons.
  delete JokeButn;	  delete TitleButn;
  delete SaveOptButn;     delete CurButn;
  delete HelpButn;        delete MainMenuButn;
}

/*͸*\
   Function:  Toggle joke option. 
\*;*/
void JokeToggle(configure &CurConfig)
{
  // TempToggle is either On or Off, depending on what the flag is.
  char TempToggle[5];
  if (CurConfig.JokeFlag == TRUE)
  {
    CurConfig.JokeFlag = FALSE;
    strcpy(TempToggle, "Off");
  }
  else
  {
    CurConfig.JokeFlag = TRUE;
    strcpy(TempToggle, "On");
  }
  OKWindw wndw("Toggle Joke", "Jokes are now", TempToggle);
  wndw.DrawWindow();
  wndw.RunWindow();
}

/*͸*\
   Function:  Toggle title screen. 
\*;*/
void TitleScreenToggle(configure &CurConfig)
{
  char TempToggle[5];
  if (CurConfig.ShowTitleFlag == TRUE)
  {
    CurConfig.ShowTitleFlag = FALSE;
    strcpy(TempToggle, "Off");
  }
  else
  {
    CurConfig.ShowTitleFlag = TRUE;
    strcpy(TempToggle, "On");
  }
  OKWindw wndw("Title Screen Toggle", "Show title screen is now", TempToggle);
  wndw.DrawWindow();
  wndw.RunWindow();

}
/*͸*\
   Function:  Save configuration file. 
\*;*/
void SaveOptions(configure CurConfig)
{
  FILE *FilePtr;
  // Create a window to show the drive is being used.
  CapTWindw *DiskAccessWind;
  DiskAccessWind = new CapTWindw("Accessing Disk", "Please wait...", "");
  mouse.HideMouse();
  DiskAccessWind->DrawWindow();
  FilePtr=fopen("database.cfg", "wb");
  delete DiskAccessWind;
  mouse.ShowMouse();
  if (!FilePtr)
    FileError('O', "database.cfg");
  if (fwrite(&CurConfig, sizeof(configure),1,FilePtr) < 1)
    FileError('W', "database.cfg");
  if (fclose(FilePtr))
    FileError('C', "database.cfg");
}

/*͸*\
   Function:  Display current configuration. 
\*;*/
void DisplayConfig(configure CurConfig)
{
  char temp[5];
  DisplayWindw ConfigWndw(217, 80, 200, 150, TRUE, TRUE, "Current Options");
  ConfigWndw.DrawWindow();
  mouse.HideMouse();
  if (CurConfig.JokeFlag == TRUE)
    strcpy(temp, "On");
  else
    strcpy(temp, "Off");
  outtextxy(242, 135, "Internal jokes: ");
  setcolor(BLUE);
  outtextxy(369, 135, temp);
  if (CurConfig.ShowTitleFlag == TRUE)
    strcpy(temp, "On");
  else
    strcpy(temp, "Off");
  setcolor(BLACK);
  outtextxy(242, 150, "Title screen: ");
  setcolor(BLUE);
  outtextxy(354, 150, temp);
  mouse.ShowMouse();
  ConfigWndw.RunWindow();
}