/* -*- Mode: C -*- */
/* CommandScreen.h - CommandScreen class - command menu loop
 * Created by Robert Heller on Wed Dec 11 19:34:26 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#ifndef _COMMANDS_
#define _COMMANDS_
#include <iostream.h>
#include <common.h>
#include <ctype.h>
#include <Terminal.h>

const TextWidth = 80;
const MaxNumCommands = 20;

typedef int (*CommandFunction)();

struct CommandDescr {
	char Text[TextWidth];
	CommandFunction Function;
	int LineNumber;
};

class CommandScreen {
	int NumCommands;
	int currentCommand;
	CommandDescr CommandSpecs[MaxNumCommands];
	char Title[80];
	void HiliteCommand(int Command,Boolean hilite);
public:
	friend class Terminal;
	int Commands	() {return NumCommands;}
	int CurrentCommand () {return currentCommand;}
	    CommandScreen(const char* title,int numcommds,
			  CommandDescr *commands);
	int RunScreen ();
	void RePaint();
};












#endif  
