/* -*- Mode: C -*- */
/* EvalExpr.cc - Evaluate a -only expression (pre-parsed by ParseExpr)
 * Created by Robert Heller on Sat Feb 29 12:04:08 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <iostream.h>
#include <common.h>
#include <Card.h>
#include <PTree.h>
#include <ctype.h>

static int cfstrcmp(const char* a,const char* b)
{
	int comp;
	char aa, bb;
	do {
		aa = *a++;
		bb = *b++;
		if (islower(aa)) aa = toupper(aa);
		if (islower(bb)) bb = toupper(bb);
		comp = aa - bb;
	} while (comp == 0 && aa != 0 && bb != 0);
	return(comp);
}

#define streqp(a,b) ((cfstrcmp(a,b) == 0)?true:false)
#define strnep(a,b) ((cfstrcmp(a,b) != 0)?true:false)
#define strltp(a,b) ((cfstrcmp(a,b) <  0)?true:false)
#define strgtp(a,b) ((cfstrcmp(a,b) >  0)?true:false)
#define strlep(a,b) ((cfstrcmp(a,b) <= 0)?true:false)
#define strgep(a,b) ((cfstrcmp(a,b) >= 0)?true:false)

static Boolean Compare(const Card* card,const Operators op,const Node* a,const Node* b)
{
	switch (op) {
		case Equal:
			if (a->type != FieldNode) return(Compare(card,op,b,a));
			else {
				switch (a->value._field) {
			    		case TypeField: return(card->type == b->value._ctype);
			    		case AuthorField: return(streqp(card->author,b->value._string));
			    		case TitleField: return(streqp(card->title,b->value._string));
			    		case PublisherField: return(streqp(card->publisher,b->value._string));
			    		case CityField: return(streqp(card->city,b->value._string));
			    		case VolumeField: return(card->vol == b->value._int);
			    		case YearField: return(card->year == b->value._int);
			    	}
			}
			break;
		case NotEqual:
			if (a->type != FieldNode) return(Compare(card,op,b,a));
			else {
			    	switch (a->value._field) {
			    		case TypeField: return(card->type != b->value._ctype);
			    		case AuthorField: return(strnep(card->author,b->value._string));
			    		case TitleField: return(strnep(card->title,b->value._string));
			    		case PublisherField: return(strnep(card->publisher,b->value._string));
			    		case CityField: return(strnep(card->city,b->value._string));
			    		case VolumeField: return(card->vol != b->value._int);
			    		case YearField: return(card->year != b->value._int);
			    	}
			}
			break;
		case Less:
			if (a->type != FieldNode) return(Compare(card,Greater,b,a));
			else {
			    	switch (a->value._field) {
			    		case TypeField: return(card->type < b->value._ctype);
			    		case AuthorField: return(strltp(card->author,b->value._string));
			    		case TitleField: return(strltp(card->title,b->value._string));
			    		case PublisherField: return(strltp(card->publisher,b->value._string));
			    		case CityField: return(strltp(card->city,b->value._string));
			    		case VolumeField: return(card->vol < b->value._int);
			    		case YearField: return(card->year < b->value._int);
			    	}
			}
			break;
		case Greater:
			if (a->type != FieldNode) return(Compare(card,Less,b,a));
			else {
			    	switch (a->value._field) {
			    		case TypeField: return(card->type > b->value._ctype);
			    		case AuthorField: return(strgtp(card->author,b->value._string));
			    		case TitleField: return(strgtp(card->title,b->value._string));
			    		case PublisherField: return(strgtp(card->publisher,b->value._string));
			    		case CityField: return(strgtp(card->city,b->value._string));
			    		case VolumeField: return(card->vol > b->value._int);
			    		case YearField: return(card->year > b->value._int);
			    	}
			}
			break;
		case LessEqual:
			if (a->type != FieldNode) return(Compare(card,GreaterEqual,b,a));
			else {
			    	switch (a->value._field) {
			    		case TypeField: return(card->type <= b->value._ctype);
			    		case AuthorField: return(strlep(card->author,b->value._string));
			    		case TitleField: return(strlep(card->title,b->value._string));
			    		case PublisherField: return(strlep(card->publisher,b->value._string));
			    		case CityField: return(strlep(card->city,b->value._string));
			    		case VolumeField: return(card->vol <= b->value._int);
			    		case YearField: return(card->year <= b->value._int);
			    	}
			}
			break;
		case GreaterEqual:
			if (a->type != FieldNode) return(Compare(card,LessEqual,b,a));
			else {
			    	switch (a->value._field) {
			    		case TypeField: return(card->type >= b->value._ctype);
			    		case AuthorField: return(strgep(card->author,b->value._string));
			    		case TitleField: return(strgep(card->title,b->value._string));
			    		case PublisherField: return(strgep(card->publisher,b->value._string));
			    		case CityField: return(strgep(card->city,b->value._string));
			    		case VolumeField: return(card->vol >= b->value._int);
			    		case YearField: return(card->year >= b->value._int);
			    	}
			}
			break;
		default: return(false);
	}
	return(false);
}


Boolean EvalExpr(const Card* card,const Tree* tree)
{
	Node* a = tree->left;
	Node* b = tree->right;
	if (tree == 0) return(true);
	else switch (tree->oper) {
		case Or: return(EvalExpr(card,a->value._tree) ||
				EvalExpr(card,b->value._tree));
		 	 break;
		case And: return(EvalExpr(card,a->value._tree) &&
				 EvalExpr(card,b->value._tree));
		 	  break;
		case Not: return(!EvalExpr(card,a->value._tree));
			  break;
		default: return(Compare(card,tree->oper,a,b));
	}
}
