// This may look like C code, but it is really -*- C++ -*-

// A Bison++ parser, made from ParseExpr.y 

#ifndef stdin
#include <stdio.h>
#include <stdlib.h>
#endif

#line 20 "ParseExpr.y"

#include <iostream.h>
#include <common.h>
#include <ctype.h>
#include <Card.h>
#include <PTree.h>

static Tree* result = 0;

static const struct {
	const char* n;
	Fields f;
} FieldNames[] = {
	{ "TYPE", TypeField },
	{ "AUTHOR", AuthorField },
	{ "TITLE", TitleField },
	{ "PUBLISHER", PublisherField },
	{ "CITY", CityField },
	{ "VOLUME", VolumeField },
	{ "YEAR", YearField }
};

const NumFields = sizeof(FieldNames) / sizeof(FieldNames[0]);

enum TypeErrors {OK, TyOK, NoConstant, NoField, MisMatch};

static TypeErrors TypeCheck(Node* a, Node* b)
{
	if (a->type == FieldNode && b->type == FieldNode) return(NoConstant);
	else if (a->type != FieldNode && b->type != FieldNode) return(NoField);
	else if (a->type != FieldNode) return(TypeCheck(b,a));
	else switch (a->value._field) {
		case TypeField: if (b->type == CardTypeNode) return(TyOK);
				else return(MisMatch);
				break;
		case AuthorField:
		case TitleField:
		case PublisherField:
		case CityField:	if (b->type == StringNode) return(OK);
				else return(MisMatch);
				break;
		case VolumeField:
		case YearField:	if (b->type == IntNode) return(OK);
				else return(MisMatch);
				break;
	}
	return(MisMatch);
}

#define MakeNode(v) (new Node(v))
#define MakeTree(o,l,r) (new Tree(o,l,r))

#if YYDEBUG != 0
int yydebug = 0;
#endif

#ifdef MESSYDOS
#include "prsexptb.h"
#else
#include "ParseExpr.tab.h"
#endif

const int	ParseExpr::INTEGER	= 258;
const int	ParseExpr::STRING	= 259;
const int	ParseExpr::FIELD	= 260;
const int	ParseExpr::CARDTYPE	= 261;
const int	ParseExpr::BADWORD	= 262;
const int	ParseExpr::NOTEQ	= 263;
const int	ParseExpr::LESSEQ	= 264;
const int	ParseExpr::GREATEREQ	= 265;


#define	YYFINAL		31
#define	YYFLAG		-32768
#define	YYNTBASE	19

#define YYTRANSLATE(x) ((unsigned)(x) <= 265 ? yytranslate[x] : 22)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    16,     2,     2,     2,     2,    14,     2,    17,
    18,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    11,
    13,    12,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    15,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10
};

static const short yyrline[] = {     0,
   103,   107,   109,   111,   113,   115,   128,   141,   155,   169,
   183,   199,   201,   203,   205,   207
};

static const char * const yytname[] = {     0,
"error","$illegal.","INTEGER","STRING","FIELD","CARDTYPE","BADWORD","NOTEQ","LESSEQ","GREATEREQ",
"'<'","'>'","'='","'&'","'|'","'!'","'('","')'","result"
};

static const short yyr1[] = {     0,
    19,    20,    20,    20,    20,    20,    20,    20,    20,    20,
    20,    21,    21,    21,    21,    21
};

static const short yyr2[] = {     0,
     1,     3,     2,     3,     3,     3,     3,     3,     3,     3,
     3,     1,     1,     1,     1,     1
};

static const short yydefact[] = {     0,
    13,    12,    14,    15,    16,     0,     0,     1,     0,     3,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     2,
     5,     4,     7,    10,    11,     8,     9,     6,     0,     0,
     0
};

static const short yydefgoto[] = {    29,
     8,     9
};

static const short yypact[] = {    -3,
-32768,-32768,-32768,-32768,-32768,    -3,    -3,    -7,     7,-32768,
    19,    -3,    -3,    25,    25,    25,    25,    25,    25,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,     9,    10,
-32768
};

static const short yypgoto[] = {-32768,
    -1,     8
};


#define	YYLAST		37


static const short yytable[] = {     1,
     2,     3,     4,     5,    10,    11,    12,    13,    30,    31,
    21,    22,     6,     7,    14,    15,    16,    17,    18,    19,
     0,    23,    24,    25,    26,    27,    28,     1,     2,     3,
     4,     5,    12,    13,     0,     0,    20
};

static const short yycheck[] = {     3,
     4,     5,     6,     7,     6,     7,    14,    15,     0,     0,
    12,    13,    16,    17,     8,     9,    10,    11,    12,    13,
    -1,    14,    15,    16,    17,    18,    19,     3,     4,     5,
     6,     7,    14,    15,    -1,    -1,    18
};
#define YYPURE 1

// This may look like C code, but it is really -*- C++ -*-

/* Skeleton output parser for bison++,
   Copyright (C) 1984 Bob Corbett and Richard Stallman
   Copyright (C) 1989 Larry M. Augustin

   Adapted from the original for C++ by Larry M. Augustin.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYFAIL		goto yyerrlab;
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYIMPURE
#define YYLEX		yylex()
#endif

#ifndef YYPURE
#define YYLEX		yylex(&yylval, &yylloc)
#endif

/*  YYMAXDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYMAXDEPTH
#define YYMAXDEPTH 200
#endif

/*  YYMAXLIMIT is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#ifndef YYMAXLIMIT
#define YYMAXLIMIT 10000
#endif

int ParseExpr::yyparse() {
  register int yystate;
  register int yyn;
  register short *yyssp;
  register ParseExpr_YYSTYPE *yyvsp;
  ParseExpr_YYLTYPE *yylsp;
  int yyerrstatus;  // number of tokens to shift before error messages enabled
  int yychar1;	    // lookahead token as an internal (translated) token number

  short	yyssa[YYMAXDEPTH];	//  the state stack
  ParseExpr_YYSTYPE yyvsa[YYMAXDEPTH];	//  the semantic value stack
  ParseExpr_YYLTYPE yylsa[YYMAXDEPTH];	//  the location stack

  short *yyss = yyssa;	   //  refer to the stacks thru separate pointers
  ParseExpr_YYSTYPE *yyvs = yyvsa;   //  to allow yyoverflow to reallocate them elsewhere
  ParseExpr_YYLTYPE *yyls = yylsa;

  int yymaxdepth = YYMAXDEPTH;

#ifndef YYPURE
  int yychar;
  ParseExpr_YYSTYPE yylval;
  ParseExpr_YYLTYPE yylloc;
  int yynerrs;
#endif

  ParseExpr_YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
  yylsp = yyls;

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yymaxdepth - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      ParseExpr_YYSTYPE *yyvs1 = yyvs;
      ParseExpr_YYLTYPE *yyls1 = yyls;
      short *yyss1 = yyss;

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yymaxdepth);

      yyss = yyss1; yyvs = yyvs1; yyls = yyls1;
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yymaxdepth >= YYMAXLIMIT)
	yyerror("parser stack overflow");
      yymaxdepth *= 2;
      if (yymaxdepth > YYMAXLIMIT)
	yymaxdepth = YYMAXLIMIT;
      yyss = (short *) alloca (yymaxdepth * sizeof (*yyssp));
      bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (ParseExpr_YYSTYPE *) alloca (yymaxdepth * sizeof (*yyvsp));
      bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (ParseExpr_YYLTYPE *) alloca (yymaxdepth * sizeof (*yylsp));
      bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif // YYLSP_NEEDED
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yymaxdepth);
#endif

      if (yyssp >= yyss + yymaxdepth - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Next token is %d (%s)\n", yychar, yytname[yychar1]);
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      if (yylen == 1)
	fprintf (stderr, "Reducing 1 value via line %d, ",
		 yyrline[yyn]);
      else
	fprintf (stderr, "Reducing %d values via line %d, ",
		 yylen, yyrline[yyn]);
    }
#endif


  switch (yyn) {

case 1:
#line 104 "ParseExpr.y"
{ result = yyvsp[0].trval; ;
    break;}
case 2:
#line 108 "ParseExpr.y"
{ yyval.trval = yyvsp[-1].trval; ;
    break;}
case 3:
#line 110 "ParseExpr.y"
{ yyval.trval = MakeTree(Not,MakeNode(yyvsp[0].trval),0); ;
    break;}
case 4:
#line 112 "ParseExpr.y"
{ yyval.trval = MakeTree(Or,MakeNode(yyvsp[-2].trval),MakeNode(yyvsp[0].trval)); ;
    break;}
case 5:
#line 114 "ParseExpr.y"
{ yyval.trval = MakeTree(And,MakeNode(yyvsp[-2].trval),MakeNode(yyvsp[0].trval)); ;
    break;}
case 6:
#line 116 "ParseExpr.y"
{
				switch (TypeCheck(yyvsp[-2].nval,yyvsp[0].nval)) {
					case NoConstant: yyerror("Missing constant!");
							 YYABORT;
					case NoField: yyerror("Missing field!");
						      YYABORT;
					case MisMatch: yyerror("Type mismatch!");
						       YYABORT;
					case TyOK:
					case OK: yyval.trval = MakeTree(Equal,yyvsp[-2].nval,yyvsp[0].nval);
				}
			;
    break;}
case 7:
#line 129 "ParseExpr.y"
{
				switch (TypeCheck(yyvsp[-2].nval,yyvsp[0].nval)) {
					case NoConstant: yyerror("Missing constant!");
							 YYABORT;
					case NoField: yyerror("Missing field!");
						      YYABORT;
					case MisMatch: yyerror("Type mismatch!");
						       YYABORT;
					case TyOK:
					case OK: yyval.trval = MakeTree(NotEqual,yyvsp[-2].nval,yyvsp[0].nval);
				}
			;
    break;}
case 8:
#line 142 "ParseExpr.y"
{
				switch (TypeCheck(yyvsp[-2].nval,yyvsp[0].nval)) {
					case NoConstant: yyerror("Missing constant!");
							 YYABORT;
					case NoField: yyerror("Missing field!");
						      YYABORT;
					case MisMatch: yyerror("Type mismatch!");
						       YYABORT;
					case TyOK: yyerror("< not allowed for Type");
						   YYABORT;
					case OK: yyval.trval = MakeTree(Less,yyvsp[-2].nval,yyvsp[0].nval);
				}
			;
    break;}
case 9:
#line 156 "ParseExpr.y"
{
				switch (TypeCheck(yyvsp[-2].nval,yyvsp[0].nval)) {
					case NoConstant: yyerror("Missing constant!");
							 YYABORT;
					case NoField: yyerror("Missing field!");
						      YYABORT;
					case MisMatch: yyerror("Type mismatch!");
						       YYABORT;
					case TyOK: yyerror("> not allowed for Type");
						   YYABORT;
					case OK: yyval.trval = MakeTree(Greater,yyvsp[-2].nval,yyvsp[0].nval);
				}
			;
    break;}
case 10:
#line 170 "ParseExpr.y"
{
				switch (TypeCheck(yyvsp[-2].nval,yyvsp[0].nval)) {
					case NoConstant: yyerror("Missing constant!");
							 YYABORT;
					case NoField: yyerror("Missing field!");
						      YYABORT;
					case MisMatch: yyerror("Type mismatch!");
						       YYABORT;
					case TyOK: yyerror("<= not allowed for Type");
						   YYABORT;
					case OK: yyval.trval = MakeTree(LessEqual,yyvsp[-2].nval,yyvsp[0].nval);
				}
			;
    break;}
case 11:
#line 184 "ParseExpr.y"
{
				switch (TypeCheck(yyvsp[-2].nval,yyvsp[0].nval)) {
					case NoConstant: yyerror("Missing constant!");
							 YYABORT;
					case NoField: yyerror("Missing field!");
						      YYABORT;
					case MisMatch: yyerror("Type mismatch!");
						       YYABORT;
					case TyOK: yyerror(">= not allowed for Type");
						   YYABORT;
					case OK: yyval.trval = MakeTree(GreaterEqual,yyvsp[-2].nval,yyvsp[0].nval);
				}
			;
    break;}
case 12:
#line 200 "ParseExpr.y"
{ yyval.nval = MakeNode(yyvsp[0].sval); ;
    break;}
case 13:
#line 202 "ParseExpr.y"
{ yyval.nval = MakeNode(yyvsp[0].ival); ;
    break;}
case 14:
#line 204 "ParseExpr.y"
{ yyval.nval = MakeNode(yyvsp[0].fval); ;
    break;}
case 15:
#line 206 "ParseExpr.y"
{ yyval.nval = MakeNode(yyvsp[0].tval); ;
    break;}
case 16:
#line 208 "ParseExpr.y"
{ yyerror("Unknown word"); YYABORT; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */


  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;
      yyerror("parse error");
    }

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 211 "ParseExpr.y"


static char* original;
static char* curpointer;

Tree* ParseOnly(char* string)
{
	ParseExpr parser;
	original = string;
	curpointer = original;
	if (parser.yyparse() == 0) return(result);
	else return(0);
}

void ParseExpr::yyerror(char* message)
{
	cout << message << "\n";
	cout << original << "\n";
	for (int pos = curpointer-original; pos > 0; pos--) cout << '.';
	cout << "^\n";
}

int ParseExpr::yylex()
{
	static char word[256];
	
	while (*curpointer != 0 && *curpointer <= ' ') curpointer++;
	if (*curpointer == 0) return(YYEOF);
	else if (isdigit(*curpointer)) {
		char* p = word;
		while (isdigit(*curpointer)) *p++ = *curpointer++;
		*p++ = 0;
		yylval.ival = atoi(word);
		return(INTEGER);
	} else if (*curpointer == '"') {
		curpointer++;
		char* p = word;
		while (*curpointer != '"') {
			if (*curpointer == '\\') curpointer++;
			*p++ = *curpointer++;
		}
		curpointer++;
		*p++ = 0;
		yylval.sval = new char[strlen(word)+1];
		strcpy(yylval.sval,word);
		return(STRING);
	} else if (isalpha(*curpointer)) {
		char* p = word;
		while (isalpha(*curpointer)) {
			char c = *curpointer++;
			if (islower(c)) *p++ = toupper(c);
			else *p++ = c;
		}
		*p++ = 0;
		if (CardTypeNameP(word)) {
			yylval.tval = NameType(word);
			return(CARDTYPE);
		} else {
			for (int i = 0; i < NumFields; i++) {
				if (strcmp(word,FieldNames[i].n) == 0) {
					yylval.fval = FieldNames[i].f;
					return(FIELD);
				}
			}
			return(BADWORD);
		}
	} else if (*curpointer == '!' && *(curpointer+1) == '=') {
		curpointer += 2;
		return(NOTEQ);
	} else if (*curpointer == '<' && *(curpointer+1) == '=') {
		curpointer += 2;
		return(LESSEQ);
	} else if (*curpointer == '>' && *(curpointer+1) == '=') {
		curpointer += 2;
		return(GREATEREQ);
	} else return(*curpointer++);
}


