*=================================================================
* nB (nano Base)
* Copyright (c) 1996-1997   Daniele Giacomini
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation; either version 2 of
* the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the Free
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
* USA.
*
*=================================================================
* #IFDEF - IFNDEF organisation.
*
* If RUNTIME is defined, the source is compiled using less code,
* enough to make a run time interpreter
*
* If RDD is defined, all Replaceable database drivers are
* linked with nB, otherwise, only DBFNTX and DBFNDX are
* included.
*
* If LINK is defined, the source is compiled using less code,
* enough to make an object to link with a macro to be compiled
* to generate a .EXE file.
*
*=================================================================
* This program uses an external library.
*
*----------------------------------------------------------------
* ClipMous.LIB
* Simple library for mouse support under Clipper
* (c) Martin Brousseau
* FREEWARE (supposed)
*
* composition:
*      CLIPMOUS.LIB
*
* the original package is: CLIPMOUS.ZIP
*
*=================================================================
* STANDARD INCLUDE
*=================================================================

#include "standard.ch"




*=================================================================
* PROGRAM INFO/COPYRIGHT
*=================================================================
#define PROGRAM_VERSION;
    "1997.01"

#define PROGRAM_C;
    "(c) 1996-1997 Daniele Giacomini"

#define PROGRAM_COPYRIGHT_START;
    "nB (nano Base) " + PROGRAM_VERSION + " - " + PROGRAM_C + "." +;
    NL(1) +;
    "nB comes with ABSOLUTELY NO WARRANTY, " +;
    "see file COPYING for details." +;
    NL(1) +;
    "This is free software, " +;
    "and you are welcome to redistribute it" +;
    NL(1) +;
    "under certain conditions; again see file COPYING for " +;
    "details." +;
    NL(1)

#ifndef RUNTIME
    #define PROGRAM_COPYRIGHT_HELP;
    NL(1) +;
    "nB [<nB_parameters>] [<macro_filename>] " +;
    "[<macro_parameters>]" +;
    NL(2) +;
    "<nB_parameters>    -c  Suppress copyright notice." +;
    NL(1) +;
    "                   -w  Suppress wait-wheel." +;
    NL(1) +;
    "                   -?  This help." +;
    NL(1) +;
    "<macro_filename>   Macro file name to be executed." +;
    NL(1) +;
    "<macro_parameters> Parameters used from the macro." +;
    NL(1) +;
    "nB without parameters starts the dot/xbase system." +;
    NL(2) +;
    "nB -m <macro_filename> [<compiled_macro_filename>]" +;
    NL(1) +;
    '"Compiles" the text file <macro_filename> into ' +;
    "a nB macro." +;
    NL(1)
#else
    #define PROGRAM_COPYRIGHT_HELP;
    NL(1) +;
    "nB RUNTIME interpreter" +;
    NL(1) +;
    "nB [<nB_parameters>] <macro_filename> " +;
    "[<macro_parameters>]" +;
    NL(2) +;
    "<nB_parameters>    -w  Suppress wait-wheel." +;
    NL(1) +;
    "                   -?  This help." +;
    NL(1) +;
    "<macro_filename>   Macro file name to be executed." +;
    NL(1) +;
    "<macro_parameters> Parameters used from the macro." +;
    NL(1)
#endif

#define PROGRAM_COPYRIGHT_INFO;
    "nB (nano Base) " + PROGRAM_VERSION + " - FREE xBase" +;
    NL(1) +;
    PROGRAM_C + "." +;
    NL(1) +;
    "This program is free software; you can redistribute it " +;
    "and/or modify it under the terms of the GNU General " +;
    "Public License as published by the Free Software " +;
    "Foundation; either version 2 of the License, or " +;
    "(at your option) any later version." +;
    NL(1) +;
    "This program is distributed in the hope that it will be " +;
    "useful, but WITHOUT ANY WARRANTY; without even the " +;
    "implied warranty of MERCHANTABILITY or FITNESS FOR A " +;
    "PARTICULAR PURPOSE.  See the GNU General Public License for " +;
    "more details." +;
    NL(1) +;
    "You should have received a copy of the GNU General " +;
    "Public License along with this program; if not, write to " +;
    "the Free Software Foundation, Inc., 675 Mass Ave, " +;
    "Cambridge, MA 02139, USA." +;
    NL(2) +;
    "Send your comments, suggestions, bug reports and " +;
    "english text corrections to:" +;
    NL(1) +;
    AUTHOR_ADDRESS

*=================================================================
* GENERAL USE
*=================================================================

#define _KEY_CTRLY;
    "[Ctrl]+[Y] delete/recall"
#define _KEY_CTRLW;
    "[Ctrl]+[W] Confirm modification"
#define _KEY_ENTER;
    "[Enter] select"
#define _KEY_ESC_EXIT_ENTER_UP_DOWN;
    "[Esc] exit  [Enter] select  []/[] move"
#define _KEY_ESC_CANCEL_F1;
    "[Esc] cancel  [F1] help"
#define _KEY_ESC_CANCEL_F1_F2_PGDN;
    "[Esc] cancel  [F1] help  [F2] list  [Pag] confirm"
#define _KEY_ESC_CANCEL_PGDN;
    "[Esc] cancel  [Pag] confirm"
#define _KEY_ESC_END_F1;
    "[Esc] end  [F1] help"
#define _KEY_ESC_EXIT_F1;
    "[Esc] exit  [F1] help"
#define _KEY_ESC_EXIT_F1_PGDN;
    "[Esc] exit  [F1] help  [Pag] continue"
#define _KEY_ESC_EXIT_F1_F2_PGDN;
    "[Esc] exit  [F1] help  [F2] list  [Pag] confirm"
#define _KEY_ESC_EXIT_F1_F2_ENTER_UP_DOWN;
    "[Esc] exit  [F1] help  [F2] list " +;
    "[Enter] select  []/[] move"
#define _KEY_ESC_EXIT_F1_F2_CTRLY;
    "[Esc] exit  [F1] help  [F2] list  [Ctrl]+[Y] delete"
#define _KEY_ESC_EXIT_F1_F10;
    "[Esc] exit  [F1] help  [F10] menu"
#define _KEY_ESC_NORMAL_F1_PGDN;
    "[Esc] normal  [F1] help  [Pag] continue"
#define _KEY_F2_PGDN;
    "[F2] list/dir  [Pag] confirm"
#define _KEY_MENU_H;
    "[Esc] exit  [-]/[-] move cursor  [Enter] open menu"
#define _KEY_MENU_V;
    "[Esc] exit  [-]/[-]/[]/[] cursor movement  [Enter] select"
#define _KEY_MENU_P;
    "[Esc] exit  []/[] cursor movement  [Enter] select"
#define _KEY_UP_DOWN;
    "[]/[] move cursor"
#define _KEY_UP_DOWN_ENTER;
    "[]/[] move  [Enter] select"


#define _MEMVAR_MACRO_RECORDER          c_MacroRec
#define _MEMVAR_MACRO_RECORDER_NAME     "c_MacroRec"
#define _MEMVAR_MACRO_RECORDING         l_MacroRec
#define _MEMVAR_MACRO_RECORDING_NAME    "l_MacroRec"
#define _MEMVAR_PAR0                c_Par0
#define _MEMVAR_PAR1                c_Par1
#define _MEMVAR_PAR2                c_Par2
#define _MEMVAR_PAR3                c_Par3
#define _MEMVAR_PAR4                c_Par4
#define _MEMVAR_PAR5                c_Par5
#define _MEMVAR_PAR6                c_Par6
#define _MEMVAR_PAR7                c_Par7
#define _MEMVAR_PAR8                c_Par8
#define _MEMVAR_PAR9                c_Par9

#define _MENU_PULLDOWN_WIDTH 28


#define _STDHLP_START                   NL(2) + ""
#define _STDHLP_EVER_TRUE;
    NL(2) +;
    "The condition .T. (point, T, point) is ever true."
#define _STDHLP_WHILE_CONDITION;
    NL(2) +;
    "'WHILE' identifies a conditional execution " +;
    "that is carried out until the condition is true. " +;
    "When for the first time the checked condition is false, " +;
    "the conditional execution is stopped."
#define _STDHLP_FOR_CONDITION;
    NL(2) +;
    "'FOR' identifies a conditional execution " +;
    "that is carried out all the times that the condition is true."


*=================================================================

