;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;       Forms Dictionary system, menus                                    ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; --------------------------------------------------------------------------
; Procedure   : FormsMain()
; Description : displays the customer/prospect tracking main menu.
; --------------------------------------------------------------------------

proc FormsMain()
   private MenuItemSelected, ExitApplication

ExitApplication = False

while ExitApplication = False

   DisplayMenu("Fmain")
   getmenuselection TO MenuItemSelected

   switch
      case MenuItemSelected = "Exit/Yes" :
         ExitApplication = True

      case MenuItemSelected = "Select/Pick" :
         SelectDirectory()

      case MenuItemSelected = "Select/Use" :
         controls["Directory"] = "Usedata"
         controls["Menustate"] = "None"
         CheckAccess()

      case MenuItemSelected = "Analyse" :
         ScanForms()

      case MenuItemSelected = "Report/Printer" :
         PrinterSetup()

      case substr(MenuItemSelected, 1, 6) = "Report" :
         FormsReport(MenuItemSelected)

      case (MenuItemSelected = "Help") :
         ShowHelp("FmainHelp", 3)

   endswitch

endwhile
clearpulldown

endproc
WriteLib AppLib FormsMain
Release procs FormsMain

; --------------------------------------------------------------------------
; Procedure   : DisplayMenu()
; Description : Display a pull down menu
;    Argument - name of the menu to show
; --------------------------------------------------------------------------

PROC DisplayMenu(MenuName)

if controls["MenuState"] = MenuName then
   return
endif
if controls["MenuState"] <> "None" then
      clearpulldown
endif
controls["MenuState"] = MenuName

switch
   case MenuName = "Fmain":
      DisplayMenuFmain()
   case MenuName = "Edit":
      DisplayMenuEdit()
   case MenuName = "Select":
      DisplayMenuSelect()
   case MenuName = "Help":
      DisplayMenuHelp()
endswitch

ENDPROC
WriteLib AppLib DisplayMenu
Release procs DisplayMenu

; --------------------------------------------------------------------------
; Procedure   : DisplayMenuFmain()
; Description : Display the forms dictionary main menu
; --------------------------------------------------------------------------

proc DisplayMenuFmain()

echo normal
echo off
   SHOWPULLDOWN
      "Select" : "Select the directory and forms to be documented" :
         "Select"
         SUBMENU
            "Pick directory" : "Specify a directory to be documented" :
               "Select/Pick",
            "Use stored data" :
               "Use the data already in the forms dictionary tables" :
               "Select/Use"
         ENDSUBMENU,
      "Analyse"  : "Analyse the selected forms, build form dictionary" :
         "Analyse",
      "Report" : "Print forms dictionary reports." : "Report"
         SUBMENU
            "Images":
               "Print screen layouts for all forms in the dictionary" :
                  "Report/Images",
            "Fields":
               "Print field details for all forms in the dictionary" :
                  "Report/Fields",
            "Combined": "Print combined image and field details":
               "Report/Combined"
               SUBMENU
                  "Single form": "Combined report for a single form":
                     "Report/Single",
                  "All forms":
                     "Combined report for all forms in the dictionary":
                     "Report/All"
               ENDSUBMENU,
            "Where used":
               "Print where used list for all fields in the dictionary":
                  "Report/Where",
            "Embedded forms":
               "Print details of embedded forms" : "Report/Links",
            "Printer setup": "Specify printer setup to be used for reports":
               "Report/Printer"
         ENDSUBMENU,
      "Help"   : "Help about the options on this menu" : "Help",
      "Exit"   : "Exit from the forms dictionary" : "Exit"
         SUBMENU
            "Yes" : "Exit from the NWEEC database application" : "Exit/Yes",
            "No"  : "Do not exit. Return to the menu" : "Exit/No"
         ENDSUBMENU
   ENDMENU

switch
   case controls["Dictionary"] = "None":
   menudisable "Select/Use"
   menudisable "Analyse"
   menudisable "Report"
   case controls["Dictionary"] = "Analyse":
   menudisable "Select/Use"
   menudisable "Report"
   case controls["Dictionary"] = "Usedata":
   menudisable "Analyse"
endswitch

endproc
WriteLib AppLib DisplayMenuFmain
Release procs DisplayMenuFmain

; --------------------------------------------------------------------------
; Procedure   : DisplayMenuEdit()
; Description : Display the edit form list menu
; --------------------------------------------------------------------------

proc DisplayMenuEdit()

   SHOWPULLDOWN
      "Do It" : "Save the form list for documentating" : "Do_It!",
      "Undo"  : "Replace the last deleted entry" : "Undo",
      "Cancel" : "Do not save the list, Return to the main menu": "Cancel"
;     "Help" : "Help about defining queries" : "Help"
   ENDMENU

endproc
WriteLib AppLib DisplayMenuEdit
Release procs DisplayMenuEdit

; --------------------------------------------------------------------------
; Procedure   : DisplayMenuSelect()
; Description : Display Select/Cancel menu
; --------------------------------------------------------------------------

proc DisplayMenuSelect()

   SHOWPULLDOWN
      "Select" : "Save the form list for documentating" : "Select",
      "Cancel" : "Do not save the list, Return to the main menu": "Cancel"
;     "Help" : "Help about defining queries" : "Help"
   ENDMENU

endproc
WriteLib AppLib DisplayMenuSelect
Release procs DisplayMenuSelect

; --------------------------------------------------------------------------
; Procedure   : DisplayMenuHelp()
; Description : Display the view help menu
; --------------------------------------------------------------------------

proc DisplayMenuHelp()

   SHOWPULLDOWN
      "Next" : "View the next page" : "Next",
      "Previous" : "View the previous page" : "Previous",
      "Return" : "Return to the menu" : "Return"
   ENDMENU

endproc
WriteLib AppLib DisplayMenuHelp
Release procs DisplayMenuHelp
